/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.wizard.cube;

import com.elixirtech.data2.DataSchema;
import com.elixirtech.ensemble.cube.ICubeWrapper;
import com.elixirtech.icons.EnsembleIcons;
import com.elixirtech.report2.I18N;
import com.elixirtech.ui.wizard.Wizard;
import com.elixirtech.wizard.cube.AxisPage;
import com.elixirtech.wizard.cube.CachePage;
import com.elixirtech.wizard.cube.FlagsPage;
import com.elixirtech.wizard.cube.HierarchyPage;
import com.elixirtech.wizard.cube.ICubeWizard;
import com.elixirtech.wizard.cube.MeasurePage;
import java.awt.Color;
import javax.swing.Icon;
import javax.swing.JColorChooser;
import javax.swing.JComponent;

public class CubeWizard
extends Wizard
implements ICubeWizard {
    private ICubeWrapper m_ICube;
    private HierarchyPage m_HierarchyPage;
    private AxisPage m_AxisPage;
    private MeasurePage m_MeasurePage;
    private FlagsPage m_FlagsPage;
    private CachePage m_CachePage;
    private Icon m_CubeIcon;

    public CubeWizard(ICubeWrapper iCubeWrapper) {
        super(I18N.ERD.getString("CubeWizard.TITLE"));
        this.m_ICube = iCubeWrapper;
        this.m_CubeIcon = EnsembleIcons.CUBEHEADER;
        this.setReadOnly(iCubeWrapper.isReadOnly());
        this.buildPages();
    }

    @Override
    public ICubeWrapper getCube() {
        return this.m_ICube;
    }

    @Override
    public boolean performFinish() {
        this.m_HierarchyPage.performFinish();
        this.m_AxisPage.performFinish();
        this.m_CachePage.performFinish();
        this.m_MeasurePage.performFinish();
        this.m_FlagsPage.performFinish();
        this.m_ICube.setDirty();
        return true;
    }

    public static void colorAction(JComponent jComponent, JComponent jComponent2) {
        Color color = jComponent2.getBackground();
        String string = I18N.ERD.getString("GOWizard.CHOOSE_COLOR");
        Color color2 = JColorChooser.showDialog(jComponent, string, color);
        if (color2 != null) {
            jComponent2.setBackground(color2);
        }
    }

    protected DataSchema getSchema() {
        return this.m_ICube.getDataSchema();
    }

    protected String[] getHierarchyNames() {
        return this.m_HierarchyPage.getHierarchyNames();
    }

    protected void buildPages() {
        this.m_HierarchyPage = new HierarchyPage();
        this.m_HierarchyPage.setIcon(this.m_CubeIcon);
        this.m_AxisPage = new AxisPage();
        this.m_AxisPage.setIcon(this.m_CubeIcon);
        this.m_MeasurePage = new MeasurePage();
        this.m_MeasurePage.setIcon(this.m_CubeIcon);
        this.m_FlagsPage = new FlagsPage();
        this.m_FlagsPage.setIcon(this.m_CubeIcon);
        this.m_CachePage = new CachePage();
        this.m_CachePage.setIcon(this.m_CubeIcon);
        this.m_Pages.add(this.m_HierarchyPage);
        this.m_Pages.add(this.m_AxisPage);
        this.m_Pages.add(this.m_MeasurePage);
        this.m_Pages.add(this.m_FlagsPage);
        this.m_Pages.add(this.m_CachePage);
        this.m_HierarchyPage.setWizard(this);
        this.m_AxisPage.setWizard(this);
        this.m_MeasurePage.setWizard(this);
        this.m_FlagsPage.setWizard(this);
        this.m_CachePage.setWizard(this);
    }
}

