/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.wizard.cube;

import com.elixirtech.arch.wizard.RelativeLayoutWizardPage;
import com.elixirtech.ensemble.cube.ICubeWrapper;
import com.elixirtech.report2.I18N;
import com.elixirtech.ui.SwingFactory;
import com.elixirtech.ui.SwingUtil;
import com.elixirtech.ui.wizard.IWizard;
import com.elixirtech.wizard.cube.ICubeWizard;
import javax.swing.JCheckBox;
import javax.swing.JTextField;

public class FlagsPage
extends RelativeLayoutWizardPage {
    public static final String NAME = "Flags";
    private ICubeWrapper m_ICube;
    private JCheckBox m_CollapseRows = SwingFactory.newCheckBox("collapse-rows");
    private JCheckBox m_CollapseColumns = SwingFactory.newCheckBox("collapse-cols");
    private JCheckBox m_KeepRowTotals = SwingFactory.newCheckBox("keep-rows");
    private JCheckBox m_KeepColumnTotals = SwingFactory.newCheckBox("keep-cols");
    private JTextField m_RowTitle = SwingFactory.newTextField("row-title");
    private JTextField m_ColumnTitle = SwingFactory.newTextField("col-title");
    private JTextField m_TotalRowTitle = SwingFactory.newTextField("total-row-title");
    private JTextField m_TotalColumnTitle = SwingFactory.newTextField("total-col-title");
    private JCheckBox m_ShowRowTotalsAfterDetails = SwingFactory.newCheckBox("show-row-totals-after");
    private JCheckBox m_ShowColumnTotalsAfterDetails = SwingFactory.newCheckBox("show-col-totals-after");
    private JCheckBox m_ShowRowHeaderLabels = SwingFactory.newCheckBox("show-row-header-labels");

    public FlagsPage() {
        super(NAME, "Cache");
        I18N.ERD_MAP.injectObject(null, this, "CubeFlagsPage");
    }

    @Override
    public void setWizard(IWizard iWizard) {
        super.setWizard(iWizard);
        this.m_ICube = ((ICubeWizard)((Object)iWizard)).getCube();
        this.buildComponent();
    }

    @Override
    public void setVisible(boolean bl) {
        super.setVisible(bl);
        if (bl) {
            boolean bl2 = !this.m_ICube.isReadOnly();
            this.m_Component.setEnabled(bl2);
            SwingUtil.setEnabled(this.m_Component, bl2);
        }
    }

    public void performFinish() {
        this.m_ICube.setRowTitle(this.m_RowTitle.getText());
        this.m_ICube.setColumnTitle(this.m_ColumnTitle.getText());
        this.m_ICube.setRowTotalsTitle(this.m_TotalRowTitle.getText());
        this.m_ICube.setColumnTotalsTitle(this.m_TotalColumnTitle.getText());
        this.m_ICube.setCollapseRows(this.m_CollapseRows.isSelected());
        this.m_ICube.setCollapseColumns(this.m_CollapseColumns.isSelected());
        if (this.m_ICube.canControlTotals()) {
            this.m_ICube.setKeepRowTotals(this.m_KeepRowTotals.isSelected());
            this.m_ICube.setKeepColumnTotals(this.m_KeepColumnTotals.isSelected());
            this.m_ICube.setShowRowTotalsAfterDetails(this.m_ShowRowTotalsAfterDetails.isSelected());
            this.m_ICube.setShowColumnTotalsAfterDetails(this.m_ShowColumnTotalsAfterDetails.isSelected());
            this.m_ICube.setShowRowHeaderLabels(this.m_ShowRowHeaderLabels.isSelected());
        }
    }

    @Override
    public boolean isPageComplete() {
        return true;
    }

    public boolean isKeepColumnTotals() {
        return this.m_KeepColumnTotals.isSelected();
    }

    public String getRowTitle() {
        return this.m_RowTitle.getText();
    }

    public String getColumnTitle() {
        return this.m_ColumnTitle.getText();
    }

    @Override
    public void setNextPage(String string) {
        this.m_NextPage = string;
    }

    protected void buildComponent() {
        boolean bl = this.m_ICube.isShowUITitles();
        this.addLabel(SwingFactory.newLabel("row-title-label"));
        this.addLabel(SwingFactory.newLabel("col-title-label"));
        this.m_Component.add(this.m_RowTitle);
        this.m_Component.add(this.m_ColumnTitle);
        Object object = "row-title-label,col-title-label";
        String string = "col-title";
        if (bl) {
            this.addLabel(SwingFactory.newLabel("total-row-title-label"));
            this.addLabel(SwingFactory.newLabel("total-col-title-label"));
            this.m_Component.add(this.m_TotalRowTitle);
            this.m_Component.add(this.m_TotalColumnTitle);
            object = (String)object + ",total-row-title-label,total-col-title-label";
            string = "total-col-title";
        }
        this.stickTop("row-title");
        this.putRight("row-title", (String)object, 10);
        this.stickRight("row-title");
        this.alignBelow("col-title", "row-title");
        this.stickRight("col-title");
        this.alignBelow("total-row-title", "col-title");
        this.stickRight("total-row-title");
        this.alignBelow("total-col-title", "total-row-title");
        this.stickRight("total-col-title");
        String string2 = this.m_ICube.getRowTitle();
        String string3 = this.m_ICube.getColumnTitle();
        String string4 = this.m_ICube.getRowTotalsTitle();
        String string5 = this.m_ICube.getColumnTotalsTitle();
        if (string2 == null) {
            string2 = I18N.ERD.getString("CubeFlagsPage.ALL");
        }
        if (string3 == null) {
            string3 = I18N.ERD.getString("CubeFlagsPage.ALL");
        }
        this.m_RowTitle.setText(string2);
        this.m_ColumnTitle.setText(string3);
        this.m_TotalRowTitle.setText(string4);
        this.m_TotalColumnTitle.setText(string5);
        this.m_Component.add(this.m_CollapseRows);
        this.m_Component.add(this.m_CollapseColumns);
        this.stickLeft("collapse-rows");
        this.stickLeft("collapse-cols");
        this.putBelow("collapse-rows", string, 5);
        this.putBelow("collapse-cols", "collapse-rows");
        this.m_CollapseRows.setSelected(this.m_ICube.isCollapseRows());
        this.m_CollapseColumns.setSelected(this.m_ICube.isCollapseColumns());
        if (this.m_ICube.canControlTotals()) {
            this.buildControlTotals();
        }
        I18N.ERD_MAP.injectComponents("CubeFlagsPage.", this.m_Component);
    }

    private void buildControlTotals() {
        this.m_Component.add(this.m_KeepRowTotals);
        this.m_Component.add(this.m_KeepColumnTotals);
        this.m_Component.add(this.m_ShowRowTotalsAfterDetails);
        this.m_Component.add(this.m_ShowColumnTotalsAfterDetails);
        this.putBelow("keep-rows", "collapse-cols");
        this.putBelow("keep-cols", "keep-rows");
        this.stickLeft("keep-rows");
        this.stickLeft("keep-cols");
        this.putBelow("show-row-totals-after", "keep-cols");
        this.putBelow("show-col-totals-after", "show-row-totals-after");
        this.stickLeft("show-row-totals-after");
        this.stickLeft("show-col-totals-after");
        this.m_KeepRowTotals.setSelected(this.m_ICube.isKeepRowTotals());
        this.m_KeepColumnTotals.setSelected(this.m_ICube.isKeepColumnTotals());
        this.m_ShowRowTotalsAfterDetails.setSelected(this.m_ICube.isShowRowTotalsAfterDetails());
        this.m_ShowColumnTotalsAfterDetails.setSelected(this.m_ICube.isShowColumnTotalsAfterDetails());
        if (this.m_ICube.canShowRowHeaderLabels()) {
            this.m_Component.add(this.m_ShowRowHeaderLabels);
            this.putBelow("show-row-header-labels", "show-col-totals-after");
            this.stickLeft("show-row-header-labels");
            this.m_ShowRowHeaderLabels.setSelected(this.m_ICube.isShowRowHeaderLabels());
        }
    }
}

