/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.wizard.cube;

import com.elixirtech.arch.Elixir;
import com.elixirtech.arch.ElixirFrame;
import com.elixirtech.arch.IRenderable2;
import com.elixirtech.data2.DataSchema;
import com.elixirtech.ensemble.cube.ICubeWrapper;
import com.elixirtech.icons.EnsembleIcons;
import com.elixirtech.icons.StandardIcons;
import com.elixirtech.report2.I18N;
import com.elixirtech.ui.EscapableDialog;
import com.elixirtech.ui.LCellRenderer;
import com.elixirtech.ui.SwingFactory;
import com.elixirtech.util.CodeBlock;
import com.elixirtech.util.StringUtil;
import com.elixirtech.wizard.cube.HierarchyPanel;
import com.elixirtech.wizard.cube.LevelChoice;
import com.elixirtech.wizard.cube.LevelDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.TreeSet;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListModel;

public class HierarchyDialog
extends EscapableDialog {
    private JTextField m_Name = SwingFactory.newTextField("name");
    private JList m_Left = SwingFactory.newList();
    private JList m_Right = SwingFactory.newList();
    private JButton m_Up = this.button(StandardIcons.UP);
    private JButton m_Down = this.button(StandardIcons.DOWN);
    private JButton m_Dots = SwingFactory.newDotsButton();
    private JButton m_Ok;
    private DataSchema m_Schema;
    private HierarchyPanel.Dimension m_Dimension;
    private ICubeWrapper m_ICube;
    private boolean m_IsOk;

    public HierarchyDialog(DataSchema dataSchema, JFrame jFrame, String string, HierarchyPanel.Dimension dimension, ICubeWrapper iCubeWrapper) {
        super((Frame)jFrame, true);
        this.setTitle(string);
        this.m_ICube = iCubeWrapper;
        this.m_Schema = dataSchema;
        this.m_Dimension = dimension;
        JPanel jPanel = new JPanel(new BorderLayout());
        this.getContentPane().add(jPanel);
        LCellRenderer lCellRenderer = new LCellRenderer();
        this.m_Left.setCellRenderer(lCellRenderer);
        this.m_Right.setCellRenderer(lCellRenderer);
        this.m_Right.addListSelectionListener(new CodeBlock((Object)this, "updateButtons"));
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add((Component)SwingFactory.newLabel("name-label"), "West");
        jPanel2.add(this.m_Name);
        this.m_Name.getDocument().addDocumentListener(new CodeBlock((Object)this, "updateButtons"));
        JPanel jPanel3 = new JPanel(new GridLayout(1, 2));
        jPanel.add((Component)jPanel2, "North");
        jPanel3.add(this.buildLeft());
        jPanel3.add(this.buildRight());
        jPanel.add(jPanel3);
        jPanel.add((Component)this.buildSouth(), "South");
        this.m_Name.setText(this.m_Dimension.name);
        this.buildListContents();
        I18N.ERD_MAP.injectComponents("HierarchyDialog.", this);
        this.setSize(500, 400);
        this.setLocationRelativeTo(jFrame);
    }

    private JPanel buildSouth() {
        JPanel jPanel = new JPanel(new FlowLayout(2));
        this.m_Ok = SwingFactory.newOkButton(new CodeBlock((Object)this, "ok"));
        JButton jButton = SwingFactory.newCancelButton(new CodeBlock((Object)this, "cancel"));
        jPanel.add(this.m_Ok);
        jPanel.add(jButton);
        return jPanel;
    }

    private JPanel buildLeft() {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)SwingFactory.newLabel("schema-label"), "North");
        jPanel.add(new JScrollPane(this.m_Left));
        this.m_Left.addMouseListener(new AddListener());
        JButton jButton = this.button(StandardIcons.RIGHT);
        jButton.addActionListener(new CodeBlock((Object)this, "add"));
        JButton jButton2 = this.button(StandardIcons.LEFT);
        jButton2.addActionListener(new CodeBlock((Object)this, "remove"));
        JPanel jPanel2 = new JPanel(new GridLayout(2, 1));
        jPanel2.add(jButton);
        jPanel2.add(jButton2);
        jPanel.add((Component)jPanel2, "East");
        return jPanel;
    }

    private JPanel buildRight() {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)SwingFactory.newLabel("hierarchy-label"), "North");
        jPanel.add(new JScrollPane(this.m_Right));
        this.m_Right.addMouseListener(new EditListener());
        JPanel jPanel2 = new JPanel(new GridLayout(3, 1));
        this.m_Up.addActionListener(new CodeBlock((Object)this, "up"));
        this.m_Down.addActionListener(new CodeBlock((Object)this, "down"));
        this.m_Dots.addActionListener(new CodeBlock((Object)this, "edit"));
        jPanel2.add(this.m_Up);
        jPanel2.add(this.m_Down);
        jPanel2.add(this.m_Dots);
        jPanel.add((Component)jPanel2, "East");
        return jPanel;
    }

    public void add() {
        DefaultListModel defaultListModel = (DefaultListModel)this.m_Right.getModel();
        Object[] objectArray = this.m_Left.getSelectedValues();
        for (int i = 0; i < objectArray.length; ++i) {
            Choice choice = (Choice)objectArray[i];
            int n = defaultListModel.size();
            defaultListModel.addElement(new LevelChoice(choice.getName(), EnsembleIcons.FIELD));
            this.m_Right.setSelectedIndex(n);
        }
        this.updateButtons();
    }

    public void remove() {
        DefaultListModel defaultListModel = (DefaultListModel)this.m_Right.getModel();
        Object[] objectArray = this.m_Right.getSelectedValues();
        for (int i = 0; i < objectArray.length; ++i) {
            defaultListModel.removeElement(objectArray[i]);
        }
        this.updateButtons();
    }

    public void up() {
        DefaultListModel defaultListModel = (DefaultListModel)this.m_Right.getModel();
        int[] nArray = this.m_Right.getSelectedIndices();
        if (nArray.length > 0) {
            Arrays.sort(nArray);
            if (nArray[0] > 0) {
                for (int i = 0; i < nArray.length; ++i) {
                    Object e = defaultListModel.remove(nArray[i]);
                    int n = i;
                    nArray[n] = nArray[n] - 1;
                    defaultListModel.add(nArray[i], e);
                }
                this.m_Right.setSelectedIndices(nArray);
            }
        }
    }

    public void down() {
        DefaultListModel defaultListModel = (DefaultListModel)this.m_Right.getModel();
        int[] nArray = this.m_Right.getSelectedIndices();
        if (nArray.length > 0) {
            Arrays.sort(nArray);
            if (nArray[nArray.length - 1] < defaultListModel.size() - 1) {
                for (int i = nArray.length - 1; i >= 0; --i) {
                    Object e = defaultListModel.remove(nArray[i]);
                    int n = i;
                    nArray[n] = nArray[n] + 1;
                    defaultListModel.add(nArray[i], e);
                }
                this.m_Right.setSelectedIndices(nArray);
            }
        }
    }

    public void edit() {
        DefaultListModel defaultListModel = (DefaultListModel)this.m_Right.getModel();
        int[] nArray = this.m_Right.getSelectedIndices();
        if (nArray.length == 1) {
            LevelChoice levelChoice = (LevelChoice)defaultListModel.elementAt(nArray[0]);
            ElixirFrame elixirFrame = (ElixirFrame)Elixir.get(ElixirFrame.class);
            LevelDialog levelDialog = new LevelDialog(elixirFrame.getFrame(), this.m_Schema, levelChoice, this.m_ICube.isShowUITitles());
            elixirFrame.showModal(levelDialog);
            this.repaint();
        }
    }

    public void ok() {
        this.m_Dimension.name = this.m_Name.getText();
        ListModel listModel = this.m_Right.getModel();
        int n = listModel.getSize();
        LevelChoice[] levelChoiceArray = new LevelChoice[n];
        for (int i = 0; i < n; ++i) {
            levelChoiceArray[i] = (LevelChoice)listModel.getElementAt(i);
        }
        this.m_Dimension.path = levelChoiceArray;
        this.m_IsOk = true;
        this.dispose();
    }

    public void cancel() {
        this.dispose();
    }

    public boolean isOk() {
        return this.m_IsOk;
    }

    public HierarchyPanel.Dimension getDimension() {
        return this.m_Dimension;
    }

    public void updateButtons() {
        int[] nArray = this.m_Right.getSelectedIndices();
        boolean bl = nArray.length > 0;
        boolean bl2 = nArray.length > 1;
        boolean bl3 = bl && !bl2 && ((LevelChoice)this.m_Right.getSelectedValue()).isHierarchy();
        this.m_Up.setEnabled(bl);
        this.m_Down.setEnabled(bl);
        this.m_Dots.setEnabled(!bl3);
        boolean bl4 = StringUtil.notEmpty(this.m_Name.getText());
        boolean bl5 = this.m_Right.getModel().getSize() > 0;
        this.m_Ok.setEnabled(bl4 && bl5);
    }

    private void buildListContents() {
        Object object;
        int n = this.m_Schema.getColumnCount();
        TreeSet<Choice> treeSet = new TreeSet<Choice>();
        for (int i = 0; i < n; ++i) {
            treeSet.add(new Choice(this.m_Schema.getColumnName(i)));
        }
        ArrayList<LevelChoice> arrayList = new ArrayList<LevelChoice>();
        LevelChoice[] levelChoiceArray = this.m_Dimension.path;
        for (int i = 0; i < levelChoiceArray.length; ++i) {
            object = new Choice(levelChoiceArray[i].getName());
            if (!treeSet.contains(object)) continue;
            arrayList.add(levelChoiceArray[i]);
        }
        DefaultListModel<Choice> defaultListModel = new DefaultListModel<Choice>();
        for (Choice object2 : treeSet) {
            defaultListModel.addElement(object2);
        }
        this.m_Left.setModel(defaultListModel);
        object = new DefaultListModel<LevelChoice>();
        for (LevelChoice levelChoice : arrayList) {
            ((DefaultListModel)object).addElement(levelChoice);
        }
        this.m_Right.setModel(object);
        this.updateButtons();
    }

    private JButton button(Icon icon) {
        JButton jButton = new JButton(icon);
        jButton.setMargin(SwingFactory.EMPTY_INSETS);
        return jButton;
    }

    private class AddListener
    extends MouseAdapter {
        private AddListener() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getClickCount() == 2) {
                HierarchyDialog.this.add();
            }
        }
    }

    private class EditListener
    extends MouseAdapter {
        private EditListener() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getClickCount() == 2) {
                HierarchyDialog.this.edit();
            }
        }
    }

    private class Choice
    implements IRenderable2,
    Comparable<Choice> {
        private String m_ChoiceName;

        public Choice(String string) {
            this.m_ChoiceName = string;
        }

        public String getName() {
            return this.m_ChoiceName;
        }

        @Override
        public String getRenderableName() {
            return this.m_ChoiceName;
        }

        @Override
        public Icon getRenderableIcon() {
            return EnsembleIcons.FIELD;
        }

        @Override
        public int compareTo(Choice choice) {
            return this.m_ChoiceName.compareTo(choice.m_ChoiceName);
        }
    }
}

