/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.wizard.cube;

import com.elixirtech.arch.wizard.RelativeLayoutWizardPage;
import com.elixirtech.data2.DataSchema;
import com.elixirtech.ensemble.canvas.DimensionNode;
import com.elixirtech.ensemble.canvas.SortNode;
import com.elixirtech.ensemble.cube.ICubeWrapper;
import com.elixirtech.icons.EnsembleIcons;
import com.elixirtech.report2.I18N;
import com.elixirtech.ui.SwingFactory;
import com.elixirtech.ui.wizard.IWizard;
import com.elixirtech.wizard.EnsembleUI;
import com.elixirtech.wizard.cube.CubeWizard;
import com.elixirtech.wizard.cube.HierarchyPanel;
import com.elixirtech.wizard.cube.ICubeWizard;
import com.elixirtech.wizard.cube.LevelChoice;
import com.elixirtech.wizard.cube.MeasurePage;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JTextField;

public class HierarchyPage
extends RelativeLayoutWizardPage
implements ActionListener {
    public static final String NAME = "Dimension";
    private ICubeWrapper m_ICube;
    private JTextField m_Name;
    private JButton m_Color;
    private HierarchyPanel m_HierarchyPanel;

    public HierarchyPage() {
        super(NAME, "Axis");
        I18N.ERD_MAP.injectObject(null, this, "HierarchyPage");
    }

    @Override
    public void setWizard(IWizard iWizard) {
        super.setWizard(iWizard);
        this.m_ICube = ((ICubeWizard)((Object)iWizard)).getCube();
        this.buildComponent();
    }

    @Override
    public void setVisible(boolean bl) {
        if (bl) {
            DataSchema dataSchema = this.m_ICube.getDataSchema();
            if (dataSchema != null) {
                this.m_HierarchyPanel.setSchema(dataSchema);
                this.m_HierarchyPanel.setEnabled(!this.m_ICube.isReadOnly());
            } else {
                this.setError(I18N.ERD.getString("HierarchyPage.CANT_READ_SCHEMA"));
                this.m_HierarchyPanel.setEnabled(false);
            }
        }
    }

    public void performFinish() {
        if (this.m_ICube.hasIdentifier()) {
            this.m_ICube.setText(this.m_Name.getText());
            this.m_ICube.setFillColor(this.m_Name.getBackground());
        }
        this.m_ICube.removeAllDimensions();
        int n = this.m_HierarchyPanel.getDimensionCount();
        for (int i = 0; i < n; ++i) {
            HierarchyPanel.Dimension dimension = this.m_HierarchyPanel.getDimension(i);
            this.m_ICube.addDimension(dimension.name, (SortNode[])dimension.path);
        }
    }

    public String[] getHierarchyNames() {
        int n = this.m_HierarchyPanel.getDimensionCount();
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            HierarchyPanel.Dimension dimension = this.m_HierarchyPanel.getDimension(i);
            stringArray[i] = dimension.name;
        }
        return stringArray;
    }

    protected boolean isHierarchy(String string) {
        return this.m_HierarchyPanel.isHierarchy(string);
    }

    protected HierarchyPanel.Dimension getHierarchy(String string) {
        return this.m_HierarchyPanel.getDimension(string);
    }

    @Override
    public boolean canFlipToNextPage() {
        return this.m_HierarchyPanel.getSchema() != null;
    }

    @Override
    public boolean isPageComplete() {
        MeasurePage measurePage = (MeasurePage)this.m_Wizard.getPage("Measure");
        if (measurePage != null) {
            return measurePage.getMeasureCount() > 0;
        }
        return true;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        CubeWizard.colorAction(this.m_Component, this.m_Name);
    }

    protected void buildComponent() {
        this.m_Component.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.m_Component.setLayout(this.m_Layout);
        if (this.m_ICube.hasIdentifier()) {
            this.m_Name = SwingFactory.newTextField("name");
            this.m_Name.setBackground(this.m_ICube.getFillColor());
            this.m_Name.setText(this.m_ICube.getText());
            this.m_Color = EnsembleUI.newColorDots(this);
        }
        this.m_HierarchyPanel = new HierarchyPanel(this.m_ICube);
        int n = this.m_ICube.getDimensionCount();
        for (int i = 0; i < n; ++i) {
            DimensionNode dimensionNode = this.m_ICube.getDimension(i);
            SortNode[] sortNodeArray = dimensionNode.getPath();
            LevelChoice[] levelChoiceArray = new LevelChoice[sortNodeArray.length];
            for (int j = 0; j < levelChoiceArray.length; ++j) {
                levelChoiceArray[j] = new LevelChoice(sortNodeArray[j], EnsembleIcons.FIELD);
            }
            this.m_HierarchyPanel.addDimension(dimensionNode.getName(), levelChoiceArray);
        }
        this.layoutComponents();
        if (this.m_ICube.isReadOnly()) {
            if (this.m_Name != null) {
                this.m_Name.setEnabled(false);
            }
            if (this.m_Color != null) {
                this.m_Color.setEnabled(false);
            }
            this.m_HierarchyPanel.setEnabled(false);
        }
        I18N.ERD_MAP.injectComponents("HierarchyPage.", this.m_Component);
    }

    private void layoutComponents() {
        if (this.m_ICube.hasIdentifier()) {
            this.m_Component.add(SwingFactory.newLabel("name-label"));
            this.m_Component.add("name", this.m_Name);
            this.m_Component.add(this.m_Color);
        }
        this.m_Component.add(this.m_HierarchyPanel);
        if (this.m_ICube.hasIdentifier()) {
            this.stickLeft("name-label");
            this.vCenter("name-label", "name");
            this.stickTop("name");
            this.putRight("name", "name-label", 10);
            this.stickTop("color");
            this.stickRight("color");
            this.setHeight("color", "name");
            this.putLeft("name", "color");
            this.putBelow("hier", "name", 5);
        } else {
            this.stickTop("hier");
        }
        this.stickLeft("hier");
        this.stickRight("hier");
        this.stickBottom("hier");
    }
}

