/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.wizard.cube.cell;

import com.elixirtech.arch.Elixir;
import com.elixirtech.arch.repository.FileType;
import com.elixirtech.arch.repository.RepositoryExplorer;
import com.elixirtech.arch.repository.RepositoryField;
import com.elixirtech.arch.ui.ArchLayout;
import com.elixirtech.data2.datasource.filter.When;
import com.elixirtech.icons.StandardIcons;
import com.elixirtech.report2.I18N;
import com.elixirtech.report2.raw.model.CellRender;
import com.elixirtech.ui.ColorView;
import com.elixirtech.ui.EscapableDialog;
import com.elixirtech.ui.SwingFactory;
import com.elixirtech.wizard.filter.WhenRenderer;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTextField;

class CellRenderDialog
extends EscapableDialog
implements ActionListener {
    private CellRender m_CellRender;
    private ColorViewPanel m_Fore;
    private ColorViewPanel m_Back;
    private RepositoryField m_Icon;
    private JComboBox m_When;
    private JTextField m_Test;
    private boolean m_Finished;

    public CellRenderDialog(JFrame jFrame, CellRender cellRender) {
        super(jFrame, I18N.ERD.getString("CellRenderDialog.frame.title"), true);
        this.setDefaultCloseOperation(2);
        this.m_CellRender = cellRender;
        JComponent jComponent = (JComponent)this.getContentPane();
        ArchLayout archLayout = new ArchLayout();
        jComponent.setLayout(archLayout);
        jComponent.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.m_Fore = new ColorViewPanel(this.m_CellRender.getForeground());
        this.m_Back = new ColorViewPanel(this.m_CellRender.getBackground());
        RepositoryExplorer repositoryExplorer = (RepositoryExplorer)Elixir.get(RepositoryExplorer.class);
        FileType[] fileTypeArray = new FileType[]{repositoryExplorer.getFileTypeJ("image/jpeg"), repositoryExplorer.getFileTypeJ("image/png"), repositoryExplorer.getFileTypeJ("image/gif")};
        this.m_Icon = new RepositoryField(I18N.ERD.getString("CellRenderDialog.choose-icon.title"), fileTypeArray, this.m_CellRender.getIconName());
        this.m_When = SwingFactory.newComboBox("when", When.getAll());
        this.m_When.setRenderer(new WhenRenderer());
        this.m_When.setSelectedItem(When.getInstance((String)this.m_CellRender.getWhen()));
        this.m_Test = new JTextField(this.m_CellRender.getTest(), 32);
        this.m_When.setFont(this.m_Test.getFont());
        archLayout.addLabel(jComponent, "fore", SwingFactory.newLabel("fore-label"));
        archLayout.addLabel(jComponent, "back", SwingFactory.newLabel("back-label"));
        archLayout.addLabel(jComponent, "icon", SwingFactory.newLabel("icon-label"));
        archLayout.addLabel(jComponent, "test", SwingFactory.newLabel("test-label"));
        jComponent.add("fore", this.m_Fore);
        jComponent.add("back", this.m_Back);
        jComponent.add("icon", this.m_Icon);
        jComponent.add("when", this.m_When);
        jComponent.add("test", this.m_Test);
        archLayout.stickTop("fore");
        archLayout.alignBelow("back", "fore");
        archLayout.alignBelow("icon", "back");
        archLayout.alignBelow("when", "icon");
        archLayout.putBelow("test", "icon");
        archLayout.putRight("test", "when");
        archLayout.setHeight("when", "test");
        archLayout.putRight("fore", "fore-label,back-label,icon-label,test-label", 10);
        archLayout.stickRight("fore");
        archLayout.stickRight("back");
        archLayout.stickRight("icon");
        archLayout.stickRight("test");
        JButton jButton = SwingFactory.newOkButton();
        jButton.setActionCommand("ok");
        jButton.addActionListener(this);
        JButton jButton2 = SwingFactory.newCancelButton();
        jButton2.setActionCommand("cancel");
        jButton2.addActionListener(this);
        jComponent.add(jButton);
        jComponent.add(jButton2);
        String string = jButton.getName();
        String string2 = jButton2.getName();
        archLayout.putBelow(string, "test", 5);
        archLayout.putBelow(string2, "test", 5);
        archLayout.stickRight(string2);
        archLayout.putLeft(string, string2, -5);
        I18N.ERD_MAP.injectComponents("CellRenderDialog.", this);
        this.pack();
    }

    public boolean isFinished() {
        return this.m_Finished;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if ("ok".equals(actionEvent.getActionCommand())) {
            this.m_CellRender.setForeground(this.m_Fore.getColor());
            this.m_CellRender.setBackground(this.m_Back.getColor());
            this.m_CellRender.setIconName(this.m_Icon.getURL());
            When when = (When)this.m_When.getSelectedItem();
            this.m_CellRender.setWhen(when != null ? when.getName() : "");
            this.m_CellRender.setTest(this.m_Test.getText());
            this.m_Finished = true;
            this.dispose();
        } else {
            this.dispose();
        }
    }

    class ColorViewPanel
    extends JPanel
    implements ActionListener {
        JButton m_Button;
        ColorView m_View;

        public ColorViewPanel(Color color) {
            this.setLayout(new BorderLayout());
            this.m_Button = new JButton(StandardIcons.COLOR);
            this.m_Button.setMargin(new Insets(0, 0, 0, 0));
            this.m_Button.addActionListener(this);
            this.m_View = new ColorView(color);
            this.add((Component)this.m_Button, "West");
            this.add((Component)this.m_View, "Center");
        }

        public void addActionListener(ActionListener actionListener) {
            this.m_Button.addActionListener(actionListener);
        }

        public void setColor(Color color) {
            this.m_View.setColor(color);
        }

        public Color getColor() {
            return this.m_View.getColor();
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Color color = JColorChooser.showDialog(this, I18N.ERD.getString("UI.choose-color"), this.m_View.getColor());
            if (color != null) {
                this.m_View.setColor(color);
            }
        }
    }
}

