/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.wizard.cube.cell;

import com.elixirtech.arch.Elixir;
import com.elixirtech.arch.ElixirFrame;
import com.elixirtech.erd.util.ClipboardUtil;
import com.elixirtech.report2.I18N;
import com.elixirtech.report2.raw.model.CellRender;
import com.elixirtech.report2.raw.model.CubeMeasure;
import com.elixirtech.report2.raw.model.Holder;
import com.elixirtech.ui.IRenderable;
import com.elixirtech.ui.OrderedEditableTable;
import com.elixirtech.ui.TCellRenderer;
import com.elixirtech.ui.table.ElxTableModel;
import com.elixirtech.util.StringUtil;
import com.elixirtech.wizard.cube.cell.CellRenderDialog;
import com.elixirtech.wizard.cube.cell.ColorHolder;
import com.elixirtech.wizard.cube.cell.IconHolder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JPanel;

public class ColorPanel
extends JPanel
implements ActionListener {
    private CubeMeasure m_Measure;
    private TableModel m_Model;
    private OrderedEditableTable m_Table;
    static final String[] COLUMNS = new String[]{"TableModel.Fore", "TableModel.Back", "TableModel.Icon", "TableModel.When"};

    public ColorPanel(CubeMeasure cubeMeasure) {
        this.m_Measure = cubeMeasure;
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.m_Model = new TableModel(this.m_Measure.getCellRenderList());
        this.m_Table = new OrderedEditableTable(this.m_Model, true);
        this.m_Table.setSingleSelectionMode();
        this.m_Table.getTable().setAutoResizeMode(3);
        this.m_Table.getTable().setDefaultRenderer(IRenderable.class, new TCR());
        this.setLayout(new BorderLayout());
        this.add((Component)this.m_Table, "Center");
        this.m_Table.addActionListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if ("plus".equals(string)) {
            CellRender cellRender = new CellRender();
            ElixirFrame elixirFrame = (ElixirFrame)Elixir.get(ElixirFrame.class);
            CellRenderDialog cellRenderDialog = new CellRenderDialog(elixirFrame.getFrame(), cellRender);
            cellRenderDialog.setLocationRelativeTo(this);
            elixirFrame.showModal(cellRenderDialog);
            if (cellRenderDialog.isFinished()) {
                this.m_Model.add(cellRender);
            }
        } else if ("edit".equals(string)) {
            int n = this.m_Table.getSelectedRow();
            CellRender cellRender = this.m_Model.get(n);
            ElixirFrame elixirFrame = (ElixirFrame)Elixir.get(ElixirFrame.class);
            CellRenderDialog cellRenderDialog = new CellRenderDialog(elixirFrame.getFrame(), cellRender);
            cellRenderDialog.setLocationRelativeTo(this);
            elixirFrame.showModal(cellRenderDialog);
            if (cellRenderDialog.isFinished()) {
                this.m_Model.update(n);
            }
        } else if ("minus".equals(string)) {
            int n = this.m_Table.getSelectedRow();
            this.m_Model.remove(n);
        } else if ("copy".equals(string)) {
            int n = this.m_Table.getSelectedRow();
            CellRender cellRender = this.m_Model.get(n);
            Holder holder = new Holder();
            holder.addContent((Object)cellRender);
            ClipboardUtil.setHolder(holder);
        } else if ("paste".equals(string)) {
            Holder holder = ClipboardUtil.getHolder();
            Iterator iterator = holder.getContentIterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (!(e instanceof CellRender)) continue;
                this.m_Model.add((CellRender)e);
            }
        } else if ("up".equals(string)) {
            int n = this.m_Table.getSelectedRow();
            this.m_Table.select(this.m_Model.moveUp(n));
        } else if ("down".equals(string)) {
            int n = this.m_Table.getSelectedRow();
            this.m_Table.select(this.m_Model.moveDown(n));
        }
    }

    public void doFinish() {
        this.m_Measure.setCellRenderList(this.m_Model.getList());
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.m_Table.setEnabled(bl);
    }

    private class TableModel
    extends ElxTableModel {
        private List<CellRender> m_Rows;

        public TableModel(List<CellRender> list) {
            super(I18N.ERD, COLUMNS);
            this.m_Rows = new ArrayList<CellRender>(list);
        }

        @Override
        public int getRowCount() {
            return this.m_Rows.size();
        }

        @Override
        public Class<?> getColumnClass(int n) {
            if (n == 0 || n == 1 || n == 2) {
                return IRenderable.class;
            }
            return String.class;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            CellRender cellRender = this.m_Rows.get(n);
            if (n2 == 0) {
                return new ColorHolder(cellRender.getForeground());
            }
            if (n2 == 1) {
                return new ColorHolder(cellRender.getBackground());
            }
            if (n2 == 2) {
                return new IconHolder(cellRender);
            }
            String string = cellRender.getWhen();
            if (StringUtil.notEmpty(string)) {
                String string2 = I18N.ERD.getString("When." + string.replace(' ', '_'));
                return string2 + " " + cellRender.getTest();
            }
            return null;
        }

        public void add(CellRender cellRender) {
            int n = this.m_Rows.size();
            this.m_Rows.add(cellRender);
            this.fireTableRowsInserted(n, n);
        }

        public CellRender get(int n) {
            return this.m_Rows.get(n);
        }

        public void update(int n) {
            this.fireTableRowsUpdated(n, n);
        }

        public void remove(int n) {
            this.m_Rows.remove(n);
            this.fireTableRowsDeleted(n, n);
        }

        public int moveUp(int n) {
            CellRender cellRender = this.m_Rows.remove(n);
            this.m_Rows.add(n - 1, cellRender);
            this.fireTableRowsUpdated(n - 1, n);
            return n - 1;
        }

        public int moveDown(int n) {
            CellRender cellRender = this.m_Rows.remove(n);
            this.m_Rows.add(n + 1, cellRender);
            this.fireTableRowsUpdated(n, n + 1);
            return n + 1;
        }

        public List<CellRender> getList() {
            return this.m_Rows;
        }
    }

    private static class TCR
    extends TCellRenderer {
        public TCR() {
            this.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
        }
    }
}

