/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.wizard.data;

import com.elixirtech.arch.Elixir;
import com.elixirtech.arch.ElixirFrame;
import com.elixirtech.arch.ui.ArchLayout;
import com.elixirtech.data2.DataSchema;
import com.elixirtech.data2.DataSourceManager;
import com.elixirtech.data2.IDataSource;
import com.elixirtech.ensemble.wizard.result.ResultSchemaPanel;
import com.elixirtech.erd.reportdesigner.data.AddDataSourceWizard;
import com.elixirtech.erd.util.ReportUtil;
import com.elixirtech.report2.I18N;
import com.elixirtech.report2.raw.model.Chunk;
import com.elixirtech.report2.raw.model.ControlSource;
import com.elixirtech.report2.raw.model.DataSource;
import com.elixirtech.report2.raw.model.RawModelElement;
import com.elixirtech.report2.raw.model.RawReport;
import com.elixirtech.report2.raw.model.Section;
import com.elixirtech.ui.SwingFactory;
import com.elixirtech.util.CodeBlock;
import com.elixirtech.util.StringUtil;
import com.elixirtech.wizard.data.IDataPanel;
import java.util.HashSet;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JPanel;

public class FieldPanel
extends JPanel
implements IDataPanel {
    public static final String SECTION_DATASOURCE_UI = I18N.ERD.getString("Section.DataSource");
    private RawReport m_Report;
    private RawModelElement m_Element;
    private ArchLayout m_Layout;
    private JComboBox m_DataSources;
    private ResultSchemaPanel m_SchemaPanel;

    public FieldPanel(RawReport rawReport, RawModelElement rawModelElement, ControlSource controlSource) {
        this.m_Report = rawReport;
        this.m_Element = rawModelElement;
        this.m_Layout = new ArchLayout();
        this.setLayout(this.m_Layout);
        this.m_SchemaPanel = new ResultSchemaPanel(true);
        this.add(SwingFactory.newLabel("ds-label"));
        this.m_DataSources = SwingFactory.newComboBox("ds", this.getDataSources());
        this.add(this.m_DataSources);
        this.m_DataSources.addItemListener(new CodeBlock((Object)this, "dsSelection"));
        this.add(SwingFactory.newButton("add", new CodeBlock((Object)this, "addDataSource")));
        this.add(this.m_SchemaPanel);
        this.m_Layout.stickLeft("ds-label");
        this.m_Layout.vCenter("ds-label", "ds");
        this.m_Layout.stickTop("ds");
        this.m_Layout.putRight("ds", "ds-label", 10);
        this.m_Layout.putLeft("ds", "add");
        this.m_Layout.stickRight("add");
        this.m_Layout.stickTop("add");
        this.m_Layout.setHeight("add", "ds");
        this.m_Layout.stickLeft("schema");
        this.m_Layout.stickRight("schema");
        this.m_Layout.putBelow("schema", "ds", 5);
        this.m_Layout.stickBottom("schema");
        String string = controlSource.getDataSource();
        if (StringUtil.notEmpty(string)) {
            this.m_DataSources.setSelectedItem(controlSource.getDataSource());
        } else {
            this.m_DataSources.setSelectedItem(SECTION_DATASOURCE_UI);
        }
        this.dsSelection();
        this.m_SchemaPanel.setSelectedName(controlSource.getField());
        I18N.ERD_MAP.injectComponents("FieldPanel.", this);
    }

    public void addDataSource() {
        DataSource dataSource = new DataSource();
        dataSource.setName(ReportUtil.getNextDataSourceName(this.m_Report));
        AddDataSourceWizard addDataSourceWizard = new AddDataSourceWizard(this.m_Report, dataSource);
        ElixirFrame elixirFrame = (ElixirFrame)Elixir.get(ElixirFrame.class);
        elixirFrame.showWizard(addDataSourceWizard);
        if (addDataSourceWizard.isFinished()) {
            this.m_DataSources.setModel(new DefaultComboBoxModel<String>(this.getDataSources()));
            this.m_DataSources.setSelectedItem(dataSource.getName());
        }
    }

    protected Vector<String> getDataSources() {
        Vector<String> vector = new Vector<String>();
        int n = this.m_Report.getDataSourceCount();
        for (int i = 0; i < n; ++i) {
            vector.addElement(this.m_Report.getDataSource(i).getName());
        }
        if (StringUtil.notEmpty(this.getSection().getDataSource())) {
            vector.add(0, SECTION_DATASOURCE_UI);
        }
        return vector;
    }

    public void dsSelection() {
        DataSourceManager dataSourceManager = (DataSourceManager)Elixir.get(DataSourceManager.class);
        String string = (String)this.m_DataSources.getSelectedItem();
        if (string != null) {
            Object object;
            DataSchema dataSchema = null;
            if (SECTION_DATASOURCE_UI.equals(string)) {
                string = this.getSection().getDataSource();
            }
            try {
                object = this.m_Report.getDataSource(string);
                if (object != null) {
                    IDataSource iDataSource = dataSourceManager.getDataSource(dataSourceManager, object.getDataSourceName());
                    dataSchema = iDataSource.getSchema();
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            object = this.m_SchemaPanel.getSelectedName();
            this.m_SchemaPanel.setSchema(dataSchema, new HashSet<String>());
            if (dataSchema != null && dataSchema.getColumnCount() > 0) {
                if (dataSchema.getColumnIndex((String)object) >= 0) {
                    this.m_SchemaPanel.setSelectedName((String)object);
                } else {
                    this.m_SchemaPanel.setSelectedName(dataSchema.getColumnName(0));
                }
            }
        }
    }

    @Override
    public ControlSource getControlSource() {
        ControlSource controlSource = new ControlSource();
        controlSource.setType("Field");
        if (this.m_DataSources.getSelectedIndex() >= 0) {
            String string;
            String string2 = (String)this.m_DataSources.getSelectedItem();
            if (!SECTION_DATASOURCE_UI.equals(string2)) {
                controlSource.setDataSource(string2);
            }
            if (StringUtil.isEmpty(string = this.m_SchemaPanel.getSelectedName())) {
                string = "";
            }
            controlSource.setField(string);
            if (SECTION_DATASOURCE_UI.equals(string2)) {
                controlSource.setText(string);
            } else {
                controlSource.setText(string2 + ":" + string);
            }
        }
        return controlSource;
    }

    protected Section getSection() {
        Chunk chunk = this.m_Element.getChunk();
        return chunk.getSection();
    }
}

