/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.wizard.data;

import com.elixirtech.arch.Elixir;
import com.elixirtech.arch.ElixirFrame;
import com.elixirtech.arch.ui.ArchLayout;
import com.elixirtech.data2.DataSchema;
import com.elixirtech.data2.DataSourceManager;
import com.elixirtech.data2.IDataSource;
import com.elixirtech.data2.function.Function;
import com.elixirtech.data2.function.FunctionFactory;
import com.elixirtech.data2.function.IFunctionFactory;
import com.elixirtech.ensemble.wizard.result.ResultSchemaPanel;
import com.elixirtech.erd.reportdesigner.data.AddDataSourceWizard;
import com.elixirtech.erd.util.ReportUtil;
import com.elixirtech.report2.I18N;
import com.elixirtech.report2.raw.model.Chunk;
import com.elixirtech.report2.raw.model.ControlSource;
import com.elixirtech.report2.raw.model.DataSource;
import com.elixirtech.report2.raw.model.RawModelElement;
import com.elixirtech.report2.raw.model.RawReport;
import com.elixirtech.report2.raw.model.Section;
import com.elixirtech.ui.SwingFactory;
import com.elixirtech.util.CodeBlock;
import com.elixirtech.util.StringUtil;
import com.elixirtech.wizard.data.FieldPanel;
import com.elixirtech.wizard.data.IDataPanel;
import java.util.HashSet;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class OperationPanel
extends JPanel
implements IDataPanel {
    private RawReport m_Report;
    private RawModelElement m_Element;
    private ArchLayout m_Layout;
    private JComboBox m_DataSources;
    private ResultSchemaPanel m_SchemaPanel;
    private JCheckBox m_RunningSum;
    private JComboBox m_Operation;
    private JRadioButton m_OverGroup;
    private JRadioButton m_OverAll;

    public OperationPanel(RawReport rawReport, RawModelElement rawModelElement, ControlSource controlSource) {
        this.m_Report = rawReport;
        this.m_Element = rawModelElement;
        this.m_Layout = new ArchLayout();
        this.setLayout(this.m_Layout);
        this.add(SwingFactory.newLabel("DS.label"));
        this.m_DataSources = SwingFactory.newComboBox("ds", this.getDataSources());
        this.add(this.m_DataSources);
        this.m_DataSources.addItemListener(new CodeBlock((Object)this, "dsSelection"));
        this.add(SwingFactory.newButton("DS.add", new CodeBlock((Object)this, "addDataSource")));
        this.m_SchemaPanel = new ResultSchemaPanel(true);
        this.add("schema", this.m_SchemaPanel);
        this.m_RunningSum = SwingFactory.newCheckBox("DSGROUP.running-sum");
        this.add(this.m_RunningSum);
        this.m_Operation = SwingFactory.newComboBox("op", OperationPanel.getIDs());
        this.add(this.m_Operation);
        this.m_Operation.setRenderer(new FunctionFactory.FunctionLCR());
        this.m_OverGroup = SwingFactory.newRadioButton("DSGROUP.over-group");
        this.add(this.m_OverGroup);
        this.m_OverAll = SwingFactory.newRadioButton("DSGROUP.over-all");
        this.add(this.m_OverAll);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.m_OverGroup);
        buttonGroup.add(this.m_OverAll);
        this.m_OverGroup.setSelected(true);
        this.m_Layout.stickLeft("DS.label");
        this.m_Layout.vCenter("DS.label", "ds");
        this.m_Layout.stickTop("ds");
        this.m_Layout.putRight("ds", "DS.label", 10);
        this.m_Layout.putLeft("ds", "DS.add");
        this.m_Layout.stickRight("DS.add");
        this.m_Layout.stickTop("DS.add");
        this.m_Layout.setHeight("DS.add", "ds");
        this.m_Layout.stickLeft("schema");
        this.m_Layout.stickRight("schema");
        this.m_Layout.putBelow("schema", "ds", 5);
        this.m_Layout.stickLeft("op");
        this.m_Layout.putRight("DSGROUP.over-group", "op", 10);
        this.m_Layout.putRight("DSGROUP.over-all", "DSGROUP.over-group", 5);
        this.m_Layout.putRight("DSGROUP.running-sum", "DSGROUP.over-all", 10);
        this.m_Layout.stickBottom("op");
        this.m_Layout.vCenter("DSGROUP.over-group", "op");
        this.m_Layout.vCenter("DSGROUP.over-all", "op");
        this.m_Layout.vCenter("DSGROUP.running-sum", "op");
        this.m_Layout.putAbove("schema", "op,DSGROUP.over-group,DSGROUP.over-all,DSGROUP.running-sum", 5);
        String string = controlSource.getDataSource();
        if (StringUtil.notEmpty(string)) {
            this.m_DataSources.setSelectedItem(controlSource.getDataSource());
        } else {
            this.m_DataSources.setSelectedItem(FieldPanel.SECTION_DATASOURCE_UI);
        }
        this.dsSelection();
        this.m_SchemaPanel.setSelectedName(controlSource.getField());
        this.m_Operation.setSelectedItem(controlSource.getOperation());
        if (this.m_Operation.getSelectedIndex() < 0) {
            this.m_Operation.setSelectedIndex(0);
        }
        this.m_RunningSum.setSelected(controlSource.isRunningValue());
        String string2 = controlSource.getRange();
        if ("All".equals(string2)) {
            this.m_OverAll.setSelected(true);
        } else {
            this.m_OverGroup.setSelected(true);
        }
        I18N.ERD_MAP.injectComponents("OperationPanel.", this);
    }

    public void addDataSource() {
        DataSource dataSource = new DataSource();
        dataSource.setName(ReportUtil.getNextDataSourceName(this.m_Report));
        AddDataSourceWizard addDataSourceWizard = new AddDataSourceWizard(this.m_Report, dataSource);
        ElixirFrame elixirFrame = (ElixirFrame)Elixir.get(ElixirFrame.class);
        elixirFrame.showWizard(addDataSourceWizard);
        if (addDataSourceWizard.isFinished()) {
            this.m_DataSources.setModel(new DefaultComboBoxModel<String>(this.getDataSources()));
            this.m_DataSources.setSelectedItem(dataSource.getName());
        }
    }

    protected Vector<String> getDataSources() {
        Vector<String> vector = new Vector<String>();
        int n = this.m_Report.getDataSourceCount();
        for (int i = 0; i < n; ++i) {
            vector.addElement(this.m_Report.getDataSource(i).getName());
        }
        if (StringUtil.notEmpty(this.getSection().getDataSource())) {
            vector.add(0, FieldPanel.SECTION_DATASOURCE_UI);
        }
        return vector;
    }

    public void dsSelection() {
        DataSourceManager dataSourceManager = (DataSourceManager)Elixir.get(DataSourceManager.class);
        String string = (String)this.m_DataSources.getSelectedItem();
        if (string != null) {
            Object object;
            DataSchema dataSchema = null;
            if (FieldPanel.SECTION_DATASOURCE_UI.equals(string)) {
                string = this.getSection().getDataSource();
            }
            try {
                object = this.m_Report.getDataSource(string);
                if (object != null) {
                    IDataSource iDataSource = dataSourceManager.getDataSource(dataSourceManager, object.getDataSourceName());
                    dataSchema = iDataSource.getSchema();
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            object = this.m_SchemaPanel.getSelectedName();
            this.m_SchemaPanel.setSchema(dataSchema, new HashSet<String>());
            if (dataSchema != null && dataSchema.getColumnCount() > 0) {
                if (dataSchema.getColumnIndex((String)object) >= 0) {
                    this.m_SchemaPanel.setSelectedName((String)object);
                } else {
                    this.m_SchemaPanel.setSelectedName(dataSchema.getColumnName(0));
                }
            }
        }
    }

    @Override
    public ControlSource getControlSource() {
        ControlSource controlSource = new ControlSource();
        controlSource.setType("Operation");
        if (this.m_DataSources.getSelectedIndex() >= 0) {
            String string = (String)this.m_DataSources.getSelectedItem();
            if (!FieldPanel.SECTION_DATASOURCE_UI.equals(string)) {
                controlSource.setDataSource(string);
            }
            controlSource.setField(this.m_SchemaPanel.getSelectedName());
            controlSource.setOperation((String)this.m_Operation.getSelectedItem());
            controlSource.setRunningValue(this.m_RunningSum.isSelected());
            controlSource.setRange(this.m_OverAll.isSelected() ? "All" : "Group");
        }
        return controlSource;
    }

    protected Section getSection() {
        Chunk chunk = this.m_Element.getChunk();
        return chunk.getSection();
    }

    protected static String[] getIDs() {
        IFunctionFactory iFunctionFactory = (IFunctionFactory)Elixir.get(IFunctionFactory.class);
        Function[] functionArray = iFunctionFactory.getAllWithRecord();
        String[] stringArray = new String[functionArray.length];
        for (int i = 0; i < functionArray.length; ++i) {
            stringArray[i] = functionArray[i].getName();
        }
        return stringArray;
    }
}

