/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.wizard.data;

import com.elixirtech.arch.Elixir;
import com.elixirtech.arch.ElixirFrame;
import com.elixirtech.arch.repository.RepositoryChooser;
import com.elixirtech.arch.repository.filter.AllowAllFilter;
import com.elixirtech.arch.ui.ArchLayout;
import com.elixirtech.i18n.I18NComboBox;
import com.elixirtech.report2.I18N;
import com.elixirtech.report2.raw.model.ControlSource;
import com.elixirtech.ui.SwingFactory;
import com.elixirtech.util.CodeBlock;
import com.elixirtech.v2.repository.FileObject;
import com.elixirtech.v2.repository.Repository;
import com.elixirtech.wizard.data.IDataPanel;
import java.awt.Frame;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class URLPanel
extends JPanel
implements IDataPanel {
    private ArchLayout m_Layout = new ArchLayout();
    private JTextField m_URL;
    private I18NComboBox m_URLType;

    public URLPanel(ControlSource controlSource, String[] stringArray) {
        this.setLayout(this.m_Layout);
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.m_URL = SwingFactory.newTextField("url");
        this.add(this.m_URL);
        this.m_URL.setText(controlSource.getURL());
        this.add(SwingFactory.newLabel("url-label"));
        this.add(SwingFactory.newDotsButton("dots", new CodeBlock((Object)this, "dots")));
        this.add(SwingFactory.newLabel("type-label"));
        this.m_URLType = SwingFactory.newI18NComboBox("type", I18NComboBox.buildNames(stringArray, I18N.ERD, stringArray));
        this.add(this.m_URLType);
        this.m_URLType.setSelectedId(controlSource.getURLType());
        if (this.m_URLType.getSelectedIndex() < 0) {
            this.m_URLType.setSelectedIndex(0);
        }
        this.m_Layout.stickLeft("url-label");
        this.m_Layout.vCenter("url-label", "url");
        this.m_Layout.stickTop("url");
        this.m_Layout.putRight("url", "url-label,type-label", 10);
        this.m_Layout.putLeft("url", "dots");
        this.m_Layout.stickTop("dots");
        this.m_Layout.stickRight("dots");
        this.m_Layout.setHeight("dots", "url");
        this.m_Layout.stickLeft("type-label");
        this.m_Layout.vCenter("type-label", "type");
        this.m_Layout.alignBelow("type", "url");
        I18N.ERD_MAP.injectComponents("URLPanel.", this);
    }

    @Override
    public ControlSource getControlSource() {
        ControlSource controlSource = new ControlSource();
        controlSource.setType("URL");
        controlSource.setURL(this.m_URL.getText());
        controlSource.setURLType(this.m_URLType.getSelectedId());
        return controlSource;
    }

    public void dots() {
        ElixirFrame elixirFrame = (ElixirFrame)Elixir.get(ElixirFrame.class);
        RepositoryChooser repositoryChooser = new RepositoryChooser((Frame)elixirFrame.getFrame(), I18N.ERD.getString("UI.repository"), AllowAllFilter.all());
        String string = this.m_URL.getText();
        if (string.startsWith("repository:")) {
            string = string.substring(11);
            Repository repository = (Repository)Elixir.get(Repository.class);
            FileObject fileObject = repository.getFileJ(string);
            if (fileObject != null) {
                repositoryChooser.setSelection(fileObject);
            }
        }
        repositoryChooser.setLocationRelativeTo(elixirFrame.getFrame());
        elixirFrame.showModal(repositoryChooser);
        if (repositoryChooser.isOk()) {
            this.m_URL.setText("repository:" + String.valueOf(repositoryChooser.getSelection().getPath()));
        }
    }
}

