/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.wizard.datasource;

import com.elixirtech.ensemble.I18N;
import com.elixirtech.icons.DatasourceIcons;
import com.elixirtech.wizard.IWizardPage;
import com.elixirtech.wizard.PageId;
import com.elixirtech.wizard.PageId$;
import com.elixirtech.wizard.WizardPage;
import com.elixirtech.wizard.datasource.ChooseDataSourceTypePage$;
import com.elixirtech.wizard.datasource.DataSourcePageRegistry;
import com.elixirtech.wizard.datasource.DataSourcePageRegistry$;
import com.elixirtech.wizard.datasource.DataSourceWizard$;
import com.elixirtech.wizard.datasource.IDataSourceWizard;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.io.Serializable;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.collection.immutable.List;
import scala.math.Ordering;
import scala.runtime.function.JProcedure1;

public class ChooseDataSourceTypePage
extends WizardPage
implements ListSelectionListener {
    private final JList m_Types;

    public static String PageName() {
        return ChooseDataSourceTypePage$.MODULE$.PageName();
    }

    public static ChooseDataSourceTypePage apply(IDataSourceWizard iDataSourceWizard) {
        return ChooseDataSourceTypePage$.MODULE$.apply(iDataSourceWizard);
    }

    public ChooseDataSourceTypePage(IDataSourceWizard wizard) {
        super(wizard, ChooseDataSourceTypePage$.MODULE$.PageName(), (Option<PageId>)None$.MODULE$);
        I18N.ENSEMBLE_MAP.injectObject(null, this, "ChooseDataSourceTypePage");
        this.setIcon(DatasourceIcons.DATASOURCE_IMAGE);
        this.m_Component().setLayout(new BorderLayout());
        this.m_Component().setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.m_Types = new JList();
        this.m_Types().setBackground(Color.WHITE);
        this.m_Types().setLayoutOrientation(1);
        this.m_Types().setVisibleRowCount(0);
        this.m_Types().setFixedCellHeight(40);
        this.m_Types().setCellRenderer(new Renderer());
        this.m_Types().addListSelectionListener(this);
        this.m_Component().add((Component)new JScrollPane(this.m_Types()), "Center");
        this.buildList();
    }

    private IDataSourceWizard wizard$accessor() {
        return (IDataSourceWizard)super.wizard();
    }

    public JList<DataSourcePageRegistry.DSInfo> m_Types() {
        return this.m_Types;
    }

    @Override
    public boolean isPageComplete() {
        return false;
    }

    @Override
    public void load() {
    }

    @Override
    public void save() {
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        this.wizard$accessor().container().updateButtons();
    }

    public void buildList() {
        DefaultListModel model = new DefaultListModel();
        ((List)DataSourcePageRegistry$.MODULE$.dsTypes().sortBy((Function1 & Serializable)_$1 -> _$1.label(), (Ordering)Ordering.String$.MODULE$)).foreach((Function1)(JProcedure1 & Serializable)x$0 -> model.addElement(x$0));
        this.m_Types().setModel(model);
    }

    @Override
    public boolean canFlipToNextPage() {
        return this.m_Types().getSelectedIndex() >= 0;
    }

    @Override
    public Option<IWizardPage> getNextPage() {
        Option option = Option$.MODULE$.apply((Object)this.m_Types().getSelectedValue()).map((Function1 & Serializable)_$2 -> _$2.dsType());
        if (option instanceof Some) {
            String dsType = (String)((Some)option).value();
            this.wizard$accessor().setDSType(dsType);
            return this.wizard$accessor().getPage(PageId$.MODULE$.apply(dsType));
        }
        if (None$.MODULE$.equals(option)) {
            return None$.MODULE$;
        }
        throw new MatchError((Object)option);
    }

    public Option<String> getDataSourceType() {
        return Option$.MODULE$.apply((Object)this.m_Types().getSelectedValue()).map((Function1 & Serializable)_$3 -> _$3.dsType());
    }

    public static class Renderer
    extends JLabel
    implements ListCellRenderer<DataSourcePageRegistry.DSInfo> {
        private final Border m_NoFocusBorder;
        private final Option m_FocusBorder;

        public Renderer() {
            this.setOpaque(true);
            this.m_NoFocusBorder = (Border)Option$.MODULE$.apply((Object)UIManager.getBorder("List.cellNoFocusBorder")).getOrElse(this::$init$$$anonfun$1);
            this.m_FocusBorder = Option$.MODULE$.apply((Object)UIManager.getBorder("List.focusCellHighlightBorder"));
            this.setBorder(this.m_NoFocusBorder());
        }

        public Border m_NoFocusBorder() {
            return this.m_NoFocusBorder;
        }

        public Option<Border> m_FocusBorder() {
            return this.m_FocusBorder;
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends DataSourcePageRegistry.DSInfo> list, DataSourcePageRegistry.DSInfo value, int index, boolean isSelected, boolean cellHasFocus) {
            this.setBackground(isSelected ? list.getSelectionBackground() : list.getBackground());
            this.setForeground(isSelected ? list.getSelectionForeground() : list.getForeground());
            this.setFont(list.getFont());
            this.setEnabled(list.isEnabled());
            this.setBorder(cellHasFocus ? (Border)this.m_FocusBorder().orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()) : this.m_NoFocusBorder());
            if (value == null) {
                this.setText(null);
                this.setIcon(null);
            } else {
                this.setText(value.label());
                this.setIcon(DataSourceWizard$.MODULE$.getIconResource(value.icon()));
            }
            return this;
        }

        private final Border $init$$$anonfun$1() {
            return new EmptyBorder(1, 1, 1, 1);
        }
    }
}

