/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.wizard.datasource;

import com.elixirtech.data2.DataType;
import com.elixirtech.i18n.Bundle;
import com.elixirtech.ui.ArchLayout;
import com.elixirtech.ui.SwingFactory;
import com.elixirtech.util.CodeBlock;
import com.elixirtech.wizard.datasource.DataSchemaPanel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class ColumnDialog<T extends DataSchemaPanel.SchemaColumn>
extends JDialog
implements DataSchemaPanel.IColumnDialog,
DocumentListener {
    protected final ArchLayout m_Layout = new ArchLayout();
    protected final T m_Group;
    protected boolean m_IsOk;
    protected JTextField m_Name;
    protected JComboBox m_DataType;
    protected JButton m_Ok;
    protected JButton m_Cancel;

    public ColumnDialog(JFrame jFrame, String string, T t) {
        super((Frame)jFrame, true);
        this.setTitle(string);
        this.m_Group = t;
        this.setDefaultCloseOperation(2);
        this.getContentPane().add((Component)this.buildUI(), "Center");
        this.getContentPane().add((Component)this.buildSouth(), "South");
        this.setupConstraints();
        this.updateButtons();
        this.packAndSize();
        this.setLocationRelativeTo(jFrame);
    }

    @Override
    public JDialog getDialog() {
        return this;
    }

    protected void packAndSize() {
        this.pack();
        Dimension dimension = this.getPreferredSize();
        this.setSize(dimension.width * 2, dimension.height + 5);
    }

    protected JPanel buildUI() {
        this.m_Name = SwingFactory.newTextField("name", 32);
        this.m_Name.setText(((DataSchemaPanel.SchemaColumn)this.m_Group).name);
        this.m_Name.getDocument().addDocumentListener(this);
        this.m_DataType = SwingFactory.newComboBox("data-type", this.getTypes());
        this.m_DataType.setSelectedItem(((DataSchemaPanel.SchemaColumn)this.m_Group).type);
        JPanel jPanel = new JPanel(this.m_Layout);
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        jPanel.add(SwingFactory.newLabel("name-label"));
        jPanel.add(this.m_Name);
        jPanel.add(this.m_DataType);
        jPanel.add(SwingFactory.newLabel("data-type-label"));
        return jPanel;
    }

    protected JPanel buildSouth() {
        this.m_Ok = SwingFactory.newOkButton(new CodeBlock((Object)this, "ok"));
        this.m_Cancel = SwingFactory.newCancelButton(new CodeBlock((Object)this, "cancel"));
        JPanel jPanel = new JPanel(new FlowLayout(2));
        jPanel.add(this.m_Ok);
        jPanel.add(this.m_Cancel);
        this.getRootPane().setDefaultButton(this.m_Ok);
        Bundle.ARCH_MAP.injectComponents(null, jPanel);
        return jPanel;
    }

    protected Object[] getTypes() {
        return DataType.TYPES;
    }

    protected void setupConstraints() {
        this.m_Layout.stickLeft("name-label");
        this.m_Layout.vCenter("name-label", "name");
        this.m_Layout.stickLeft("data-type-label");
        this.m_Layout.vCenter("data-type-label", "data-type");
        this.m_Layout.putRight("name", "name-label,data-type-label", 10);
        this.m_Layout.stickRight("name");
        this.m_Layout.stickTop("name");
        this.m_Layout.alignBelow("data-type", "name", 5);
        this.m_Layout.stickRight("data-type");
    }

    public void ok() {
        ((DataSchemaPanel.SchemaColumn)this.m_Group).name = this.m_Name.getText().trim();
        ((DataSchemaPanel.SchemaColumn)this.m_Group).type = (DataType)this.m_DataType.getSelectedItem();
        this.m_IsOk = true;
        this.dispose();
    }

    public void cancel() {
        this.dispose();
    }

    @Override
    public boolean isOk() {
        return this.m_IsOk;
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        this.updateButtons();
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.updateButtons();
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.updateButtons();
    }

    protected void updateButtons() {
        this.m_Ok.setEnabled(this.m_Name.getText().length() > 0);
    }
}

