/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.wizard.datasource;

import com.elixirtech.arch.Elixir;
import com.elixirtech.arch.ElixirFrame;
import com.elixirtech.data2.DataAttributes;
import com.elixirtech.data2.DataSchema;
import com.elixirtech.data2.DataType;
import com.elixirtech.ensemble.I18N;
import com.elixirtech.ui.OrderedEditableTable;
import com.elixirtech.ui.TableUtil;
import com.elixirtech.ui.table.ElxTableModel;
import com.elixirtech.wizard.datasource.ColumnDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.table.TableColumn;

public class DataSchemaPanel
extends JPanel
implements ActionListener {
    private static final String[] COLUMNS = new String[]{"TableModel.Column", "TableModel.Name", "TableModel.Type"};
    protected ColumnModel m_ColumnModel;
    protected OrderedEditableTable m_ColumnTable;
    protected boolean m_SchemaFixed;

    public DataSchemaPanel() {
        this.setName("schema");
        this.setLayout(new BorderLayout());
        String[] stringArray = this.getColumnNames();
        this.m_ColumnModel = new ColumnModel(stringArray);
        this.m_ColumnTable = new OrderedEditableTable(this.m_ColumnModel, true, false);
        this.m_ColumnTable.setAutoResizeMode(3);
        TableColumn tableColumn = this.m_ColumnTable.getTable().getColumnModel().getColumn(0);
        TableUtil.setColumnWidth(this.m_ColumnTable.getTable(), tableColumn, I18N.ENSEMBLE, COLUMNS[0], 10);
        this.m_ColumnTable.addActionListener(this);
        this.add((Component)this.m_ColumnTable, "Center");
    }

    public void disposeEditor() {
        this.m_ColumnTable.disposeEditor();
    }

    public boolean isSchemaFixed() {
        return this.m_SchemaFixed;
    }

    @Override
    public void setEnabled(boolean bl) {
        this.setSchemaFixed(!bl);
        super.setEnabled(bl);
    }

    public void setSchemaFixed(boolean bl) {
        this.m_SchemaFixed = bl;
        this.m_ColumnTable.setEnabled(!bl);
    }

    public DataSchema getSchema() {
        return this.getSchema("yyyy-MM-dd", "HH:mm:ss", "yyyy-MM-dd HH:mm:ss");
    }

    public DataSchema getSchema(String string, String string2, String string3) {
        int n = this.m_ColumnModel.getRowCount();
        String[] stringArray = new String[n];
        DataType[] dataTypeArray = new DataType[n];
        DataAttributes[] dataAttributesArray = new DataAttributes[n];
        for (int i = 0; i < n; ++i) {
            SchemaColumn schemaColumn = this.m_ColumnModel.getColumn(i);
            stringArray[i] = schemaColumn.name;
            dataTypeArray[i] = schemaColumn.type;
            dataAttributesArray[i] = schemaColumn.attrs;
        }
        DataSchema dataSchema = new DataSchema(true, stringArray, dataTypeArray, dataAttributesArray);
        if (string != null && string.length() > 0) {
            dataSchema.setDateFormat(string);
        }
        if (string2 != null && string2.length() > 0) {
            dataSchema.setTimeFormat(string2);
        }
        if (string3 != null && string3.length() > 0) {
            dataSchema.setTimestampFormat(string3);
        }
        return dataSchema;
    }

    public Set<String> getNames() {
        HashSet<String> hashSet = new HashSet<String>();
        int n = this.m_ColumnModel.getRowCount();
        for (int i = 0; i < n; ++i) {
            SchemaColumn schemaColumn = this.m_ColumnModel.getColumn(i);
            hashSet.add(schemaColumn.name);
        }
        return hashSet;
    }

    public void setSchema(DataSchema dataSchema) {
        this.m_ColumnModel.removeAll();
        if (dataSchema != null) {
            int n = dataSchema.getColumnCount();
            for (int i = 0; i < n; ++i) {
                SchemaColumn schemaColumn = this.newColumn();
                schemaColumn.name = dataSchema.getColumnName(i);
                schemaColumn.type = dataSchema.getColumnType(i);
                schemaColumn.attrs = new DataAttributes(dataSchema.getAttributes(i));
                this.m_ColumnModel.addColumn(schemaColumn);
            }
            this.schemaChanged();
        }
    }

    public int getColumnCount() {
        return this.m_ColumnModel.getRowCount();
    }

    public SchemaColumn getColumn(int n) {
        return this.m_ColumnModel.getColumn(n);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if ("plus".equals(string)) {
            this.addColumn();
        } else if ("minus".equals(string)) {
            this.removeColumn();
        } else if ("edit".equals(string)) {
            this.editColumn();
        } else if ("up".equals(string)) {
            this.moveUp();
        } else if ("down".equals(string)) {
            this.moveDown();
        }
    }

    public void addColumn() {
        try {
            SchemaColumn schemaColumn = this.newColumn();
            String string = I18N.ENSEMBLE.getString("DataSchemaPanel.AddColumn");
            ElixirFrame elixirFrame = (ElixirFrame)Elixir.get(ElixirFrame.class);
            IColumnDialog iColumnDialog = this.newColumnDialog(elixirFrame.getFrame(), string, schemaColumn);
            elixirFrame.showModal(iColumnDialog.getDialog());
            if (iColumnDialog.isOk()) {
                this.m_ColumnModel.addColumn(schemaColumn);
                this.schemaChanged();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void editColumn() {
        SchemaColumn schemaColumn = this.m_ColumnModel.getColumn(this.m_ColumnTable.getSelectedRow());
        String string = I18N.ENSEMBLE.getString("DataSchemaPanel.EditColumn");
        ElixirFrame elixirFrame = (ElixirFrame)Elixir.get(ElixirFrame.class);
        IColumnDialog iColumnDialog = this.newColumnDialog(elixirFrame.getFrame(), string, schemaColumn);
        elixirFrame.showModal(iColumnDialog.getDialog());
        if (iColumnDialog.isOk()) {
            this.m_ColumnModel.updateColumn(schemaColumn);
            this.schemaChanged();
        }
    }

    public void removeColumn() {
        int n = -1;
        int[] nArray = this.m_ColumnTable.getSelectedRows();
        Arrays.sort(nArray);
        for (int i = nArray.length - 1; i >= 0; --i) {
            SchemaColumn schemaColumn = this.m_ColumnModel.getColumn(nArray[i]);
            this.m_ColumnModel.removeColumn(schemaColumn);
            n = Math.min(nArray[i], this.m_ColumnModel.getRowCount() - 1);
        }
        if (n >= 0) {
            this.m_ColumnTable.select(n);
        }
        this.schemaChanged();
    }

    public void moveUp() {
        int n = this.m_ColumnTable.getSelectedRow();
        if (n > 0) {
            SchemaColumn schemaColumn = this.m_ColumnModel.getColumn(n);
            this.m_ColumnModel.moveUp(schemaColumn);
            this.m_ColumnTable.select(--n);
            this.schemaChanged();
        }
    }

    public void moveDown() {
        int n = this.m_ColumnTable.getSelectedRow();
        if (n < this.m_ColumnModel.getRowCount() - 1) {
            SchemaColumn schemaColumn = this.m_ColumnModel.getColumn(n);
            this.m_ColumnModel.moveDown(schemaColumn);
            this.m_ColumnTable.select(++n);
            this.schemaChanged();
        }
    }

    protected void schemaChanged() {
    }

    protected SchemaColumn newColumn() {
        return new SchemaColumn();
    }

    protected IColumnDialog newColumnDialog(JFrame jFrame, String string, SchemaColumn schemaColumn) {
        return new MyColumnDialog(jFrame, string, schemaColumn);
    }

    protected String[] getColumnNames() {
        return COLUMNS;
    }

    protected static class ColumnModel
    extends ElxTableModel {
        private List<SchemaColumn> m_Columns = new ArrayList<SchemaColumn>();

        public ColumnModel(String[] stringArray) {
            super(I18N.ENSEMBLE, stringArray);
        }

        @Override
        public Class<?> getColumnClass(int n) {
            if (this.m_Columns.size() == 0) {
                return String.class;
            }
            return this.getColumn(0).getColumnClass(n);
        }

        @Override
        public int getRowCount() {
            return this.m_Columns.size();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            if (n2 == 0) {
                return n + 1;
            }
            SchemaColumn schemaColumn = this.getColumn(n);
            return schemaColumn.getData(n2);
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            SchemaColumn schemaColumn = this.getColumn(n);
            return schemaColumn.isEditable(n2);
        }

        public void setValue(Object object, int n, int n2) {
            SchemaColumn schemaColumn = this.getColumn(n);
            schemaColumn.setValue(object, n2);
        }

        public void addColumn(SchemaColumn schemaColumn) {
            int n = this.m_Columns.size();
            this.m_Columns.add(schemaColumn);
            this.fireTableRowsInserted(n, n);
        }

        public void moveUp(SchemaColumn schemaColumn) {
            int n = this.m_Columns.indexOf(schemaColumn);
            if (n >= 1) {
                this.m_Columns.remove(schemaColumn);
                this.m_Columns.add(n - 1, schemaColumn);
                this.fireTableRowsUpdated(n - 1, n);
            }
        }

        public void moveDown(SchemaColumn schemaColumn) {
            int n = this.m_Columns.indexOf(schemaColumn);
            if (n >= 0 && n < this.m_Columns.size() - 1) {
                this.m_Columns.remove(schemaColumn);
                this.m_Columns.add(n + 1, schemaColumn);
                this.fireTableRowsUpdated(n, n + 1);
            }
        }

        public void removeColumn(SchemaColumn schemaColumn) {
            int n = this.m_Columns.indexOf(schemaColumn);
            if (n >= 0) {
                this.m_Columns.remove(schemaColumn);
                this.fireTableRowsDeleted(n, n);
            }
        }

        public void updateColumn(SchemaColumn schemaColumn) {
            int n = this.m_Columns.indexOf(schemaColumn);
            if (n >= 0) {
                this.fireTableRowsUpdated(n, n);
            }
        }

        public SchemaColumn getColumn(int n) {
            return this.m_Columns.get(n);
        }

        public void removeAll() {
            int n = this.m_Columns.size() - 1;
            if (n >= 0) {
                this.m_Columns.clear();
                this.fireTableRowsDeleted(0, n);
            }
        }
    }

    public static class SchemaColumn {
        public String name = "";
        public DataType type = DataType.UNKNOWN;
        public DataAttributes attrs;

        public Object getData(int n) {
            if (n == 1) {
                return this.name;
            }
            if (n == 2) {
                return this.type;
            }
            return null;
        }

        public Class<?> getColumnClass(int n) {
            return String.class;
        }

        public boolean isEditable(int n) {
            return false;
        }

        public void setValue(Object object, int n) {
            if (n == 1 && object instanceof String) {
                this.name = (String)object;
            }
        }
    }

    public static interface IColumnDialog {
        public JDialog getDialog();

        public boolean isOk();
    }

    protected static class MyColumnDialog
    extends ColumnDialog<SchemaColumn> {
        public MyColumnDialog(JFrame jFrame, String string, SchemaColumn schemaColumn) {
            super(jFrame, string, schemaColumn);
        }

        @Override
        protected void setupConstraints() {
            I18N.ENSEMBLE_MAP.injectComponents("ColumnDialog.", this);
            super.setupConstraints();
        }
    }
}

