/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.wizard.datasource;

import com.elixirtech.arch.Elixir$;
import com.elixirtech.arch.ElixirFrame;
import com.elixirtech.data2.DataAttributes;
import com.elixirtech.data2.DataSchema;
import com.elixirtech.data2.DataType;
import com.elixirtech.ensemble.I18N;
import com.elixirtech.ui.OrderedEditableTable;
import com.elixirtech.ui.TableUtil;
import com.elixirtech.ui.table.ElxTableModel;
import com.elixirtech.wizard.IWizard;
import com.elixirtech.wizard.datasource.ColumnDialog2;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableColumn;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

public class DataSchemaPanel2
extends JPanel
implements ActionListener,
TableModelListener {
    private final IWizard wiz;
    private final String[] COLUMNS;
    private final ColumnModel m_ColumnModel;
    private final OrderedEditableTable m_ColumnTable;
    private boolean m_SchemaFixed;
    private final TableColumn col;

    public DataSchemaPanel2(IWizard wiz) {
        this.wiz = wiz;
        this.COLUMNS = new String[]{"TableModel.Column", "TableModel.Name", "TableModel.Type"};
        this.m_ColumnModel = new ColumnModel(this.getColumnNames());
        this.m_ColumnTable = new OrderedEditableTable(this.m_ColumnModel(), true, false);
        this.m_SchemaFixed = false;
        this.setName("schema");
        this.setLayout(new BorderLayout());
        this.m_ColumnTable().setAutoResizeMode(3);
        this.col = this.m_ColumnTable().getTable().getColumnModel().getColumn(0);
        TableUtil.setColumnWidth(this.m_ColumnTable().getTable(), this.col(), I18N.ENSEMBLE, this.COLUMNS[0], 10);
        this.m_ColumnTable().addActionListener(this);
        this.add((Component)this.m_ColumnTable(), "Center");
        this.m_ColumnModel().addTableModelListener(this);
    }

    public ColumnModel m_ColumnModel() {
        return this.m_ColumnModel;
    }

    public OrderedEditableTable m_ColumnTable() {
        return this.m_ColumnTable;
    }

    public boolean m_SchemaFixed() {
        return this.m_SchemaFixed;
    }

    public void m_SchemaFixed_$eq(boolean x$1) {
        this.m_SchemaFixed = x$1;
    }

    public TableColumn col() {
        return this.col;
    }

    @Override
    public void tableChanged(TableModelEvent var1) {
        this.wiz.container().updateButtons();
    }

    @Override
    public void setEnabled(boolean b) {
        this.setSchemaFixed(!b);
        super.setEnabled(b);
    }

    public void setSchemaFixed(boolean b) {
        this.m_SchemaFixed_$eq(b);
        this.m_ColumnTable().setEnabled(!b);
    }

    public DataSchema getSchema() {
        return this.getSchema("yyyy-MM-dd", "HH:mm:ss", "yyyy-MM-dd HH:mm:ss");
    }

    public DataSchema getSchema(String dateFormat, String timeFormat, String timestampFormat) {
        int count = this.m_ColumnModel().getRowCount();
        String[] cols = new String[count];
        DataType[] types = new DataType[count];
        DataAttributes[] attrs = new DataAttributes[count];
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), count).foreach((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            SchemaColumn g = this.m_ColumnModel().getColumn(i);
            cols$1[i] = g.name();
            types$1[i] = g.type();
            attrs$1[i] = g.attrs();
        });
        DataSchema schema = new DataSchema(true, cols, types, attrs);
        if (dateFormat != null && StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(dateFormat))) {
            schema.setDateFormat(dateFormat);
        }
        if (timeFormat != null && StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(timeFormat))) {
            schema.setTimeFormat(timeFormat);
        }
        if (timestampFormat != null && StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(timestampFormat))) {
            schema.setTimestampFormat(timestampFormat);
        }
        return schema;
    }

    public Set<String> getNames() {
        HashSet<String> ret = new HashSet<String>();
        int count = this.m_ColumnModel().getRowCount();
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), count).foreach((Function1)(JFunction1.mcZI.sp & Serializable)i -> {
            SchemaColumn g = this.m_ColumnModel().getColumn(i);
            return ret.add(g.name());
        });
        return ret;
    }

    public void setSchema(DataSchema schema) {
        this.m_ColumnModel().removeAll();
        if (schema != null) {
            int count = schema.getColumnCount();
            RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), count).foreach((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
                SchemaColumn col = this.newColumn();
                col.name_$eq(schema.getColumnName(i));
                col.type_$eq(schema.getColumnType(i));
                col.attrs_$eq(new DataAttributes(schema.getAttributes(i)));
                this.m_ColumnModel().addColumn(col);
            });
            return;
        }
    }

    public int getColumnCount() {
        return this.m_ColumnModel().getRowCount();
    }

    public SchemaColumn getColumn(int idx) {
        return this.m_ColumnModel().getColumn(idx);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String string = e.getActionCommand();
        switch (string == null ? 0 : string.hashCode()) {
            case 3739: {
                if (!"up".equals(string)) break;
                this.moveUp();
                return;
            }
            case 3089570: {
                if (!"down".equals(string)) break;
                this.moveDown();
                return;
            }
            case 3108362: {
                if (!"edit".equals(string)) break;
                this.editColumn();
                return;
            }
            case 3444122: {
                if (!"plus".equals(string)) break;
                this.addColumn();
                return;
            }
            case 103901296: {
                if (!"minus".equals(string)) break;
                this.removeColumn();
                return;
            }
        }
        throw new MatchError((Object)string);
    }

    public void addColumn() {
        try {
            SchemaColumn group = this.newColumn();
            String title = I18N.ENSEMBLE.getString("DataSchemaPanel.AddColumn");
            ElixirFrame f = (ElixirFrame)Elixir$.MODULE$.get(ElixirFrame.class);
            IColumnDialog dlg = this.newColumnDialog(f.getFrame(), title, group);
            f.showModal(dlg.getDialog());
            if (dlg.isOk()) {
                this.m_ColumnModel().addColumn(group);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void editColumn() {
        SchemaColumn group = this.m_ColumnModel().getColumn(this.m_ColumnTable().getSelectedRow());
        String title = I18N.ENSEMBLE.getString("DataSchemaPanel.EditColumn");
        ElixirFrame f = (ElixirFrame)Elixir$.MODULE$.get(ElixirFrame.class);
        IColumnDialog dlg = this.newColumnDialog(f.getFrame(), title, group);
        f.showModal(dlg.getDialog());
        if (dlg.isOk()) {
            this.m_ColumnModel().updateColumn(group);
            return;
        }
    }

    public void removeColumn() {
        IntRef newSel = IntRef.create((int)-1);
        int[] rows = this.m_ColumnTable().getSelectedRows();
        Arrays.sort(rows);
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(rows.length - 1), 0).by(-1).foreach((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            SchemaColumn group = this.m_ColumnModel().getColumn(rows[i]);
            this.m_ColumnModel().removeColumn(group);
            newSel$1.elem = Math.min(rows[i], this.m_ColumnModel().getRowCount() - 1);
        });
        if (newSel.elem >= 0) {
            this.m_ColumnTable().select(newSel.elem);
            return;
        }
    }

    public void moveUp() {
        int row = this.m_ColumnTable().getSelectedRow();
        if (row > 0) {
            SchemaColumn group = this.m_ColumnModel().getColumn(row);
            this.m_ColumnModel().moveUp(group);
            this.m_ColumnTable().select(--row);
            return;
        }
    }

    public void moveDown() {
        int row = this.m_ColumnTable().getSelectedRow();
        if (row < this.m_ColumnModel().getRowCount() - 1) {
            SchemaColumn group = this.m_ColumnModel().getColumn(row);
            this.m_ColumnModel().moveDown(group);
            this.m_ColumnTable().select(++row);
            return;
        }
    }

    public String[] getColumnNames() {
        return this.COLUMNS;
    }

    public IColumnDialog newColumnDialog(JFrame parent, String title, SchemaColumn group) {
        return new MyColumnDialog(parent, title, group);
    }

    public SchemaColumn newColumn() {
        return new SchemaColumn();
    }

    public static class ColumnModel
    extends ElxTableModel {
        private final ArrayList<SchemaColumn> schemaColumns = new ArrayList();

        public ColumnModel(String[] cols) {
            super(I18N.ENSEMBLE, cols);
        }

        @Override
        public Class<?> getColumnClass(int idx) {
            if (this.schemaColumns.size() == 0) {
                return String.class;
            }
            return this.getColumn(0).getColumnClass(idx);
        }

        @Override
        public int getRowCount() {
            return this.schemaColumns.size();
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            if (columnIndex == 0) {
                return BoxesRunTime.boxToInteger((int)(rowIndex + 1));
            }
            SchemaColumn g = this.getColumn(rowIndex);
            return g.getData(columnIndex);
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            SchemaColumn g = this.getColumn(rowIndex);
            return g.isEditable(columnIndex);
        }

        public void setValue(Object value, int rowIndex, int columnIndex) {
            SchemaColumn g = this.getColumn(rowIndex);
            g.setValue(value, columnIndex);
        }

        public void addColumn(SchemaColumn g) {
            int row = this.schemaColumns.size();
            this.schemaColumns.add(g);
            this.fireTableRowsInserted(row, row);
        }

        public void moveUp(SchemaColumn g) {
            int row = this.schemaColumns.indexOf(g);
            if (row >= 1) {
                this.schemaColumns.remove(g);
                this.schemaColumns.add(row - 1, g);
                this.fireTableRowsUpdated(row - 1, row);
                return;
            }
        }

        public void moveDown(SchemaColumn g) {
            int row = this.schemaColumns.indexOf(g);
            if (row >= 0 && row < this.schemaColumns.size() - 1) {
                this.schemaColumns.remove(g);
                this.schemaColumns.add(row + 1, g);
                this.fireTableRowsUpdated(row, row + 1);
                return;
            }
        }

        public void removeColumn(SchemaColumn g) {
            int row = this.schemaColumns.indexOf(g);
            if (row >= 0) {
                this.schemaColumns.remove(g);
                this.fireTableRowsDeleted(row, row);
                return;
            }
        }

        public void updateColumn(SchemaColumn g) {
            int row = this.schemaColumns.indexOf(g);
            if (row >= 0) {
                this.fireTableRowsUpdated(row, row);
                return;
            }
        }

        public SchemaColumn getColumn(int idx) {
            return this.schemaColumns.get(idx);
        }

        public void removeAll() {
            int lastRow = this.schemaColumns.size() - 1;
            if (lastRow >= 0) {
                this.schemaColumns.clear();
                this.fireTableRowsDeleted(0, lastRow);
                return;
            }
        }
    }

    public static interface IColumnDialog {
        public JDialog getDialog();

        public boolean isOk();
    }

    public static class MyColumnDialog
    extends ColumnDialog2<SchemaColumn> {
        public MyColumnDialog(JFrame parent, String title, SchemaColumn group) {
            super(parent, title, group);
        }

        @Override
        public void setupConstraints() {
            I18N.ENSEMBLE_MAP.injectComponents("ColumnDialog.", this);
            super.setupConstraints();
        }
    }

    public static class SchemaColumn {
        private String name = "";
        private DataType type = DataType.UNKNOWN;
        private DataAttributes attrs = null;

        public Object getData(int idx) {
            if (idx == 1) {
                return this.name();
            }
            if (idx == 2) {
                return this.type();
            }
            return null;
        }

        public Class<?> getColumnClass(int id) {
            return String.class;
        }

        public boolean isEditable(int idx) {
            return false;
        }

        public void setValue(Object value, int idx) {
            if (idx == 1 && value instanceof String) {
                this.name_$eq((String)value);
                return;
            }
        }

        public String name() {
            return this.name;
        }

        public void name_$eq(String x$1) {
            this.name = x$1;
        }

        public DataType type() {
            return this.type;
        }

        public void type_$eq(DataType x$1) {
            this.type = x$1;
        }

        public DataAttributes attrs() {
            return this.attrs;
        }

        public void attrs_$eq(DataAttributes x$1) {
            this.attrs = x$1;
        }
    }
}

