/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.wizard.datasource;

import com.elixirtech.arch.Elixir$;
import com.elixirtech.arch.IErrorHandler;
import com.elixirtech.arch.IPanelView;
import com.elixirtech.arch.IViewModel;
import com.elixirtech.arch.LoggingHelper2;
import com.elixirtech.arch.LoggingInterface;
import com.elixirtech.arch.repository.RepositoryExplorer;
import com.elixirtech.data2.IDataSource;
import com.elixirtech.ds.DSBuilder;
import com.elixirtech.ensemble.I18N;
import com.elixirtech.ensemble.ds.DSPanel;
import com.elixirtech.ensemble.ds.DSUtil2;
import com.elixirtech.ensemble.ds.MutableDataSource;
import com.elixirtech.ensemble.ds.MutableDataSource$;
import com.elixirtech.i18n.I18NUtil;
import com.elixirtech.util.FileUtil;
import com.elixirtech.v2.repository.FileObject;
import com.elixirtech.wizard.IWizardContainer;
import com.elixirtech.wizard.IWizardPage;
import com.elixirtech.wizard.PageId$;
import com.elixirtech.wizard.Wizard;
import com.elixirtech.wizard.datasource.ChooseDataSourceTypePage$;
import com.elixirtech.wizard.datasource.DataSourcePageRegistry$;
import com.elixirtech.wizard.datasource.DataSourceWizard$;
import com.elixirtech.wizard.datasource.IDataSourceWizard;
import com.elixirtech.wizard.datasource.NullDSBuilder;
import io.circe.Json$;
import java.io.Serializable;
import javax.swing.Icon;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.util.Try$;
import sourcecode.FullName$;
import sourcecode.Line$;

public class DataSourceWizard
extends Wizard
implements IDataSourceWizard,
LoggingHelper2 {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(DataSourceWizard.class.getDeclaredField("log$lzy1"));
    private volatile Object log$lzy1;
    private final FileObject fo;
    private final FileObject m_Parent;
    private final Option m_Child;
    private final Set m_ExistingSiblings;
    private final MutableDataSource m_DataSource;
    private DSBuilder m_Builder;
    private String m_SchemaDateFormat;
    private String m_SchemaTimeFormat;
    private String m_SchemaTimestampFormat;

    public static String BASE() {
        return DataSourceWizard$.MODULE$.BASE();
    }

    public static String EXT() {
        return DataSourceWizard$.MODULE$.EXT();
    }

    public static DataSourceWizard apply(FileObject fileObject, IWizardContainer iWizardContainer) {
        return DataSourceWizard$.MODULE$.apply(fileObject, iWizardContainer);
    }

    public static DSBuilder getBuilderForDS(IDataSource iDataSource) {
        return DataSourceWizard$.MODULE$.getBuilderForDS(iDataSource);
    }

    public static Icon getIconResource(String string) {
        return DataSourceWizard$.MODULE$.getIconResource(string);
    }

    public static String getWindowTitle(FileObject fileObject) {
        return DataSourceWizard$.MODULE$.getWindowTitle(fileObject);
    }

    public DataSourceWizard(IWizardContainer wizardContainer, FileObject fo, String windowTitle) {
        this.fo = fo;
        super(wizardContainer, windowTitle, Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0])));
        this.m_Parent = fo.isData() ? fo.getParent() : fo;
        this.m_Child = fo.isData() ? Some$.MODULE$.apply((Object)fo) : None$.MODULE$;
        this.m_ExistingSiblings = this.buildSiblings();
        this.m_DataSource = MutableDataSource$.MODULE$.apply();
        this.m_Builder = new NullDSBuilder();
        this.m_SchemaDateFormat = "yyyy-MM-dd";
        this.m_SchemaTimeFormat = "HH:mm:ss";
        this.m_SchemaTimestampFormat = "yyyy-MM-dd HH:mm:ss";
    }

    public LoggingInterface log() {
        Object object = this.log$lzy1;
        if (object instanceof LoggingInterface) {
            return (LoggingInterface)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (LoggingInterface)this.log$lzyINIT1();
    }

    private Object log$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.log$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    LoggingInterface loggingInterface = null;
                    try {
                        loggingInterface = LoggingHelper2.log$((LoggingHelper2)this);
                        object2 = loggingInterface == null ? LazyVals.NullValue$.MODULE$ : loggingInterface;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.log$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return loggingInterface;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    private IWizardContainer wizardContainer$accessor() {
        return super.wizardContainer();
    }

    private String windowTitle$accessor() {
        return super.windowTitle();
    }

    public FileObject m_Parent() {
        return this.m_Parent;
    }

    public Option<FileObject> m_Child() {
        return this.m_Child;
    }

    public Set<String> m_ExistingSiblings() {
        return this.m_ExistingSiblings;
    }

    public MutableDataSource m_DataSource() {
        return this.m_DataSource;
    }

    public DSBuilder m_Builder() {
        return this.m_Builder;
    }

    public void m_Builder_$eq(DSBuilder x$1) {
        this.m_Builder = x$1;
    }

    @Override
    public DSBuilder getBuilder() {
        return this.m_Builder();
    }

    @Override
    public IWizardContainer container() {
        return this.wizardContainer$accessor();
    }

    @Override
    public IDataSource getDataSource() {
        return this.m_Builder().build();
    }

    @Override
    public boolean isSecuredReadOnly() {
        return this.m_Builder().isReadOnly();
    }

    @Override
    public boolean isSecuredHideInternals() {
        return this.m_Builder().isHideInternals();
    }

    @Override
    public Option<IWizardPage> getStartingPage() {
        String dsType;
        this.log().info(DataSourceWizard::getStartingPage$$anonfun$1, Line$.MODULE$.apply(103), FullName$.MODULE$.apply("com.elixirtech.wizard.datasource.DataSourceWizard.getStartingPage"));
        String string = dsType = this.getDataSource().getType();
        String string2 = "Null";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            return this.getPage(ChooseDataSourceTypePage$.MODULE$.PageName());
        }
        this.log().info(() -> DataSourceWizard.getStartingPage$$anonfun$2(dsType), Line$.MODULE$.apply(107), FullName$.MODULE$.apply("com.elixirtech.wizard.datasource.DataSourceWizard.getStartingPage"));
        return this.getPage(PageId$.MODULE$.apply(dsType));
    }

    @Override
    public boolean canFinish() {
        boolean canWrite = Option$.MODULE$.apply((Object)DSUtil2.getFileObject(this.m_DataSource().unwrapDataSource())).forall((Function1 & Serializable)_$1 -> _$1.canWrite());
        if (!canWrite) {
            return false;
        }
        return this.wizardContainer$accessor().currentPage().exists((Function1 & Serializable)page -> page.canFinish() && page.isPageComplete());
    }

    @Override
    public void setSchemaDateFormat(String df) {
        this.m_SchemaDateFormat = df;
    }

    @Override
    public void setSchemaTimeFormat(String df) {
        this.m_SchemaTimeFormat = df;
    }

    @Override
    public void setSchemaTimestampFormat(String df) {
        this.m_SchemaTimestampFormat = df;
    }

    @Override
    public String getSchemaDateFormat() {
        return this.m_SchemaDateFormat;
    }

    @Override
    public String getSchemaTimeFormat() {
        return this.m_SchemaTimeFormat;
    }

    @Override
    public String getSchemaTimestampFormat() {
        return this.m_SchemaTimestampFormat;
    }

    public List<Function1<IDataSourceWizard, IWizardPage>> pageBuilders() {
        if (this.fo.isData()) {
            IDataSource iDataSource;
            IPanelView iPanelView;
            Option option = Option$.MODULE$.apply((Object)((IViewModel)Elixir$.MODULE$.get(ClassTag$.MODULE$.apply(IViewModel.class))).getView(this.fo));
            if (option instanceof Some && (iPanelView = (IPanelView)((Some)option).value()) instanceof DSPanel) {
                DSPanel pv = (DSPanel)iPanelView;
                iDataSource = pv.getMutableDataSource().unwrapDataSource();
            } else {
                iDataSource = DSUtil2.load(this.fo);
            }
            IDataSource ds = iDataSource;
            this.m_DataSource().wrapDataSource(ds);
            this.log().info(() -> DataSourceWizard.pageBuilders$$anonfun$1(ds), Line$.MODULE$.apply(146), FullName$.MODULE$.apply("com.elixirtech.wizard.datasource.DataSourceWizard.pageBuilders"));
            this.setDS(ds);
            return DataSourcePageRegistry$.MODULE$.pageBuilders(ds.getType());
        }
        return DataSourcePageRegistry$.MODULE$.allPageBuilders();
    }

    @Override
    public void setDSType(String dsType) {
        this.m_Builder_$eq(DataSourcePageRegistry$.MODULE$.dsBuilder(dsType));
    }

    public void setDS(IDataSource ds) {
        this.m_Builder_$eq(DataSourceWizard$.MODULE$.getBuilderForDS(ds));
    }

    public Set<String> buildSiblings() {
        Set all = this.m_Parent().getChildren().map((Function1 & Serializable)_$2 -> _$2.getName()).toSet();
        Option<FileObject> option = this.m_Child();
        if (option instanceof Some) {
            FileObject c = (FileObject)((Some)option).value();
            return (Set)all.$minus((Object)c.getName());
        }
        if (None$.MODULE$.equals(option)) {
            return all;
        }
        throw new MatchError(option);
    }

    @Override
    public boolean isReadOnly() {
        return this.m_Child().exists((Function1 & Serializable)_$3 -> !_$3.canWrite());
    }

    @Override
    public boolean isValidNewName(String name) {
        String string = this.m_DataSource().getName();
        String string2 = name;
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            return true;
        }
        Object buff = name;
        if (!((String)buff).endsWith(DataSourceWizard$.MODULE$.EXT())) {
            buff = (String)buff + DataSourceWizard$.MODULE$.EXT();
        }
        return !this.m_ExistingSiblings().contains(buff);
    }

    @Override
    public boolean performFinish() {
        Option<FileObject> option = this.m_Child();
        if (option instanceof Some) {
            FileObject fo = (FileObject)((Some)option).value();
            return this.performFinishEdit(fo);
        }
        if (None$.MODULE$.equals(option)) {
            return this.performFinishAdd();
        }
        throw new MatchError(option);
    }

    public boolean performFinishEdit(FileObject child) {
        return BoxesRunTime.unboxToBoolean((Object)Try$.MODULE$.apply(() -> this.performFinishEdit$$anonfun$1(child)).fold((Function1 & Serializable)ex -> this.onError("AddDataSourceWizard.CANT_SAVE", (Throwable)ex), (Function1 & Serializable)x -> DataSourceWizard.performFinishEdit$$anonfun$3(BoxesRunTime.unboxToBoolean((Object)x))));
    }

    public boolean performFinishAdd() {
        return BoxesRunTime.unboxToBoolean((Object)Try$.MODULE$.apply(this::performFinishAdd$$anonfun$1).fold((Function1 & Serializable)ex -> this.onError("AddDataSourceWizard.CANT_CREATE", (Throwable)ex), (Function1 & Serializable)x -> DataSourceWizard.performFinishAdd$$anonfun$3(BoxesRunTime.unboxToBoolean((Object)x))));
    }

    private boolean doEditSave(FileObject child) {
        block1: {
            IDataSource ds;
            block0: {
                IPanelView iPanelView;
                ds = this.m_Builder().build();
                IViewModel viewModel = (IViewModel)Elixir$.MODULE$.get(ClassTag$.MODULE$.apply(IViewModel.class));
                Option option = Option$.MODULE$.apply((Object)viewModel.getView(child));
                if (!(option instanceof Some) || !((iPanelView = (IPanelView)((Some)option).value()) instanceof DSPanel)) break block0;
                DSPanel pv = (DSPanel)iPanelView;
                pv.getMutableDataSource().wrapDataSource(ds);
                String name = FileUtil.getNameWithoutExtension(child.getName());
                if (name.equals(this.m_Builder().getName())) break block1;
                ((IErrorHandler)Elixir$.MODULE$.get(ClassTag$.MODULE$.apply(IErrorHandler.class))).warn(I18N.ENSEMBLE.getString("AddDataSourceWizard.WARN_1"));
                pv.save();
                ((RepositoryExplorer)Elixir$.MODULE$.get(ClassTag$.MODULE$.apply(RepositoryExplorer.class))).select(pv.getFileObject());
                break block1;
            }
            FileObject child2 = DSUtil2.save(child, ds);
            ((RepositoryExplorer)Elixir$.MODULE$.get(ClassTag$.MODULE$.apply(RepositoryExplorer.class))).select(child2);
        }
        return true;
    }

    private boolean doAddSave() {
        FileObject child = this.m_Parent().createData(this.m_DataSource().getName() + DataSourceWizard$.MODULE$.EXT());
        FileObject child2 = DSUtil2.save(child, this.m_Builder().build());
        ((RepositoryExplorer)Elixir$.MODULE$.get(ClassTag$.MODULE$.apply(RepositoryExplorer.class))).select(child2);
        ((IViewModel)Elixir$.MODULE$.get(ClassTag$.MODULE$.apply(IViewModel.class))).openFile(child2);
        return true;
    }

    private boolean onError(String key, Throwable ex) {
        String msg = I18NUtil.getString(I18N.ENSEMBLE, key, this.m_Builder().getName());
        this.log().error(() -> DataSourceWizard.onError$$anonfun$1(msg), ex, Line$.MODULE$.apply(236), FullName$.MODULE$.apply("com.elixirtech.wizard.datasource.DataSourceWizard.onError"));
        ((IErrorHandler)Elixir$.MODULE$.get(ClassTag$.MODULE$.apply(IErrorHandler.class))).error(msg, ex);
        return false;
    }

    private static final Object getStartingPage$$anonfun$1() {
        return "getStartingPage";
    }

    private static final Object getStartingPage$$anonfun$2(String dsType$1) {
        return "Starting with page " + dsType$1;
    }

    private static final Object pageBuilders$$anonfun$1(IDataSource ds$1) {
        return "Building pages for " + ds$1.getType();
    }

    private final boolean performFinishEdit$$anonfun$1(FileObject child$1) {
        this.wizardContainer$accessor().currentPage().foreach((Function1)(JProcedure1 & Serializable)_$4 -> _$4.save());
        return this.doEditSave(child$1);
    }

    private static final /* synthetic */ boolean performFinishEdit$$anonfun$3(boolean x) {
        return BoxesRunTime.unboxToBoolean((Object)Predef$.MODULE$.identity((Object)BoxesRunTime.boxToBoolean((boolean)x)));
    }

    private final boolean performFinishAdd$$anonfun$1() {
        this.wizardContainer$accessor().currentPage().foreach((Function1)(JProcedure1 & Serializable)_$5 -> _$5.save());
        return this.doAddSave();
    }

    private static final /* synthetic */ boolean performFinishAdd$$anonfun$3(boolean x) {
        return BoxesRunTime.unboxToBoolean((Object)Predef$.MODULE$.identity((Object)BoxesRunTime.boxToBoolean((boolean)x)));
    }

    private static final Object onError$$anonfun$1(String msg$1) {
        return msg$1;
    }
}

