/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.wizard.datasource;

import com.elixirtech.arch.ElixirJ;
import com.elixirtech.ensemble.I18N;
import com.elixirtech.ui.SwingFactory;
import com.elixirtech.wizard.IWizardPage;
import com.elixirtech.wizard.datasource.ColumnDialog;
import com.elixirtech.wizard.datasource.DataSchemaPanel;
import com.elixirtech.wizard.datasource.WatchableDataSchemaPanel;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class FixedWidthDataSchemaPanel
extends WatchableDataSchemaPanel {
    private static final String[] COLUMNS = new String[]{"TableModel.Column", "TableModel.Name", "TableModel.Type", "TableModel.Width"};

    public FixedWidthDataSchemaPanel(IWizardPage iWizardPage) {
        super(iWizardPage);
    }

    @Override
    public DataSchemaPanel.SchemaColumn newColumn() {
        return new FixedWidthSchemaColumn();
    }

    public int[] getWidths() {
        int[] nArray = new int[this.getColumnCount()];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = ((FixedWidthSchemaColumn)this.m_ColumnModel.getColumn((int)i)).width;
        }
        return nArray;
    }

    public void setWidths(int[] nArray) {
        int n = Math.min(nArray.length, this.getColumnCount());
        for (int i = 0; i < n; ++i) {
            ((FixedWidthSchemaColumn)this.m_ColumnModel.getColumn((int)i)).width = nArray[i];
        }
    }

    @Override
    public DataSchemaPanel.IColumnDialog newColumnDialog(JFrame jFrame, String string, DataSchemaPanel.SchemaColumn schemaColumn) {
        return new FixedWidthColumnDialog(jFrame, string, (FixedWidthSchemaColumn)schemaColumn);
    }

    @Override
    protected String[] getColumnNames() {
        return COLUMNS;
    }

    public static class FixedWidthSchemaColumn
    extends DataSchemaPanel.SchemaColumn {
        public int width;

        @Override
        public Object getData(int n) {
            if (n == 3) {
                return this.width;
            }
            return super.getData(n);
        }
    }

    public static class FixedWidthColumnDialog
    extends ColumnDialog<FixedWidthSchemaColumn> {
        private JTextField m_Width;

        public FixedWidthColumnDialog(JFrame jFrame, String string, FixedWidthSchemaColumn fixedWidthSchemaColumn) {
            super(jFrame, string, fixedWidthSchemaColumn);
        }

        @Override
        protected JPanel buildUI() {
            JPanel jPanel = super.buildUI();
            jPanel.add(SwingFactory.newLabel("width-label"));
            this.m_Width = SwingFactory.newTextField("width");
            jPanel.add(this.m_Width);
            FixedWidthSchemaColumn fixedWidthSchemaColumn = (FixedWidthSchemaColumn)this.m_Group;
            this.m_Width.setText(Integer.toString(fixedWidthSchemaColumn.width));
            return jPanel;
        }

        @Override
        protected void setupConstraints() {
            I18N.ENSEMBLE_MAP.injectComponents("FixedWidthColumnDialog.", this);
            this.m_Layout.stickLeft("name-label");
            this.m_Layout.vCenter("name-label", "name");
            this.m_Layout.stickLeft("data-type-label");
            this.m_Layout.vCenter("data-type-label", "data-type");
            this.m_Layout.putRight("name", "name-label,data-type-label,width-label", 10);
            this.m_Layout.stickRight("name");
            this.m_Layout.stickTop("name");
            this.m_Layout.alignBelow("data-type", "name", 5);
            this.m_Layout.stickRight("data-type");
            this.m_Layout.stickLeft("width-label");
            this.m_Layout.vCenter("width-label", "width");
            this.m_Layout.alignBelow("width", "data-type", 5);
            this.m_Layout.stickRight("width");
        }

        @Override
        public void ok() {
            try {
                ((FixedWidthSchemaColumn)this.m_Group).width = Integer.parseInt(this.m_Width.getText());
                super.ok();
            }
            catch (Exception exception) {
                ElixirJ.error(I18N.ENSEMBLE.getString("FixedWidthDataSchema.CANT_PARSE_WIDTH"));
            }
        }
    }
}

