/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.wizard.datasource.excel;

import com.elixirtech.arch.StringUtil;
import com.elixirtech.data2.DataSchema;
import com.elixirtech.data2.DefaultPushContext;
import com.elixirtech.data2.PushContext;
import com.elixirtech.data2.datasource.excel.ExcelDataSource;
import com.elixirtech.ensemble.I18N;
import com.elixirtech.ensemble.ds.DSUtil2;
import com.elixirtech.ui.FileLoadDialog;
import com.elixirtech.ui.SwingFactory;
import com.elixirtech.ui.SwingUtil;
import com.elixirtech.util.FileUtil;
import com.elixirtech.wizard.AL$;
import com.elixirtech.wizard.FieldWatcher;
import com.elixirtech.wizard.IL$;
import com.elixirtech.wizard.IWizardPage;
import com.elixirtech.wizard.PageId;
import com.elixirtech.wizard.datasource.DSFirstPage;
import com.elixirtech.wizard.datasource.IDataSourceWizard;
import com.elixirtech.wizard.datasource.SecurityPage$;
import com.elixirtech.wizard.datasource.excel.ExcelDSBuilder$;
import com.elixirtech.wizard.datasource.excel.ExcelPage$;
import com.elixirtech.wizard.datasource.excel.ExcelSchemaPage$;
import java.io.File;
import java.io.Serializable;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Some$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.function.JProcedure1;
import scala.runtime.java8.JFunction0;

public class ExcelPage
extends DSFirstPage {
    private final IDataSourceWizard wizard;
    private final FieldWatcher watcher;
    private final JLabel URLLabel;
    private final JTextField URL;
    private final JButton dots;
    private final JLabel rangeLabel;
    private final JTextField range;
    private final JCheckBox hasHeader;
    private final JSpinner headerRow;
    private final JLabel headerRowLabel;

    public static String PageName() {
        return ExcelPage$.MODULE$.PageName();
    }

    public static ExcelPage apply(IDataSourceWizard iDataSourceWizard) {
        return ExcelPage$.MODULE$.apply(iDataSourceWizard);
    }

    public ExcelPage(IDataSourceWizard wizard) {
        this.wizard = wizard;
        super(wizard, ExcelPage$.MODULE$.PageName(), (Option<PageId>)Some$.MODULE$.apply((Object)new PageId(ExcelSchemaPage$.MODULE$.PageName())));
        I18N.ENSEMBLE_MAP.injectObject(null, this, "DS.ExcelPage");
        this.watcher = new FieldWatcher(wizard);
        this.URLLabel = this.addLabel(SwingFactory.newLabel("url-label"));
        this.URL = SwingFactory.newTextField("url");
        this.dots = SwingFactory.newDotsButton("dots", AL$.MODULE$.apply((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.browse()));
        this.rangeLabel = this.addLabel(SwingFactory.newLabel("range-label"));
        this.range = SwingFactory.newTextField("range");
        this.hasHeader = SwingFactory.newCheckBox("hasHeader");
        this.headerRow = SwingFactory.newSpinner("headerRow", new SpinnerNumberModel(1, 1, 32768, 1));
        this.headerRowLabel = SwingFactory.newLabel("headerRow-label");
        this.URL().getDocument().addDocumentListener(this.watcher());
        this.m_Component().add(this.URL());
        this.m_Component().add(this.dots());
        this.range().getDocument().addDocumentListener(this.watcher());
        this.m_Component().add(this.range());
        this.hasHeader().addItemListener(IL$.MODULE$.apply((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.hasHeaderChanged()));
        this.m_Component().add(this.hasHeader());
        this.m_Component().add(this.headerRowLabel());
        this.m_Component().add(this.headerRow());
        I18N.ENSEMBLE_MAP.injectComponents("DS.ExcelPage.", this.m_Component());
        this.layoutComponents();
    }

    public FieldWatcher watcher() {
        return this.watcher;
    }

    public JLabel URLLabel() {
        return this.URLLabel;
    }

    public JTextField URL() {
        return this.URL;
    }

    public JButton dots() {
        return this.dots;
    }

    public JLabel rangeLabel() {
        return this.rangeLabel;
    }

    public JTextField range() {
        return this.range;
    }

    public JCheckBox hasHeader() {
        return this.hasHeader;
    }

    public JSpinner headerRow() {
        return this.headerRow;
    }

    public JLabel headerRowLabel() {
        return this.headerRowLabel;
    }

    private void layoutComponents() {
        this.putRight(this.DS_NAME(), this.DS_ALIGN() + ",url-label,range-label", 10);
        this.alignBelow("url", this.DS_DESC());
        this.m_Layout().putLeft("url", "dots");
        this.m_Layout().putBelow("dots", this.DS_DESC());
        this.m_Layout().setHeight("dots", "url");
        this.stickRight("dots");
        this.alignBelow("range", "url");
        this.stickRight("range");
        this.m_Layout().alignBelow("hasHeader", "range", 5);
        this.m_Layout().putBelow("headerRow-label", "range", 5);
        this.m_Layout().putBelow("headerRow", "range", 5);
        this.m_Layout().putRight("headerRow-label", "hasHeader", 5);
        this.m_Layout().putRight("headerRow", "headerRow-label", 10);
        this.m_Layout().setHeight("hasHeader", "headerRow");
        this.m_Layout().setHeight("headerRow-label", "headerRow");
    }

    public void browse() {
        FileLoadDialog dlg = new FileLoadDialog();
        if (dlg.showOpenDialog(this.m_Component()) == 0) {
            File f = dlg.getSelectedFile();
            this.URL().setText(FileUtil.asURL(f));
            return;
        }
    }

    public void hasHeaderChanged() {
        boolean hasHeader = this.hasHeader().isSelected();
        this.headerRow().setEnabled(this.m_Component().isEnabled() && hasHeader);
        if (hasHeader && BoxesRunTime.unboxToInt((Object)this.headerRow().getValue()) == 0) {
            this.headerRow().setValue(BoxesRunTime.boxToInteger((int)1));
            return;
        }
    }

    @Override
    public void load() {
        super.load();
        ExcelDSBuilder$.MODULE$.from(this.wizard).foreach((Function1)(JProcedure1 & Serializable)builder -> {
            this.nameField().setText(builder.getName());
            this.descriptionField().setText(builder.getDescription());
            this.URL().setText(builder.getUrl());
            this.range().setText(builder.getRange());
            this.hasHeader().setSelected(builder.getHasHeaderRow());
            this.headerRow().setValue(BoxesRunTime.boxToInteger((int)builder.getHeaderRow()));
            boolean writable = !this.wizard.isSecuredReadOnly();
            SwingUtil.setEnabled(this.m_Component(), writable);
            boolean show = !this.wizard.isSecuredHideInternals();
            this.headerRowLabel().setVisible(show);
            this.URLLabel().setVisible(show);
            this.URL().setVisible(show);
            this.dots().setVisible(show);
            this.rangeLabel().setVisible(show);
            this.range().setVisible(show);
            this.hasHeader().setVisible(show);
            this.headerRow().setVisible(show);
            this.hasHeaderChanged();
            this.dots().setEnabled(writable && !DSUtil2.isRemote());
        });
    }

    @Override
    public void save() {
        super.save();
        ExcelDSBuilder$.MODULE$.from(this.wizard).foreach((Function1)(JProcedure1 & Serializable)builder -> {
            builder.setName(this.nameField().getText().replaceAll("\t", " ").trim());
            builder.setDescription(this.descriptionField().getText());
            builder.setUrl(this.URL().getText());
            builder.setRange(this.range().getText());
            builder.setHasHeaderRow(this.hasHeader().isSelected());
            if (this.hasHeader().isSelected()) {
                builder.setHeaderRow(BoxesRunTime.unboxToInt((Object)this.headerRow().getModel().getValue()));
                return;
            }
            builder.setHeaderRow(0);
        });
    }

    @Override
    public boolean isPageComplete() {
        String range;
        String filename;
        boolean ok = super.isPageComplete();
        if (ok && StringUtil.isEmpty((String)(filename = this.URL().getText()))) {
            this.setError((Option)Some$.MODULE$.apply((Object)I18N.ENSEMBLE.getString("DS.ExcelPage.URL_REQUIRED")));
            ok = false;
        }
        if (ok && StringUtil.isEmpty((String)(range = this.range().getText()))) {
            this.setError((Option)Some$.MODULE$.apply((Object)I18N.ENSEMBLE.getString("DS.ExcelPage.RANGE_REQUIRED")));
            ok = false;
        }
        return ok;
    }

    @Override
    public boolean canFlipToNextPage() {
        if (this.isPageComplete()) {
            return super.canFlipToNextPage();
        }
        return false;
    }

    @Override
    public Option<IWizardPage> getNextPage() {
        if (this.wizard.isSecuredHideInternals()) {
            return this.wizard.getPage(SecurityPage$.MODULE$.PageName());
        }
        return super.getNextPage();
    }

    public DataSchema inferSchema() {
        ExcelDataSource ds = new ExcelDataSource();
        int headerRow = 0;
        if (this.hasHeader().isSelected()) {
            headerRow = BoxesRunTime.unboxToInt((Object)this.headerRow().getModel().getValue());
        }
        ds.setHeaderRow(headerRow);
        ds.setRange(this.range().getText());
        ds.setURL(this.URL().getText());
        ds.setXLSX(true);
        ds.inferSchema((PushContext)new DefaultPushContext());
        return ds.getSchema();
    }

    @Override
    public boolean canFinish() {
        return ExcelDSBuilder$.MODULE$.from(this.wizard).exists((Function1 & Serializable)builder -> builder.getSchema().getColumnCount() > 0);
    }
}

