/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.wizard.datasource.jdbc;

import com.elixirtech.data2.datasource.jdbc.JDBCDataSource;
import com.elixirtech.ui.ArchLayout;
import com.elixirtech.ui.OrderedEditableTable;
import com.elixirtech.ui.SwingFactory;
import com.elixirtech.wizard.datasource.jdbc.CallableTableModel;
import com.elixirtech.wizard.datasource.jdbc.JDBCDSBuilder;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import scala.Function1;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

public class JDBCCallableStatementPanel
extends JPanel
implements ChangeListener,
ActionListener {
    private final String[] IN_DATATYPES = new String[]{"Boolean", "Byte", "Short", "Integer", "Long", "Float", "Double", "java.lang.String", "java.sql.Date", "java.sql.Time", "java.sql.Timestamp"};
    private final JTextArea m_SQLPanel;
    private final ArchLayout m_Layout;
    private final JTextArea m_SQLView;
    private final CallableTableModel m_TableModel;
    private final OrderedEditableTable m_Table;
    private final JTextField m_OutType;
    private final JLabel outTypeLabel;

    public JDBCCallableStatementPanel(JTextArea sqlPanel) {
        this.m_SQLPanel = sqlPanel;
        this.m_Layout = new ArchLayout();
        this.m_SQLView = new JTextArea(2, 30);
        this.m_TableModel = new CallableTableModel();
        this.m_Table = this.createParameterTable();
        this.m_OutType = SwingFactory.newTextField("outtype", 25);
        this.setLayout(this.m_Layout());
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.add("sqlview", new JScrollPane(this.m_SQLView()));
        this.m_SQLView().setEnabled(false);
        this.m_SQLView().setBackground(Color.LIGHT_GRAY);
        this.m_Layout().stickTop("sqlview");
        this.m_Layout().stickLeft("sqlview");
        this.m_Layout().stickRight("sqlview");
        this.outTypeLabel = SwingFactory.newLabel("outtype-label");
        this.add(this.outTypeLabel());
        this.m_Layout().stickLeft("outtype-label");
        this.m_Layout().putBelow("outtype-label", "sqlview");
        this.add(this.m_OutType());
        this.m_Layout().putBelow("outtype", "sqlview", 3);
        this.m_Layout().putRight("outtype", "outtype-label", 10);
        this.add("paramtable", this.m_Table());
        this.m_Layout().putBelow("paramtable", "outtype", 3);
        this.m_Layout().stickLeft("paramtable");
        this.m_Layout().stickRight("paramtable");
        this.m_Layout().stickBottom("paramtable");
    }

    public String[] IN_DATATYPES() {
        return this.IN_DATATYPES;
    }

    public JTextArea m_SQLPanel() {
        return this.m_SQLPanel;
    }

    public ArchLayout m_Layout() {
        return this.m_Layout;
    }

    public JTextArea m_SQLView() {
        return this.m_SQLView;
    }

    public CallableTableModel m_TableModel() {
        return this.m_TableModel;
    }

    public OrderedEditableTable m_Table() {
        return this.m_Table;
    }

    public JTextField m_OutType() {
        return this.m_OutType;
    }

    public JLabel outTypeLabel() {
        return this.outTypeLabel;
    }

    public void load(JDBCDSBuilder builder) {
        this.m_TableModel().clear();
        List<JDBCDataSource.InParameter> inParameters = builder.getInParameters();
        for (JDBCDataSource.InParameter element : inParameters) {
            String field = element.type.getTypeName();
            this.m_TableModel().addRow(new String[]{field, element.value});
        }
        this.m_OutType().setText(builder.getOutTypeValue());
        this.m_SQLView().setText(builder.getSQL());
    }

    private OrderedEditableTable createParameterTable() {
        OrderedEditableTable table = new OrderedEditableTable(this.m_TableModel(), false, false);
        table.setAutoResizeMode(4);
        table.setSingleSelectionMode();
        JComboBox<String> bx = new JComboBox<String>(this.IN_DATATYPES());
        bx.setEditable(false);
        DefaultCellEditor dce = new DefaultCellEditor(bx);
        int[] columnIndices = new int[]{0};
        DefaultCellEditor[] editors = new DefaultCellEditor[]{dce};
        table.setColumnEditors(columnIndices, editors);
        table.addActionListener(this);
        return table;
    }

    public void save(JDBCDSBuilder builder) {
        this.m_Table().disposeEditor();
        int sz = this.m_TableModel().getRowCount();
        ListBuffer listOfParameter = ListBuffer$.MODULE$.empty();
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), sz).foreach((Function1 & Serializable)i -> this.save$$anonfun$1(listOfParameter, BoxesRunTime.unboxToInt((Object)i)));
        builder.setInParameters((List<JDBCDataSource.InParameter>)listOfParameter.toList());
        String value = this.m_OutType().getText().trim();
        if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(value))) {
            builder.setOutTypeValue(value);
            return;
        }
        builder.setOutTypeValue("");
    }

    public JLabel addLabel(String name, String label) {
        JLabel item = new JLabel(label + ":");
        this.add(name + "-label", item);
        this.m_Layout().stickLeft(name + "-label");
        this.m_Layout().vCenter(name + "-label", name);
        return item;
    }

    public JCheckBox addCheckBox(String name, String label) {
        this.addLabel(name, label);
        JCheckBox item = new JCheckBox();
        this.add(name, item);
        this.m_Layout().putRight(name, name + "-label", 10);
        return item;
    }

    @Override
    public void setEnabled(boolean b) {
        this.m_OutType().setEnabled(b);
        this.m_Table().setEnabled(b);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        if ("plus".equals(command)) {
            int idx = this.m_TableModel().addRow(new String[]{"", ""});
            this.m_Table().select(idx);
            return;
        }
        if ("minus".equals(command)) {
            int idx = this.m_TableModel().deleteRow(this.m_Table().getSelectedRow());
            if (this.m_Table().getRowCount() >= idx) {
                --idx;
            }
            if (idx >= 0) {
                this.m_Table().select(idx);
                return;
            }
            return;
        }
        if ("up".equals(command)) {
            int idx = this.m_TableModel().moveUp(this.m_Table().getSelectedRow());
            this.m_Table().select(idx);
            return;
        }
        if ("down".equals(command)) {
            int idx = this.m_TableModel().moveDown(this.m_Table().getSelectedRow());
            this.m_Table().select(idx);
            return;
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.m_SQLView().setText(this.m_SQLPanel().getText());
    }

    private final /* synthetic */ ListBuffer save$$anonfun$1(ListBuffer listOfParameter$1, int i) {
        String[] ss = this.m_TableModel().getRow(i);
        String type = ss[0];
        String value = ss[1];
        return listOfParameter$1.addOne((Object)new JDBCDataSource.InParameter(type, value));
    }
}

