/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.wizard.datasource.jdbc;

import com.elixirtech.ensemble.I18N;
import com.elixirtech.ui.SwingFactory;
import com.elixirtech.wizard.IWizardPage;
import com.elixirtech.wizard.PageId;
import com.elixirtech.wizard.RelativeLayoutWizardPage;
import com.elixirtech.wizard.datasource.IDataSourceWizard;
import com.elixirtech.wizard.datasource.SecurityPage$;
import com.elixirtech.wizard.datasource.jdbc.JDBCDSBuilder$;
import com.elixirtech.wizard.datasource.jdbc.JDBCOptionsPage$;
import com.elixirtech.wizard.datasource.jdbc.JDBCSchemaPage$;
import java.io.Serializable;
import javax.swing.JCheckBox;
import javax.swing.JTextField;
import scala.Function1;
import scala.Option;
import scala.Some$;
import scala.runtime.function.JProcedure1;

public class JDBCOptionsPage
extends RelativeLayoutWizardPage {
    private final IDataSourceWizard wizard;
    private final JTextField m_MaxRows;
    private final JTextField m_FetchSize;
    private final JTextField m_Timeout;
    private final JCheckBox m_AutoCommit;
    private final JCheckBox m_SQLReadOnly;

    public static String PageName() {
        return JDBCOptionsPage$.MODULE$.PageName();
    }

    public static JDBCOptionsPage apply(IDataSourceWizard iDataSourceWizard) {
        return JDBCOptionsPage$.MODULE$.apply(iDataSourceWizard);
    }

    public JDBCOptionsPage(IDataSourceWizard wizard) {
        this.wizard = wizard;
        super(wizard, JDBCOptionsPage$.MODULE$.PageName(), (Option<PageId>)Some$.MODULE$.apply((Object)new PageId(JDBCSchemaPage$.MODULE$.PageName())));
        I18N.ENSEMBLE_MAP.injectObject(null, this, "DS.JDBC.OptionsPage");
        this.m_MaxRows = this.addLabelledField("max-rows");
        this.m_FetchSize = this.addLabelledField("fetch-size");
        this.m_Timeout = this.addLabelledField("timeout");
        this.m_AutoCommit = SwingFactory.newCheckBox("auto-commit");
        this.m_SQLReadOnly = SwingFactory.newCheckBox("read-only");
        this.m_Component().add(this.m_AutoCommit());
        this.m_Component().add(this.m_SQLReadOnly());
        I18N.ENSEMBLE_MAP.injectComponents("DS.JDBC.OptionsPage.", this.m_Component());
        this.stickTop("max-rows");
        this.putRight("max-rows", "max-rows-label,fetch-size-label,timeout-label", 10);
        this.alignBelow("fetch-size", "max-rows");
        this.alignBelow("timeout", "fetch-size");
        this.alignBelow("auto-commit", "timeout-label", 10);
        this.alignBelow("read-only", "auto-commit");
    }

    public JTextField m_MaxRows() {
        return this.m_MaxRows;
    }

    public JTextField m_FetchSize() {
        return this.m_FetchSize;
    }

    public JTextField m_Timeout() {
        return this.m_Timeout;
    }

    public JCheckBox m_AutoCommit() {
        return this.m_AutoCommit;
    }

    public JCheckBox m_SQLReadOnly() {
        return this.m_SQLReadOnly;
    }

    @Override
    public void load() {
        JDBCDSBuilder$.MODULE$.from(this.wizard).foreach((Function1)(JProcedure1 & Serializable)builder -> {
            this.m_MaxRows().setText(builder.getMaxRows());
            this.m_FetchSize().setText(builder.getFetchSize());
            this.m_Timeout().setText(builder.getTimeout());
            this.m_AutoCommit().setSelected(builder.getIsAutoCommit());
            this.m_SQLReadOnly().setSelected(builder.getIsReadOnly());
            boolean writable = !this.wizard.isSecuredReadOnly();
            this.m_MaxRows().setEnabled(writable);
            this.m_Timeout().setEnabled(writable);
            this.m_FetchSize().setEnabled(writable);
            this.m_AutoCommit().setEnabled(writable);
            this.m_SQLReadOnly().setEnabled(writable);
        });
    }

    @Override
    public void save() {
        JDBCDSBuilder$.MODULE$.from(this.wizard).foreach((Function1)(JProcedure1 & Serializable)builder -> {
            builder.setMaxRows(this.m_MaxRows().getText());
            builder.setTimeout(this.m_Timeout().getText());
            builder.setFetchSize(this.m_FetchSize().getText());
            builder.setIsAutoCommit(this.m_AutoCommit().isSelected());
            builder.setIsReadOnly(this.m_SQLReadOnly().isSelected());
        });
    }

    @Override
    public boolean isPageComplete() {
        return true;
    }

    @Override
    public Option<IWizardPage> getNextPage() {
        if (this.wizard.isSecuredHideInternals()) {
            return this.wizard.getPage(SecurityPage$.MODULE$.PageName());
        }
        return super.getNextPage();
    }

    @Override
    public boolean canFinish() {
        return JDBCDSBuilder$.MODULE$.from(this.wizard).exists((Function1 & Serializable)builder -> builder.getSchema().getColumnCount() > 0);
    }
}

