/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.wizard.datasource.jdbc;

import com.elixirtech.arch.Elixir$;
import com.elixirtech.arch.ElixirFrame;
import com.elixirtech.arch.IErrorHandler;
import com.elixirtech.data2.DataException;
import com.elixirtech.data2.DataSchema;
import com.elixirtech.data2.DefaultPushContext;
import com.elixirtech.data2.IDataSource;
import com.elixirtech.data2.ParameterUtil;
import com.elixirtech.data2.datasource.jdbc.JDBCDataSource;
import com.elixirtech.ensemble.I18N;
import com.elixirtech.ensemble.wizard.ParameterUI;
import com.elixirtech.icons.DatasourceIcons;
import com.elixirtech.remote.ISchemaAccess;
import com.elixirtech.wizard.PageId;
import com.elixirtech.wizard.RelativeLayoutWizardPage;
import com.elixirtech.wizard.datasource.IDataSourceWizard;
import com.elixirtech.wizard.datasource.SecurityPage$;
import com.elixirtech.wizard.datasource.WatchableDataSchemaPanel;
import com.elixirtech.wizard.datasource.jdbc.JDBCDSBuilder$;
import com.elixirtech.wizard.datasource.jdbc.JDBCSchemaPage$;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import javax.swing.JButton;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Some$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.function.JProcedure1;

public class JDBCSchemaPage
extends RelativeLayoutWizardPage
implements ActionListener {
    private final IDataSourceWizard wizard;
    private final JButton m_InferSchema;
    private final WatchableDataSchemaPanel m_SchemaPanel;

    public static String PageName() {
        return JDBCSchemaPage$.MODULE$.PageName();
    }

    public static JDBCSchemaPage apply(IDataSourceWizard iDataSourceWizard) {
        return JDBCSchemaPage$.MODULE$.apply(iDataSourceWizard);
    }

    public JDBCSchemaPage(IDataSourceWizard wizard) {
        this.wizard = wizard;
        super(wizard, JDBCSchemaPage$.MODULE$.PageName(), (Option<PageId>)Some$.MODULE$.apply((Object)new PageId(SecurityPage$.MODULE$.PageName())));
        I18N.ENSEMBLE_MAP.injectObject(null, this, "DS.JDBCSchemaPage");
        this.setIcon(DatasourceIcons.DATASOURCE_IMAGE);
        this.m_InferSchema = this.addButton("infer", this);
        this.m_SchemaPanel = new WatchableDataSchemaPanel(this);
        this.m_SchemaPanel().setName("schema");
        this.m_Component().add(this.m_SchemaPanel());
        I18N.ENSEMBLE_MAP.injectComponents("DS.JDBCSchemaPage.", this.m_Component());
        this.stickTop("infer");
        this.hCenter("infer");
        this.stickLeft("schema");
        this.putBelow("schema", "infer", 5);
        this.stickRight("schema");
        this.stickBottom("schema");
    }

    public JButton m_InferSchema() {
        return this.m_InferSchema;
    }

    public WatchableDataSchemaPanel m_SchemaPanel() {
        return this.m_SchemaPanel;
    }

    public void updateButtons() {
        this.wizard.container().updateButtons();
    }

    @Override
    public void load() {
        JDBCDSBuilder$.MODULE$.from(this.wizard).foreach((Function1)(JProcedure1 & Serializable)builder -> {
            this.m_SchemaPanel().setSchema(builder.getSchema());
            boolean writable = !this.wizard.isSecuredReadOnly();
            this.m_InferSchema().setEnabled(writable);
            this.m_SchemaPanel().setSchemaFixed(!writable);
        });
    }

    @Override
    public void save() {
        JDBCDSBuilder$.MODULE$.from(this.wizard).foreach((Function1)(JProcedure1 & Serializable)builder -> builder.setSchema(this.m_SchemaPanel().getSchema()));
    }

    @Override
    public boolean canFlipToNextPage() {
        return this.isPageComplete() && super.canFlipToNextPage();
    }

    @Override
    public boolean isPageComplete() {
        this.setError((Option)None$.MODULE$);
        int count = BoxesRunTime.unboxToInt((Object)Option$.MODULE$.apply((Object)this.m_SchemaPanel().getSchema()).map((Function1 & Serializable)_$1 -> _$1.getColumnCount()).getOrElse(JDBCSchemaPage::$anonfun$2));
        if (count == 0) {
            this.setError((Option)Some$.MODULE$.apply((Object)I18N.ENSEMBLE.getString("DS.JDBCSchemaPage.SCHEMA_REQUIRED")));
            return false;
        }
        return true;
    }

    public void infer() {
        JDBCDSBuilder$.MODULE$.from(this.wizard).foreach((Function1)(JProcedure1 & Serializable)builder -> {
            JDBCDataSource ds = builder.build();
            String maxRow = ds.getMaxRows();
            try {
                try {
                    List params = ds.getParameters();
                    boolean cancelled = false;
                    HashMap<String, String> values = new HashMap<String, String>();
                    if (ParameterUtil.getParamCount((List)params) > 0) {
                        ParameterUI ui = new ParameterUI(params, null);
                        ElixirFrame f = (ElixirFrame)Elixir$.MODULE$.get(ClassTag$.MODULE$.apply(ElixirFrame.class));
                        f.showWizard(ui);
                        if (ui.isFinished()) {
                            ui.populateProperties(values);
                        } else {
                            cancelled = true;
                        }
                    }
                    if (!cancelled) {
                        DefaultPushContext cxt = new DefaultPushContext();
                        if (values != null) {
                            cxt.setParameters(values);
                        }
                        ISchemaAccess access = (ISchemaAccess)Elixir$.MODULE$.get(ClassTag$.MODULE$.apply(ISchemaAccess.class));
                        ds.setMaxRows("10");
                        DataSchema schema = access.inferSchema((IDataSource)ds, values);
                        this.m_SchemaPanel().setSchema(schema);
                    }
                }
                catch (DataException ex) {
                    ((IErrorHandler)Elixir$.MODULE$.get(ClassTag$.MODULE$.apply(IErrorHandler.class))).error(I18N.ENSEMBLE.getString("DS.JDBCSchemaPage.INFER_ERROR"), (Throwable)ex);
                }
            }
            finally {
                ds.setMaxRows(maxRow);
            }
        });
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        this.infer();
    }

    private static final int $anonfun$2() {
        return 0;
    }
}

