/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.wizard.datasource.jdbc;

import com.elixirtech.arch.Elixir$;
import com.elixirtech.arch.ElixirFrame;
import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.arch.IErrorHandler;
import com.elixirtech.data2.ParameterUtil;
import com.elixirtech.data2.datasource.jdbc.JDBCDataSource;
import com.elixirtech.ensemble.I18N;
import com.elixirtech.ensemble.ds.IDataAccess2;
import com.elixirtech.ensemble.ds.StatisticsListener;
import com.elixirtech.ensemble.wizard.ParameterUI;
import com.elixirtech.wizard.datasource.IDataSourceWizard;
import com.elixirtech.wizard.datasource.jdbc.JDBCDSBuilder;
import com.elixirtech.wizard.datasource.jdbc.JDBCDSBuilder$;
import com.elixirtech.wizard.datasource.jdbc.JDBCSQLPage;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.NumberFormat;
import java.util.HashMap;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;

public final class TimeSQLAL
implements ActionListener {
    private final IDataSourceWizard wizard;
    private final JDBCSQLPage page;
    private final JPanel m_Component;
    private final ElxLoggerJ m_Log;

    public TimeSQLAL(IDataSourceWizard wizard, JDBCSQLPage page, JPanel m_Component, ElxLoggerJ m_Log) {
        this.wizard = wizard;
        this.page = page;
        this.m_Component = m_Component;
        this.m_Log = m_Log;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JDBCDataSource jDBCDataSource;
        Option<JDBCDSBuilder> option = JDBCDSBuilder$.MODULE$.from(this.wizard);
        if (option instanceof Some) {
            JDBCDSBuilder jds = (JDBCDSBuilder)((Some)option).value();
            jds.setSQL(this.page.m_SQL().getText());
            jDBCDataSource = jds.build();
        } else if (None$.MODULE$.equals(option)) {
            jDBCDataSource = new JDBCDataSource();
        } else {
            throw new MatchError(option);
        }
        JDBCDataSource ds = jDBCDataSource;
        ElixirFrame f = (ElixirFrame)Elixir$.MODULE$.get(ElixirFrame.class);
        f.setWaitCursor();
        try {
            try {
                List params = ds.getParameters();
                boolean cancelled = false;
                HashMap<String, String> values = new HashMap<String, String>();
                if (ParameterUtil.getParamCount((List)params) > 0) {
                    ParameterUI ui = new ParameterUI(params, null);
                    f.showWizard(ui);
                    if (ui.isFinished()) {
                        ui.populateProperties(values);
                    } else {
                        cancelled = true;
                    }
                }
                if (!cancelled) {
                    IDataAccess2 access = (IDataAccess2)Elixir$.MODULE$.get(ClassTag$.MODULE$.apply(IDataAccess2.class));
                    long start = System.currentTimeMillis();
                    StatisticsListener.Statistics stats = access.timeSQL(ds, values);
                    long stop = System.currentTimeMillis();
                    f.setArrowCursor();
                    NumberFormat nf = NumberFormat.getInstance();
                    nf.setGroupingUsed(true);
                    StringBuilder line1 = new StringBuilder();
                    StringBuilder line2 = new StringBuilder();
                    line1.append(ds.getName()).append(" read ").append(stats.count).append(" records in ").append(nf.format(stats.getDurationMillis())).append("ms ");
                    line2.append("overall turnaround in ").append(nf.format(stop - start)).append("ms");
                    this.m_Log.info((Object)(line1.toString() + line2.toString()));
                    StringBuilder msg = new StringBuilder();
                    msg.append("<html>").append(line1.toString()).append("<br>").append(line2.toString()).append("</html>");
                    JOptionPane.showMessageDialog(this.m_Component, msg.toString());
                }
            }
            catch (Throwable ex) {
                ((IErrorHandler)Elixir$.MODULE$.get(ClassTag$.MODULE$.apply(IErrorHandler.class))).error(I18N.ENSEMBLE.getString("DS.JDBCSQLPage.TIME_SQL_ERROR"), ex);
            }
        }
        finally {
            f.setArrowCursor();
        }
    }
}

