/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.wizard.datasource.ldap;

import com.elixirtech.arch.Elixir$;
import com.elixirtech.arch.IErrorHandler;
import com.elixirtech.data2.DataSchema;
import com.elixirtech.data2.DefaultPushContext;
import com.elixirtech.data2.PushContext;
import com.elixirtech.data2.datasource.ldap.LDAPDataSource;
import com.elixirtech.ensemble.I18N;
import com.elixirtech.icons.DatasourceIcons;
import com.elixirtech.ui.SwingFactory;
import com.elixirtech.ui.SwingUtil;
import com.elixirtech.wizard.AL$;
import com.elixirtech.wizard.IWizardPage;
import com.elixirtech.wizard.PageId;
import com.elixirtech.wizard.RelativeLayoutWizardPage;
import com.elixirtech.wizard.datasource.IDataSourceWizard;
import com.elixirtech.wizard.datasource.SecurityPage$;
import com.elixirtech.wizard.datasource.WatchableDataSchemaPanel;
import com.elixirtech.wizard.datasource.ldap.LDAPDSBuilder$;
import com.elixirtech.wizard.datasource.ldap.LDAPDefinitionPage$;
import java.io.Serializable;
import javax.naming.NamingException;
import javax.swing.JButton;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Some$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.function.JProcedure1;
import scala.runtime.java8.JFunction0;

public class LDAPDefinitionPage
extends RelativeLayoutWizardPage {
    private final IDataSourceWizard wizard;
    private final WatchableDataSchemaPanel m_SchemaPanel;
    private final JButton m_InferSchema;

    public static String PageName() {
        return LDAPDefinitionPage$.MODULE$.PageName();
    }

    public static LDAPDefinitionPage apply(IDataSourceWizard iDataSourceWizard) {
        return LDAPDefinitionPage$.MODULE$.apply(iDataSourceWizard);
    }

    public LDAPDefinitionPage(IDataSourceWizard wizard) {
        this.wizard = wizard;
        super(wizard, LDAPDefinitionPage$.MODULE$.PageName(), (Option<PageId>)Some$.MODULE$.apply((Object)new PageId(SecurityPage$.MODULE$.PageName())));
        I18N.ENSEMBLE_MAP.injectObject(null, this, "DS.LDAPDefinitionPage");
        this.setIcon(DatasourceIcons.DATASOURCE_IMAGE);
        this.m_SchemaPanel = new WatchableDataSchemaPanel(this);
        this.m_InferSchema = SwingFactory.newButton("infer");
        this.m_InferSchema().addActionListener(AL$.MODULE$.apply((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.infer()));
        this.m_Component().add(this.m_InferSchema());
        this.m_Component().add(this.m_SchemaPanel());
        I18N.ENSEMBLE_MAP.injectComponents("DS.LDAPDefinitionPage.", this.m_Component());
        this.stickTop("infer");
        this.hCenter("infer");
        this.putBelow("schema", "infer", 5);
        this.stickLeft("schema");
        this.stickRight("schema");
        this.stickBottom("schema");
    }

    public WatchableDataSchemaPanel m_SchemaPanel() {
        return this.m_SchemaPanel;
    }

    public JButton m_InferSchema() {
        return this.m_InferSchema;
    }

    public void infer() {
        LDAPDSBuilder$.MODULE$.from(this.wizard).foreach((Function1)(JProcedure1 & Serializable)builder -> {
            LDAPDataSource src = builder.build();
            DefaultPushContext cxt = new DefaultPushContext();
            try {
                DataSchema schema = src.inferSchema((PushContext)cxt);
                this.m_SchemaPanel().setSchema(schema);
            }
            catch (NamingException ex) {
                ((IErrorHandler)Elixir$.MODULE$.get(ClassTag$.MODULE$.apply(IErrorHandler.class))).error(I18N.ENSEMBLE.getString("DS.LDAPDefinitionPage.INFER_ERROR"), (Throwable)ex);
            }
        });
    }

    @Override
    public void load() {
        LDAPDSBuilder$.MODULE$.from(this.wizard).foreach((Function1)(JProcedure1 & Serializable)builder -> {
            this.m_SchemaPanel().setSchema(builder.getSchema());
            boolean writable = !this.wizard.isSecuredReadOnly();
            SwingUtil.setEnabled(this.m_Component(), writable);
        });
    }

    @Override
    public void save() {
        LDAPDSBuilder$.MODULE$.from(this.wizard).foreach((Function1)(JProcedure1 & Serializable)builder -> builder.setSchema(this.m_SchemaPanel().getSchema()));
    }

    @Override
    public boolean canFlipToNextPage() {
        return this.isPageComplete() && super.canFlipToNextPage();
    }

    @Override
    public Option<IWizardPage> getNextPage() {
        return this.wizard.getPage(SecurityPage$.MODULE$.PageName());
    }

    @Override
    public boolean isPageComplete() {
        this.setError((Option)None$.MODULE$);
        int count = BoxesRunTime.unboxToInt((Object)Option$.MODULE$.apply((Object)this.m_SchemaPanel().getSchema()).map((Function1 & Serializable)_$1 -> _$1.getColumnCount()).getOrElse(LDAPDefinitionPage::$anonfun$2));
        if (count == 0) {
            this.setError((Option)Some$.MODULE$.apply((Object)I18N.ENSEMBLE.getString("DS.LDAPDefinitionPage.SCHEMA_REQUIRED")));
            return false;
        }
        return true;
    }

    private static final int $anonfun$2() {
        return 0;
    }
}

