/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.wizard.datasource.ldap;

import com.elixirtech.arch.LoggingHelper2;
import com.elixirtech.arch.LoggingInterface;
import com.elixirtech.arch.StringUtil;
import com.elixirtech.data2.datasource.ldap.LDAPDataSource;
import com.elixirtech.ensemble.I18N;
import com.elixirtech.i18n.I18NComboBox;
import com.elixirtech.i18n.I18NComboBox$;
import com.elixirtech.i18n.Name;
import com.elixirtech.ui.ArchLayout;
import com.elixirtech.ui.SwingFactory;
import com.elixirtech.wizard.FieldWatcher;
import com.elixirtech.wizard.IWizardPage;
import com.elixirtech.wizard.PageId;
import com.elixirtech.wizard.datasource.DSFirstPage;
import com.elixirtech.wizard.datasource.IDataSourceWizard;
import com.elixirtech.wizard.datasource.SecurityPage$;
import com.elixirtech.wizard.datasource.ldap.LDAPDSBuilder$;
import com.elixirtech.wizard.datasource.ldap.LDAPPage$;
import com.elixirtech.wizard.datasource.ldap.LDAPSecurityPage$;
import com.elixirtech.wizard.datasource.ldap.NumberDoc;
import java.awt.BorderLayout;
import java.io.Serializable;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Some$;
import scala.collection.ArrayOps$;
import scala.collection.StringOps$;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.function.JProcedure1;

public class LDAPPage
extends DSFirstPage
implements LoggingHelper2 {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(LDAPPage.class.getDeclaredField("log$lzy1"));
    private volatile Object log$lzy1;
    private final IDataSourceWizard wizard;
    private final Name[] model;
    private final JTextField m_Location;
    private final JTextField m_DN;
    private final I18NComboBox m_Scope;
    private final JTextField m_Filter;
    private final ArchLayout layout;
    private final JPanel m_SettingPanel;
    private final String title;
    private final JCheckBox m_LDAPTrace;
    private final JTextField m_Port;
    private final JTextField m_TimeOut;
    private final JTextField m_BatchSize;

    public static String PageName() {
        return LDAPPage$.MODULE$.PageName();
    }

    public static LDAPPage apply(IDataSourceWizard iDataSourceWizard) {
        return LDAPPage$.MODULE$.apply(iDataSourceWizard);
    }

    public LDAPPage(IDataSourceWizard wizard) {
        this.wizard = wizard;
        super(wizard, LDAPPage$.MODULE$.PageName(), (Option<PageId>)Some$.MODULE$.apply((Object)new PageId(LDAPSecurityPage$.MODULE$.PageName())));
        I18N.ENSEMBLE_MAP.injectObject(null, this, "DS.LDAPPage");
        String[] KEYS = new String[]{"LDAP.Scope.Object", "LDAP.Scope.OneLevel", "LDAP.Scope.Subtree"};
        this.model = I18NComboBox$.MODULE$.buildNames(LDAPDataSource.SCOPES, I18N.ENSEMBLE, KEYS);
        this.m_Location = this.addLabelledField("location");
        this.m_DN = this.addLabelledField("dn");
        this.m_Scope = I18NComboBox$.MODULE$.apply(this.model());
        this.m_Filter = this.addLabelledField("filter");
        this.layout = new ArchLayout();
        this.m_SettingPanel = new JPanel(this.layout());
        this.title = I18N.ENSEMBLE.getString("DS.LDAPPage.DEFAULT_SETTING");
        this.m_LDAPTrace = new JCheckBox();
        this.m_Port = SwingFactory.newTextField("port", 10);
        this.m_TimeOut = SwingFactory.newTextField("timeout", 10);
        this.m_BatchSize = SwingFactory.newTextField("batchsize", 10);
        this.addLabel(SwingFactory.newLabel("scope-label"));
        this.m_Scope().setName("scope");
        this.m_Component().add(this.m_Scope());
        this.nameField().getDocument().addDocumentListener(new FieldWatcher(wizard));
        this.m_Location().getDocument().addDocumentListener(new FieldWatcher(wizard));
        this.m_DN().getDocument().addDocumentListener(new FieldWatcher(wizard));
        SwingFactory.newTitledPanel(new BorderLayout(), new JLabel(I18N.ENSEMBLE.getString("DS.LDAPPage.DEFAULT_SETTING")));
        this.m_SettingPanel().setBorder(BorderFactory.createTitledBorder(this.title()));
        this.m_SettingPanel().setLayout(this.layout());
        this.m_SettingPanel().add(SwingFactory.newLabel("port-label"));
        this.m_SettingPanel().add(this.m_Port);
        this.m_SettingPanel().add(SwingFactory.newLabel("timeout-label"));
        this.m_SettingPanel().add(this.m_TimeOut);
        this.m_SettingPanel().add(SwingFactory.newLabel("batchsize-label"));
        this.m_SettingPanel().add(this.m_BatchSize);
        this.layout().stickTop("port");
        this.layout().putRight("port", "port-label,timeout-label", 10);
        this.layout().stickLeft("port-label");
        this.layout().vCenter("port-label", "port");
        this.layout().alignBelow("timeout", "port");
        this.layout().stickLeft("timeout-label");
        this.layout().vCenter("timeout-label", "timeout");
        this.layout().putRight("batchsize-label", "port", 10);
        this.layout().stickTop("batchsize");
        this.layout().putRight("batchsize", "batchsize-label", 10);
        this.layout().vCenter("batchsize-label", "batchsize");
        this.m_Component().add("ldapsetting", this.m_SettingPanel());
        this.m_Port.setDocument(new NumberDoc(0));
        this.m_TimeOut.setDocument(new NumberDoc(0));
        this.m_BatchSize.setDocument(new NumberDoc(0));
        this.m_Port.setText("389");
        this.m_TimeOut.setText("0");
        this.m_BatchSize.setText("0");
        I18N.ENSEMBLE_MAP.injectComponents("DS.LDAPPage.", this.m_Component());
        this.positionComponents();
    }

    public LoggingInterface log() {
        Object object = this.log$lzy1;
        if (object instanceof LoggingInterface) {
            return (LoggingInterface)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (LoggingInterface)this.log$lzyINIT1();
    }

    private Object log$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.log$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    LoggingInterface loggingInterface = null;
                    try {
                        loggingInterface = LoggingHelper2.log$((LoggingHelper2)this);
                        object2 = loggingInterface == null ? LazyVals.NullValue$.MODULE$ : loggingInterface;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.log$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return loggingInterface;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public Name[] model() {
        return this.model;
    }

    public JTextField m_Location() {
        return this.m_Location;
    }

    public JTextField m_DN() {
        return this.m_DN;
    }

    public I18NComboBox m_Scope() {
        return this.m_Scope;
    }

    public JTextField m_Filter() {
        return this.m_Filter;
    }

    public ArchLayout layout() {
        return this.layout;
    }

    public JPanel m_SettingPanel() {
        return this.m_SettingPanel;
    }

    public String title() {
        return this.title;
    }

    public JCheckBox m_LDAPTrace() {
        return this.m_LDAPTrace;
    }

    private void positionComponents() {
        this.putRight(this.DS_NAME(), this.DS_ALIGN() + ",location-label,dn-label,scope-label,filter-label", 10);
        this.alignBelow("location", this.DS_DESC(), 5);
        this.alignBelow("dn", "location");
        this.alignBelow("scope", "dn");
        this.stickRight("scope");
        this.alignBelow("filter", "scope");
        this.stickBottom("ldapsetting");
        this.stickLeft("ldapsetting");
        this.stickRight("ldapsetting");
    }

    private void updateComponentStatus(IDataSourceWizard wizard) {
        boolean writable = !wizard.isSecuredReadOnly();
        boolean showInternals = !wizard.isSecuredHideInternals();
        this.nameField().setEnabled(writable);
        this.descriptionField().setEnabled(writable);
        this.m_Location().setEnabled(writable);
        this.m_DN().setEnabled(writable);
        this.m_Scope().setEnabled(writable);
        this.m_Filter().setEnabled(writable);
        this.m_Port.setEnabled(writable);
        this.m_TimeOut.setEnabled(writable);
        this.m_BatchSize.setEnabled(writable);
        this.m_LDAPTrace().setEnabled(writable);
        this.m_Location().setVisible(showInternals);
        this.m_DN().setVisible(showInternals);
        this.m_Scope().setVisible(showInternals);
        this.m_Filter().setVisible(showInternals);
        this.m_SettingPanel().setVisible(showInternals);
        Object[] components = this.m_Component().getComponents();
        Object object = Predef$.MODULE$.refArrayOps(components);
        ArrayOps$.MODULE$.foreach$extension(object, (Function1)(JProcedure1 & Serializable)component -> {
            String name = component.getName();
            if (!name.startsWith(this.DS_NAME()) && !name.startsWith(this.DS_DESC())) {
                component.setVisible(showInternals);
                return;
            }
        });
    }

    @Override
    public void save() {
        super.save();
        LDAPDSBuilder$.MODULE$.from(this.wizard).foreach((Function1)(JProcedure1 & Serializable)builder -> {
            builder.setName(this.nameField().getText().replaceAll("\t", " ").trim());
            builder.setDescription(this.descriptionField().getText());
            builder.setLocation(this.m_Location().getText());
            builder.setBaseDN(this.m_DN().getText());
            builder.setScope(this.m_Scope().getSelectedId());
            builder.setFilter(this.m_Filter().getText());
            builder.setPort(StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(this.m_Port.getText())));
            builder.setTimeOut(StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(this.m_TimeOut.getText())));
            builder.setBatchSize(StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(this.m_BatchSize.getText())));
            builder.setLDAPTrace(this.m_LDAPTrace().isSelected());
        });
        this.updateComponentStatus(this.wizard);
    }

    @Override
    public void load() {
        super.load();
        LDAPDSBuilder$.MODULE$.from(this.wizard).foreach((Function1)(JProcedure1 & Serializable)builder -> {
            this.nameField().setText(builder.getName());
            this.descriptionField().setText(builder.getDescription());
            this.m_Location().setText(builder.getLocation());
            this.m_DN().setText(builder.getBaseDN());
            this.m_Scope().setSelectedId(builder.getScope());
            this.m_Filter().setText(builder.getFilter());
            this.m_Port.setText(Integer.toString(builder.getPort() == 0 ? 389 : builder.getPort()));
            this.m_TimeOut.setText(Integer.toString(builder.getTimeOut()));
            this.m_BatchSize.setText(Integer.toString(builder.getBatchSize()));
            this.m_LDAPTrace().setSelected(builder.getLDAPTrace());
        });
        this.updateComponentStatus(this.wizard);
    }

    @Override
    public boolean canFlipToNextPage() {
        return this.isPageComplete() && super.canFlipToNextPage();
    }

    @Override
    public Option<IWizardPage> getNextPage() {
        if (this.wizard.isSecuredHideInternals()) {
            return this.wizard.getPage(SecurityPage$.MODULE$.PageName());
        }
        return super.getNextPage();
    }

    @Override
    public boolean canFinish() {
        return LDAPDSBuilder$.MODULE$.from(this.wizard).exists((Function1 & Serializable)builder -> builder.getSchema().getColumnCount() > 0);
    }

    @Override
    public boolean isPageComplete() {
        String location;
        boolean ok = super.isPageComplete();
        if (ok && StringUtil.isEmpty((String)(location = this.m_Location().getText()))) {
            this.setError((Option)Some$.MODULE$.apply((Object)I18N.ENSEMBLE.getString("DS.LDAPPage.HOST_REQUIRED")));
            ok = false;
        }
        return ok;
    }
}

