/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.wizard.datasource.ldap;

import com.elixirtech.arch.ui.ViewablePasswordField;
import com.elixirtech.ensemble.I18N;
import com.elixirtech.i18n.I18NComboBox;
import com.elixirtech.i18n.I18NComboBox$;
import com.elixirtech.i18n.Name;
import com.elixirtech.icons.DatasourceIcons;
import com.elixirtech.ui.SwingFactory;
import com.elixirtech.wizard.IL$;
import com.elixirtech.wizard.IWizardPage;
import com.elixirtech.wizard.PageId;
import com.elixirtech.wizard.RelativeLayoutWizardPage;
import com.elixirtech.wizard.datasource.IDataSourceWizard;
import com.elixirtech.wizard.datasource.SecurityPage$;
import com.elixirtech.wizard.datasource.ldap.LDAPDSBuilder;
import com.elixirtech.wizard.datasource.ldap.LDAPDSBuilder$;
import com.elixirtech.wizard.datasource.ldap.LDAPDefinitionPage$;
import com.elixirtech.wizard.datasource.ldap.LDAPSecurityPage$;
import java.io.Serializable;
import javax.swing.JLabel;
import javax.swing.JTextField;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Some$;
import scala.runtime.BoxedUnit;
import scala.runtime.function.JProcedure1;
import scala.runtime.java8.JFunction0;

public class LDAPSecurityPage
extends RelativeLayoutWizardPage {
    private final IDataSourceWizard wizard;
    private final Name[] model;
    private final I18NComboBox m_AuthenticationType;
    private final JLabel m_UserLabel;
    private final JTextField m_UserName;
    private final JLabel m_PasswordLabel;
    private final ViewablePasswordField m_Password;
    private final JLabel m_ProtocolLabel;
    private final JTextField m_Protocol;

    public static String PageName() {
        return LDAPSecurityPage$.MODULE$.PageName();
    }

    public static LDAPSecurityPage apply(IDataSourceWizard iDataSourceWizard) {
        return LDAPSecurityPage$.MODULE$.apply(iDataSourceWizard);
    }

    public LDAPSecurityPage(IDataSourceWizard wizard) {
        this.wizard = wizard;
        super(wizard, LDAPSecurityPage$.MODULE$.PageName(), (Option<PageId>)Some$.MODULE$.apply((Object)new PageId(LDAPDefinitionPage$.MODULE$.PageName())));
        I18N.ENSEMBLE_MAP.injectObject(null, this, "DS.LDAPSecurityPage");
        this.setIcon(DatasourceIcons.DATASOURCE_IMAGE);
        String[] IDS = new String[]{"none", "simple", "GSSAPI", "DIGEST-MD5"};
        String[] KEYS = new String[]{"LDAPSecurity.NONE", "LDAPSecurity.SIMPLE", "LDAPSecurity.GSSAPI", "LDAPSecurity.DIGEST_MD5"};
        this.addLabel(SwingFactory.newLabel("auth-type-label"));
        this.model = I18NComboBox$.MODULE$.buildNames(IDS, I18N.ENSEMBLE, KEYS);
        this.m_AuthenticationType = I18NComboBox$.MODULE$.apply(this.model());
        this.m_UserLabel = this.addLabel(SwingFactory.newLabel("username-label"));
        this.m_UserName = SwingFactory.newTextField("username");
        this.m_PasswordLabel = this.addLabel(SwingFactory.newLabel("password-label"));
        this.m_Password = new ViewablePasswordField();
        this.m_ProtocolLabel = this.addLabel(SwingFactory.newLabel("protocol-label"));
        this.m_Protocol = SwingFactory.newTextField("protocol");
        this.m_AuthenticationType().setName("auth-type");
        this.m_AuthenticationType().addItemListener(IL$.MODULE$.apply((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.updateUI()));
        this.m_Component().add(this.m_AuthenticationType());
        this.m_Component().add(this.m_UserName());
        this.m_Password().setName("password");
        this.m_Component().add(this.m_Password());
        this.m_Component().add(this.m_Protocol());
        I18N.ENSEMBLE_MAP.injectComponents("DS.LDAPSecurityPage.", this.m_Component());
        this.stickTop("auth-type");
        this.putRight("auth-type", "auth-type-label,username-label,password-label,protocol-label", 10);
        this.alignBelow("username", "auth-type", 10);
        this.alignBelow("password", "username");
        this.alignBelow("protocol", "password");
        this.stickRight("username");
        this.stickRight("password");
        this.stickRight("protocol");
    }

    public Name[] model() {
        return this.model;
    }

    public I18NComboBox m_AuthenticationType() {
        return this.m_AuthenticationType;
    }

    public JLabel m_UserLabel() {
        return this.m_UserLabel;
    }

    public JTextField m_UserName() {
        return this.m_UserName;
    }

    public JLabel m_PasswordLabel() {
        return this.m_PasswordLabel;
    }

    public ViewablePasswordField m_Password() {
        return this.m_Password;
    }

    public JLabel m_ProtocolLabel() {
        return this.m_ProtocolLabel;
    }

    public JTextField m_Protocol() {
        return this.m_Protocol;
    }

    private void updateComponentStatus(IDataSourceWizard wizard) {
        boolean writable = !wizard.isSecuredReadOnly();
        this.m_AuthenticationType().setEnabled(writable);
        this.m_Password().setEnabled(writable);
        this.m_Protocol().setEnabled(writable);
        this.m_UserName().setEnabled(writable);
    }

    private void initData(LDAPDSBuilder builder) {
        this.m_AuthenticationType().setSelectedId(builder.getAuthenticationType());
        this.m_UserName().setText(builder.getPrinciple());
        this.m_Password().setText(builder.getCredentials());
        this.m_Protocol().setText(builder.getProtocol());
    }

    public void updateUI() {
        String type = this.m_AuthenticationType().getSelectedId();
        boolean validType = !"none".equals(type);
        this.m_UserLabel().setVisible(validType);
        this.m_UserName().setVisible(validType);
        this.m_PasswordLabel().setVisible(validType);
        this.m_Password().setVisible(validType);
        this.m_ProtocolLabel().setVisible(validType);
        this.m_Protocol().setVisible(validType);
    }

    @Override
    public void save() {
        LDAPDSBuilder$.MODULE$.from(this.wizard).foreach((Function1)(JProcedure1 & Serializable)builder -> {
            builder.setAuthenticationType(this.m_AuthenticationType().getSelectedId());
            builder.setPrinciple(this.m_UserName().getText());
            builder.setCredentials(this.m_Password().getText());
            builder.setProtocol(this.m_Protocol().getText());
        });
        this.updateComponentStatus(this.wizard);
    }

    @Override
    public void load() {
        LDAPDSBuilder$.MODULE$.from(this.wizard).foreach((Function1)(JProcedure1 & Serializable)builder -> {
            this.initData((LDAPDSBuilder)builder);
            this.updateUI();
        });
        this.updateComponentStatus(this.wizard);
    }

    @Override
    public Option<IWizardPage> getNextPage() {
        if (this.wizard.isSecuredHideInternals()) {
            return this.wizard.getPage(SecurityPage$.MODULE$.PageName());
        }
        return super.getNextPage();
    }

    @Override
    public boolean canFinish() {
        return LDAPDSBuilder$.MODULE$.from(this.wizard).exists((Function1 & Serializable)builder -> builder.getSchema().getColumnCount() > 0);
    }

    @Override
    public boolean isPageComplete() {
        return true;
    }
}

