/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.wizard.datasource.ldap;

import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public final class NumberDoc
extends PlainDocument {
    public static final int INTEGER = 0;
    public static final int FLOAT = 2;
    private NumberRule m_NumberRule;

    public NumberDoc() {
        this.m_NumberRule = new FloatRule();
    }

    public NumberDoc(int n) {
        if (n == 2) {
            this.m_NumberRule = new FloatRule();
        } else if (n == 0) {
            this.m_NumberRule = new IntegerRule();
        }
    }

    @Override
    public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
        try {
            this.m_NumberRule.insertString(n, string, attributeSet);
        }
        catch (NumberFormatException numberFormatException) {
            return;
        }
        super.insertString(n, string, attributeSet);
    }

    private static final class FloatRule
    implements NumberRule {
        private FloatRule() {
        }

        @Override
        public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException, NumberFormatException {
            for (int i = 0; i < string.length(); ++i) {
                char c = string.charAt(i);
                if (Character.isDigit(c) || c == '.') continue;
                throw new NumberFormatException();
            }
        }
    }

    static interface NumberRule {
        public void insertString(int var1, String var2, AttributeSet var3) throws BadLocationException, NumberFormatException;
    }

    private static final class IntegerRule
    implements NumberRule {
        private IntegerRule() {
        }

        @Override
        public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException, NumberFormatException {
            for (int i = 0; i < string.length(); ++i) {
                char c = string.charAt(i);
                if (Character.isDigit(c)) continue;
                throw new NumberFormatException();
            }
        }
    }
}

