/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.wizard.datasource.object;

import com.elixirtech.editor.JEditor;
import com.elixirtech.editor.REJavaScriptTypes$;
import com.elixirtech.ensemble.I18N;
import com.elixirtech.ui.SwingUtil;
import com.elixirtech.wizard.FieldWatcher;
import com.elixirtech.wizard.PageId;
import com.elixirtech.wizard.RelativeLayoutWizardPage;
import com.elixirtech.wizard.datasource.BasicSecurityPage$;
import com.elixirtech.wizard.datasource.IDataSourceWizard;
import com.elixirtech.wizard.datasource.object.JavaObjectDSBuilder$;
import com.elixirtech.wizard.datasource.object.JavaObjectScriptPage$;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.Serializable;
import javax.swing.BorderFactory;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import scala.Function1;
import scala.Option;
import scala.Some$;
import scala.collection.mutable.StringBuilder;
import scala.runtime.function.JProcedure1;

public class JavaObjectScriptPage
extends RelativeLayoutWizardPage {
    private final IDataSourceWizard wizard;
    private final JEditor m_JavaScriptEditor;
    private final JTabbedPane jsTabPane;

    public static String PageName() {
        return JavaObjectScriptPage$.MODULE$.PageName();
    }

    public static JavaObjectScriptPage apply(IDataSourceWizard iDataSourceWizard) {
        return JavaObjectScriptPage$.MODULE$.apply(iDataSourceWizard);
    }

    public JavaObjectScriptPage(IDataSourceWizard wizard) {
        this.wizard = wizard;
        super(wizard, JavaObjectScriptPage$.MODULE$.PageName(), (Option<PageId>)Some$.MODULE$.apply((Object)new PageId(BasicSecurityPage$.MODULE$.PageName())));
        this.m_JavaScriptEditor = new JEditor("", REJavaScriptTypes$.MODULE$.kit());
        this.jsTabPane = new JTabbedPane();
        I18N.ENSEMBLE_MAP.injectObject(null, this, "DS.JavaObjectScriptPage");
        this.m_Component().setLayout(new BorderLayout());
        this.m_Component().setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.m_JavaScriptEditor().getDocument().addDocumentListener(new FieldWatcher(wizard));
        this.jsTabPane().addTab(I18N.ENSEMBLE.getString("DS.JavaObjectScriptPage.JAVASCRIPT"), new JScrollPane(this.m_JavaScriptEditor()));
        this.m_Component().add((Component)this.jsTabPane(), "Center");
        I18N.ENSEMBLE_MAP.injectComponents("DS.JavaObjectScriptPage.", this.m_Component());
    }

    public JEditor m_JavaScriptEditor() {
        return this.m_JavaScriptEditor;
    }

    public JTabbedPane jsTabPane() {
        return this.jsTabPane;
    }

    @Override
    public boolean isPageComplete() {
        return true;
    }

    @Override
    public void save() {
        JavaObjectDSBuilder$.MODULE$.from(this.wizard).foreach((Function1)(JProcedure1 & Serializable)builder -> builder.setJavaScript(this.m_JavaScriptEditor().getText()));
    }

    @Override
    public void load() {
        JavaObjectDSBuilder$.MODULE$.from(this.wizard).foreach((Function1)(JProcedure1 & Serializable)builder -> {
            String string = builder.getJavaScript();
            String string2 = "";
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                this.m_JavaScriptEditor().setText(this.getDefaultScript());
            } else {
                this.m_JavaScriptEditor().setText(builder.getJavaScript());
            }
            boolean writable = !this.wizard.isSecuredReadOnly();
            SwingUtil.setEnabled(this.m_Component(), writable);
        });
    }

    private String getDefaultScript() {
        StringBuilder sb = new StringBuilder();
        sb.append("// " + I18N.ENSEMBLE.getString("DS.JavaObjectScriptPage.SAMPLE") + "\n\n");
        sb.append("function pushTo(/*PushContext*/ cxt, /*DataListener*/ dl)\n");
        sb.append("{\n");
        sb.append("  // put any imports here\n");
        sb.append("  // call start data to begin rendering the header\n");
        sb.append("  dl.startData(this);\n");
        sb.append("  // get the data to be iterated over\n");
        sb.append("  var dIter = Company.getEmployeesAsIterator();\n");
        sb.append("  while (dIter.hasNext())\n");
        sb.append("  {\n");
        sb.append("    // get the data values to supply\n");
        sb.append("    dataObj = dIter.next();\n");
        sb.append("    // create a record instance to supply the values in\n");
        sb.append("    var rec = this.newRecordInstance();\n");
        sb.append("    // get the Object[] to hold the values\n");
        sb.append("    var data = rec.getData();\n");
        sb.append("    // fill in the values according to the schema\n");
        sb.append("    data[0] = dataObj.getDateJoined();\n");
        sb.append("    data[1] = dataObj.getDeparment();\n");
        sb.append("    // etc.\n");
        sb.append("    // call process record to begin rendering a detail\n");
        sb.append("    dl.processRecord(rec);\n");
        sb.append("  }\n");
        sb.append("  // call end data to begin rendering the footer\n");
        sb.append("  dl.endData(this);\n");
        sb.append("}\n");
        return sb.toString();
    }
}

