/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.wizard.datasource.tabular;

import com.elixirtech.data2.DataSchema;
import com.elixirtech.data2.DataType;
import com.elixirtech.ensemble.I18N;
import com.elixirtech.wizard.datasource.tabular.Record;
import java.io.Serializable;
import javax.swing.table.AbstractTableModel;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.None$;
import scala.collection.immutable.Vector;
import scala.collection.mutable.ListBuffer;
import scala.runtime.BoxesRunTime;
import scala.runtime.function.JProcedure1;
import scala.util.Try$;

public class RecordModel
extends AbstractTableModel {
    private DataSchema m_Schema = new DataSchema();
    private final ListBuffer<Record> m_Records = new ListBuffer();

    public void setSchema(DataSchema schema) {
        this.m_Schema = schema;
        this.fireTableStructureChanged();
    }

    public DataSchema getSchema() {
        return this.m_Schema;
    }

    public void setRecords(Vector<Record> recs) {
        this.m_Records.clear();
        this.m_Records.$plus$plus$eq(recs);
        this.fireTableStructureChanged();
    }

    public Vector<Record> getRecords() {
        return this.m_Records.toVector();
    }

    public void setSchemaAndRecords(DataSchema schema, Vector<Record> recs) {
        this.m_Schema = schema;
        this.m_Records.clear();
        this.m_Records.$plus$plus$eq(recs);
        this.fireTableStructureChanged();
    }

    @Override
    public int getColumnCount() {
        return this.m_Schema.getColumnCount() + 1;
    }

    @Override
    public String getColumnName(int idx) {
        if (idx == 0) {
            return I18N.ENSEMBLE.getString("Row");
        }
        return this.m_Schema.getColumnName(idx - 1);
    }

    @Override
    public int getRowCount() {
        return this.m_Records.size();
    }

    public void renameColumn(String oldName, String newName) {
        this.m_Records.foreach((Function1)(JProcedure1 & Serializable)_$1 -> _$1.rename(oldName, newName));
    }

    public void updateSchema(String columnName, DataType oldDT, DataType newDT) {
        boolean convertible = this.isConvertible(newDT);
        this.m_Records.foreach((Function1)(JProcedure1 & Serializable)r -> {
            None$ v2 = convertible ? r.getData(columnName).flatMap((Function1 & Serializable)v1 -> {
                String s = this.m_Schema.format(oldDT, v1);
                return Try$.MODULE$.apply(() -> this.$anonfun$1$$anonfun$1(newDT, s)).toOption();
            }) : None$.MODULE$;
            r.setData(columnName, v2.orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()));
        });
    }

    private boolean isConvertible(DataType dt) {
        return dt != DataType.UNKNOWN;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (columnIndex == 0) {
            return BoxesRunTime.boxToInteger((int)(rowIndex + 1));
        }
        Record g = this.getRecord(rowIndex);
        String name = this.m_Schema.getColumnName(columnIndex - 1);
        return this.m_Schema.format(this.m_Schema.getColumnType(columnIndex - 1), g.getData(name).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl()));
    }

    public int addRecord(Record g) {
        int row = this.m_Records.size();
        this.m_Records.$plus$eq((Object)g);
        this.fireTableRowsInserted(row, row);
        return row;
    }

    public void moveUp(Record g) {
        int row = this.m_Records.indexOf((Object)g);
        if (row >= 1) {
            this.m_Records.remove(row);
            this.m_Records.insert(row - 1, (Object)g);
            this.fireTableRowsUpdated(row - 1, row);
            return;
        }
    }

    public void moveDown(Record g) {
        int row = this.m_Records.indexOf((Object)g);
        if (row >= 0 && row < this.m_Records.size() - 1) {
            this.m_Records.remove(row);
            this.m_Records.insert(row + 1, (Object)g);
            this.fireTableRowsUpdated(row, row + 1);
            return;
        }
    }

    public int removeRecord(Record g) {
        int row = this.m_Records.indexOf((Object)g);
        if (row >= 0) {
            this.m_Records.remove(row);
            this.fireTableRowsDeleted(row, row);
        }
        return row;
    }

    public void updateRecord(Record g) {
        int row = this.m_Records.indexOf((Object)g);
        if (row >= 0) {
            this.fireTableRowsUpdated(row, row);
            return;
        }
    }

    public Record getRecord(int idx) {
        return (Record)this.m_Records.apply(idx);
    }

    public void removeAll() {
        int lastRow = this.m_Records.size() - 1;
        if (lastRow >= 0) {
            this.m_Records.clear();
            this.fireTableRowsDeleted(0, lastRow);
            return;
        }
    }

    private final Object $anonfun$1$$anonfun$1(DataType newDT$3, String s$1) {
        return this.m_Schema.parse(newDT$3, s$1);
    }
}

