/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.wizard.datasource.tabular;

import com.elixirtech.data2.DataType;
import com.elixirtech.ensemble.I18N;
import com.elixirtech.wizard.IWizard;
import com.elixirtech.wizard.IWizardPage;
import com.elixirtech.wizard.PageId;
import com.elixirtech.wizard.datasource.ColumnDialog2;
import com.elixirtech.wizard.datasource.DSFirstPage;
import com.elixirtech.wizard.datasource.DataSchemaPanel2;
import com.elixirtech.wizard.datasource.IDataSourceWizard;
import com.elixirtech.wizard.datasource.SecurityPage$;
import com.elixirtech.wizard.datasource.tabular.TabularDSBuilder$;
import com.elixirtech.wizard.datasource.tabular.TabularPage$;
import com.elixirtech.wizard.datasource.tabular.TabularValuesPage;
import com.elixirtech.wizard.datasource.tabular.TabularValuesPage$;
import java.io.Serializable;
import javax.swing.JFrame;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.Some$;
import scala.runtime.BoxesRunTime;
import scala.runtime.function.JProcedure1;

public class TabularPage
extends DSFirstPage {
    private final IDataSourceWizard wizard;
    private final MyDataSchemaPanel m_Panel;

    public static String PageName() {
        return TabularPage$.MODULE$.PageName();
    }

    public static TabularPage apply(IDataSourceWizard iDataSourceWizard) {
        return TabularPage$.MODULE$.apply(iDataSourceWizard);
    }

    public TabularPage(IDataSourceWizard wizard) {
        this.wizard = wizard;
        super(wizard, TabularPage$.MODULE$.PageName(), (Option<PageId>)Some$.MODULE$.apply((Object)new PageId(TabularValuesPage$.MODULE$.PageName())));
        this.m_Panel = new MyDataSchemaPanel(wizard);
        I18N.ENSEMBLE_MAP.injectObject(null, this, "DS.TabularPage");
        this.m_Component().add(this.m_Panel);
        I18N.ENSEMBLE_MAP.injectComponents("DS.TabularPage.", this.m_Component());
        this.putRight(this.DS_NAME(), this.DS_ALIGN(), 10);
        this.putBelow("schema", this.DS_DESC(), 5);
        this.stickLeft("schema");
        this.stickRight("schema");
        this.stickBottom("schema");
    }

    @Override
    public void load() {
        super.load();
        TabularDSBuilder$.MODULE$.from(this.wizard).foreach((Function1)(JProcedure1 & Serializable)builder -> {
            this.nameField().setText(builder.getName());
            this.descriptionField().setText(builder.getDescription());
            this.m_Panel.setSchema(builder.getSchema());
            boolean writable = !this.wizard.isSecuredReadOnly();
            boolean visible = !this.wizard.isSecuredHideInternals();
            this.nameField().setEnabled(writable);
            this.descriptionField().setEnabled(writable);
            this.m_Panel.setSchemaFixed(!writable);
            this.m_Panel.setVisible(visible);
        });
    }

    @Override
    public void save() {
        super.save();
        TabularDSBuilder$.MODULE$.from(this.wizard).foreach((Function1)(JProcedure1 & Serializable)builder -> {
            builder.setName(this.nameField().getText().replaceAll("\t", " ").trim());
            builder.setDescription(this.descriptionField().getText());
            builder.setSchema(this.m_Panel.getSchema());
        });
    }

    @Override
    public boolean isPageComplete() {
        if (super.isPageComplete()) {
            int cols = BoxesRunTime.unboxToInt((Object)Option$.MODULE$.apply((Object)this.m_Panel.getSchema()).map((Function1 & Serializable)_$1 -> _$1.getColumnCount()).getOrElse(TabularPage::$anonfun$2));
            if (cols == 0) {
                this.setError((Option)Some$.MODULE$.apply((Object)I18N.ENSEMBLE.getString("DS.TabularPage.SCHEMA_REQUIRED")));
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean canFlipToNextPage() {
        if (this.isPageComplete()) {
            return super.canFlipToNextPage();
        }
        return false;
    }

    @Override
    public Option<IWizardPage> getNextPage() {
        if (this.wizard.isSecuredHideInternals()) {
            return this.wizard.getPage(SecurityPage$.MODULE$.PageName());
        }
        return super.getNextPage();
    }

    public void renameColumn(String oldName, String newName) {
        IWizardPage iWizardPage;
        Option<IWizardPage> option = this.wizard.getPage(TabularValuesPage$.MODULE$.PageName());
        if (option instanceof Some && (iWizardPage = (IWizardPage)((Some)option).value()) instanceof TabularValuesPage) {
            TabularValuesPage page = (TabularValuesPage)iWizardPage;
            page.renameColumn(oldName, newName);
            return;
        }
    }

    public void updateSchema(String columnName, DataType oldDT, DataType newDT) {
        IWizardPage iWizardPage;
        Option<IWizardPage> option = this.wizard.getPage(TabularValuesPage$.MODULE$.PageName());
        if (option instanceof Some && (iWizardPage = (IWizardPage)((Some)option).value()) instanceof TabularValuesPage) {
            TabularValuesPage page = (TabularValuesPage)iWizardPage;
            page.updateSchema(columnName, oldDT, newDT);
            return;
        }
    }

    private static final int $anonfun$2() {
        return 0;
    }

    public class MyDataSchemaPanel
    extends DataSchemaPanel2 {
        public MyDataSchemaPanel(IWizard wizard) {
            if (TabularPage.this == null) {
                throw new NullPointerException();
            }
            super(wizard);
        }

        @Override
        public DataSchemaPanel2.IColumnDialog newColumnDialog(JFrame f, String title, DataSchemaPanel2.SchemaColumn group) {
            return new TabularColumnDialog(f, title, group);
        }

        public final /* synthetic */ TabularPage com$elixirtech$wizard$datasource$tabular$TabularPage$MyDataSchemaPanel$$$outer() {
            return TabularPage.this;
        }
    }

    public class TabularColumnDialog
    extends ColumnDialog2<DataSchemaPanel2.SchemaColumn> {
        public TabularColumnDialog(JFrame f, String title, DataSchemaPanel2.SchemaColumn group) {
            if (TabularPage.this == null) {
                throw new NullPointerException();
            }
            super(f, title, group);
        }

        @Override
        public void setupConstraints() {
            I18N.ENSEMBLE_MAP.injectComponents("TabularColumnDialog.", this);
            super.setupConstraints();
        }

        @Override
        public void setVisible(boolean b) {
            String oldName = ((DataSchemaPanel2.SchemaColumn)this.m_Group()).name();
            DataType oldDT = ((DataSchemaPanel2.SchemaColumn)this.m_Group()).type();
            super.setVisible(b);
            String newName = ((DataSchemaPanel2.SchemaColumn)this.m_Group()).name();
            DataType newDT = ((DataSchemaPanel2.SchemaColumn)this.m_Group()).type();
            if (!oldName.equals(newName)) {
                TabularPage.this.renameColumn(oldName, newName);
            }
            DataType dataType = oldDT;
            DataType dataType2 = newDT;
            if (dataType == null ? dataType2 != null : !dataType.equals(dataType2)) {
                TabularPage.this.updateSchema(newName, oldDT, newDT);
                return;
            }
        }

        public final /* synthetic */ TabularPage com$elixirtech$wizard$datasource$tabular$TabularPage$TabularColumnDialog$$$outer() {
            return TabularPage.this;
        }
    }
}

