/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.wizard.datasource.tabular;

import com.elixirtech.arch.Elixir$;
import com.elixirtech.arch.ElixirFrame;
import com.elixirtech.arch.IErrorHandler;
import com.elixirtech.data2.DataSchema;
import com.elixirtech.data2.DataType;
import com.elixirtech.ensemble.I18N;
import com.elixirtech.jdom.Content;
import com.elixirtech.jdom.Document;
import com.elixirtech.jdom.Element;
import com.elixirtech.jdom.input.SAXBuilder;
import com.elixirtech.jdom.output.XMLOutputter;
import com.elixirtech.ui.ClipboardUtil;
import com.elixirtech.ui.OrderedEditableTable;
import com.elixirtech.ui.TableUtil;
import com.elixirtech.wizard.datasource.tabular.Record;
import com.elixirtech.wizard.datasource.tabular.RecordDialog;
import com.elixirtech.wizard.datasource.tabular.RecordModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Iterator;
import javax.swing.JPanel;
import javax.swing.table.TableColumn;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Vector;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.function.JProcedure1;
import scala.runtime.java8.JFunction1;

public class TabularPanel
extends JPanel
implements ActionListener {
    private boolean m_Editable;
    private final RecordModel m_RecordModel;
    private final OrderedEditableTable m_RecordTable;

    public TabularPanel() {
        this.setLayout(new BorderLayout());
        this.m_Editable = true;
        this.m_RecordModel = new RecordModel();
        this.m_RecordTable = new OrderedEditableTable(this.m_RecordModel(), true, true);
        this.m_RecordTable().setAutoResizeMode(2);
        this.m_RecordTable().addActionListener(this);
        this.add((Component)this.m_RecordTable(), "Center");
        this.updateButtons();
    }

    public boolean m_Editable() {
        return this.m_Editable;
    }

    public void m_Editable_$eq(boolean x$1) {
        this.m_Editable = x$1;
    }

    public RecordModel m_RecordModel() {
        return this.m_RecordModel;
    }

    public OrderedEditableTable m_RecordTable() {
        return this.m_RecordTable;
    }

    public void setEditable(boolean b) {
        this.m_Editable_$eq(b);
        this.updateButtons();
    }

    public void setSchemaAndRecords(DataSchema schema, Vector<Record> records) {
        this.m_RecordModel().setSchemaAndRecords(schema, records);
        this.updateButtons();
    }

    public void setSchema(DataSchema schema) {
        this.m_RecordModel().setSchema(schema);
        this.updateButtons();
    }

    public Vector<Record> getRecords() {
        return this.m_RecordModel().getRecords();
    }

    public void renameColumn(String oldName, String newName) {
        this.m_RecordModel().renameColumn(oldName, newName);
    }

    public void updateSchema(String columnName, DataType oldDT, DataType newDT) {
        this.m_RecordModel().updateSchema(columnName, oldDT, newDT);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String string = e.getActionCommand();
        switch (string == null ? 0 : string.hashCode()) {
            case 3739: {
                if (!"up".equals(string)) break;
                this.moveUp();
                return;
            }
            case 3059573: {
                if (!"copy".equals(string)) break;
                this.copy();
                return;
            }
            case 3089570: {
                if (!"down".equals(string)) break;
                this.moveDown();
                return;
            }
            case 3108362: {
                if (!"edit".equals(string)) break;
                this.editRecord();
                return;
            }
            case 3444122: {
                if (!"plus".equals(string)) break;
                this.addRecord();
                return;
            }
            case 103901296: {
                if (!"minus".equals(string)) break;
                this.removeRecord();
                return;
            }
            case 106438291: {
                if (!"paste".equals(string)) break;
                this.paste();
                return;
            }
        }
    }

    public void addRecord() {
        try {
            Record rec = new Record();
            String title = I18N.ENSEMBLE.getString("DS.TabularPanel.ADD_RECORD");
            RecordDialog dlg = this.newColumnDialog(title, rec);
            dlg.setVisible(true);
            if (dlg.isOk()) {
                int row = this.m_RecordModel().addRecord(rec);
                this.m_RecordTable().select(row);
                this.updateButtons();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void editRecord() {
        Record group = this.m_RecordModel().getRecord(this.m_RecordTable().getSelectedRow());
        String title = I18N.ENSEMBLE.getString("DS.TabularPanel.EDIT_RECORD");
        RecordDialog dlg = this.newColumnDialog(title, group);
        dlg.setVisible(true);
        if (dlg.isOk()) {
            this.m_RecordModel().updateRecord(group);
            return;
        }
    }

    public void removeRecord() {
        int[] rows = this.m_RecordTable().getSelectedRows();
        Object object = Predef$.MODULE$.intArrayOps(rows);
        Object[] recs = (Record[])ArrayOps$.MODULE$.map$extension(object, (Function1 & Serializable)i -> this.$anonfun$1(BoxesRunTime.unboxToInt((Object)i)), ClassTag$.MODULE$.apply(Record.class));
        Object object2 = Predef$.MODULE$.refArrayOps(recs);
        ArrayOps$.MODULE$.foreach$extension(object2, (Function1 & Serializable)g -> this.m_RecordModel().removeRecord((Record)g));
        Object object3 = Predef$.MODULE$.intArrayOps(rows);
        ArrayOps$.MODULE$.headOption$extension(object3).foreach((Function1)(JFunction1.mcVI.sp & Serializable)row -> {
            int count = this.m_RecordModel().getRowCount();
            if (count > 0 && row >= 0) {
                this.m_RecordTable().select(package$.MODULE$.min(row, count - 1));
                return;
            }
        });
        this.updateButtons();
    }

    public void copy() {
        Element root = new Element("records");
        int[] rows = this.m_RecordTable().getSelectedRows();
        Object object = Predef$.MODULE$.intArrayOps(rows);
        Object[] recs = (Record[])ArrayOps$.MODULE$.map$extension(object, (Function1 & Serializable)idx -> this.$anonfun$2(BoxesRunTime.unboxToInt((Object)idx)), ClassTag$.MODULE$.apply(Record.class));
        Object object2 = Predef$.MODULE$.refArrayOps(recs);
        Object object3 = Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.map$extension(object2, (Function1 & Serializable)_$1 -> _$1.getMap(), ClassTag$.MODULE$.apply(Map.class)));
        ArrayOps$.MODULE$.foreach$extension(object3, (Function1 & Serializable)recMap -> {
            Element e = new Element("record");
            recMap.foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    String key = (String)tuple2._1();
                    Object value = tuple2._2();
                    DataSchema schema = this.m_RecordModel().getSchema();
                    int idx = schema.getColumnIndex(key);
                    if (idx >= 0) {
                        Element field = new Element("field");
                        field.setAttribute("name", key);
                        field.setText(schema.format(schema.getColumnType(idx), value));
                        e.addContent((Content)field);
                        return;
                    }
                    return;
                }
                throw new MatchError((Object)tuple2);
            });
            return root.addContent((Content)e);
        });
        XMLOutputter out = new XMLOutputter();
        StringWriter sw = new StringWriter();
        try {
            out.output(new Document(root), (Writer)sw);
            ClipboardUtil.setText(sw.toString());
        }
        catch (IOException ex) {
            ((IErrorHandler)Elixir$.MODULE$.get(ClassTag$.MODULE$.apply(IErrorHandler.class))).error(I18N.ENSEMBLE.getString("DS.TabularPanel.UNABLE_TO_COPY"), (Throwable)ex);
        }
    }

    public void paste() {
        DataSchema schema = this.m_RecordModel().getSchema();
        String xml = ClipboardUtil.getText();
        SAXBuilder sb = new SAXBuilder();
        try {
            Document doc = sb.build((Reader)new StringReader(xml));
            Element root = doc.getRootElement();
            int firstRow = -1;
            int lastRow = -1;
            if ("records".equals(root.getName())) {
                Iterator recs = root.getChildren("record").iterator();
                while (recs.hasNext()) {
                    Record rec = new Record();
                    Element e = (Element)recs.next();
                    for (Element f : e.getChildren("field")) {
                        String key = f.getAttributeValue("name");
                        int idx = schema.getColumnIndex(key);
                        if (idx < 0) continue;
                        Object value = schema.parse(schema.getColumnType(idx), f.getText());
                        rec.setData(key, value);
                    }
                    lastRow = this.m_RecordModel().addRecord(rec);
                    if (firstRow >= 0) continue;
                    firstRow = lastRow;
                }
                this.m_RecordTable().select(firstRow, lastRow);
                this.updateButtons();
            }
        }
        catch (Exception ex) {}
    }

    public void moveUp() {
        int row = this.m_RecordTable().getSelectedRow();
        if (row > 0) {
            Record group = this.m_RecordModel().getRecord(row);
            this.m_RecordModel().moveUp(group);
            this.m_RecordTable().select(--row);
            this.updateButtons();
            return;
        }
    }

    public void moveDown() {
        int row = this.m_RecordTable().getSelectedRow();
        if (row < this.m_RecordModel().getRowCount() - 1) {
            Record group = this.m_RecordModel().getRecord(row);
            this.m_RecordModel().moveDown(group);
            this.m_RecordTable().select(++row);
            this.updateButtons();
            return;
        }
    }

    public RecordDialog newColumnDialog(String title, Record rec) {
        return new RecordDialog(((ElixirFrame)Elixir$.MODULE$.get(ClassTag$.MODULE$.apply(ElixirFrame.class))).getFrame(), title, this.m_RecordModel().getSchema(), rec);
    }

    public void updateButtons() {
        boolean hasCols = this.m_RecordModel().getSchema().getColumnCount() > 0;
        this.m_RecordTable().setEnabled(hasCols && this.m_Editable());
        TableColumn col = this.m_RecordTable().getTable().getColumnModel().getColumn(0);
        TableUtil.setColumnWidth(this.m_RecordTable().getTable(), col, I18N.ENSEMBLE, "Row", 10);
    }

    private final /* synthetic */ Record $anonfun$1(int i) {
        return this.m_RecordModel().getRecord(i);
    }

    private final /* synthetic */ Record $anonfun$2(int idx) {
        return this.m_RecordModel().getRecord(idx);
    }
}

