/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.wizard.datasource.text;

import com.elixirtech.data2.DataSchema;
import com.elixirtech.data2.datasource.text.TextDataDefinition;
import com.elixirtech.ui.SwingFactory;
import com.elixirtech.ui.SwingUtil;
import com.elixirtech.wizard.IWizardPage;
import com.elixirtech.wizard.PageId;
import com.elixirtech.wizard.RelativeLayoutWizardPage;
import com.elixirtech.wizard.datasource.DataSchemaPanel;
import com.elixirtech.wizard.datasource.IDataSourceWizard;
import com.elixirtech.wizard.datasource.WatchableDataSchemaPanel;
import com.elixirtech.wizard.datasource.text.TextDSBuilder;
import com.elixirtech.wizard.datasource.text.TextDSBuilder$;
import com.elixirtech.wizard.datasource.text.TextPage;
import com.elixirtech.wizard.datasource.text.TextPage$;
import java.io.Serializable;
import javax.swing.JLabel;
import scala.Function1;
import scala.Option;
import scala.Some;
import scala.runtime.function.JProcedure1;

public abstract class TextDefinitionPage
extends RelativeLayoutWizardPage {
    private final IDataSourceWizard wizard;
    private final DataSchemaPanel m_SchemaPanel;

    public TextDefinitionPage(IDataSourceWizard wizard, String name, Option<PageId> np) {
        this.wizard = wizard;
        super(wizard, name, np);
        this.m_SchemaPanel = this.newDataSchemaPanel();
        this.m_Component().add("schema-panel", this.m_SchemaPanel());
    }

    public DataSchemaPanel m_SchemaPanel() {
        return this.m_SchemaPanel;
    }

    public DataSchema getSchema(String dateFormat, String timeFormat, String timestampFormat) {
        return this.m_SchemaPanel().getSchema(dateFormat, timeFormat, timestampFormat);
    }

    public TextPage getTextPage() {
        IWizardPage iWizardPage;
        Option<IWizardPage> option = this.wizard.getPage(TextPage$.MODULE$.PageName());
        if (option instanceof Some && (iWizardPage = (IWizardPage)((Some)option).value()) instanceof TextPage) {
            TextPage tp = (TextPage)iWizardPage;
            return tp;
        }
        throw new RuntimeException("TextPage not found");
    }

    public abstract TextDataDefinition getTextDataDefinition();

    @Override
    public void load() {
        TextDSBuilder$.MODULE$.from(this.wizard).foreach((Function1)(JProcedure1 & Serializable)builder -> this.load((TextDSBuilder)builder));
    }

    @Override
    public void save() {
        TextDSBuilder$.MODULE$.from(this.wizard).foreach((Function1)(JProcedure1 & Serializable)builder -> this.save((TextDSBuilder)builder));
    }

    public void load(TextDSBuilder builder) {
        this.m_SchemaPanel().setSchema(builder.getSchema());
    }

    public void save(TextDSBuilder builder) {
        builder.setSchema(this.m_SchemaPanel().getSchema());
    }

    public void doFinish() {
        this.m_SchemaPanel().disposeEditor();
        TextDSBuilder$.MODULE$.from(this.wizard).foreach((Function1)(JProcedure1 & Serializable)builder -> {
            DataSchema schema = this.m_SchemaPanel().getSchema(this.wizard.getSchemaDateFormat(), this.wizard.getSchemaTimeFormat(), this.wizard.getSchemaTimestampFormat());
            builder.setSchema(schema);
        });
    }

    public void addLabel(String name) {
        String labelName = name + "-label";
        JLabel item = SwingFactory.newLabel(labelName);
        this.m_Component().add(item);
        this.m_Layout().stickLeft(labelName);
        this.m_Layout().vCenter(labelName, name);
    }

    public void checkEnabled() {
        boolean writable = !this.wizard.isSecuredReadOnly();
        SwingUtil.setEnabled(this.m_Component(), writable);
        this.m_SchemaPanel().setSchemaFixed(!writable);
    }

    public DataSchemaPanel newDataSchemaPanel() {
        return new WatchableDataSchemaPanel(this);
    }
}

