/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.wizard.datasource.text;

import com.elixirtech.arch.LoggingHelper2;
import com.elixirtech.arch.LoggingInterface;
import com.elixirtech.arch.StringUtil;
import com.elixirtech.data2.Encoding;
import com.elixirtech.data2.datasource.text.TextDataDefinition;
import com.elixirtech.data2.datasource.text.TextDataSource;
import com.elixirtech.ensemble.I18N;
import com.elixirtech.ensemble.ds.DSUtil2;
import com.elixirtech.i18n.I18NUtil;
import com.elixirtech.ui.FileLoadDialog;
import com.elixirtech.ui.SwingFactory;
import com.elixirtech.ui.SwingUtil;
import com.elixirtech.util.FileUtil;
import com.elixirtech.wizard.AL$;
import com.elixirtech.wizard.FieldWatcher;
import com.elixirtech.wizard.IWizardPage;
import com.elixirtech.wizard.PageId;
import com.elixirtech.wizard.datasource.DSFirstPage;
import com.elixirtech.wizard.datasource.IDataSourceWizard;
import com.elixirtech.wizard.datasource.SecurityPage$;
import com.elixirtech.wizard.datasource.text.AuthPanel;
import com.elixirtech.wizard.datasource.text.TextDSBuilder$;
import com.elixirtech.wizard.datasource.text.TextFixedWidthPage$;
import com.elixirtech.wizard.datasource.text.TextPage$;
import com.elixirtech.wizard.datasource.text.TextRegExpPage$;
import com.elixirtech.wizard.datasource.text.TextSeparatorPage$;
import java.awt.Component;
import java.io.File;
import java.io.Serializable;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Some$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.runtime.java8.JFunction0;
import sourcecode.FullName$;
import sourcecode.Line$;

public class TextPage
extends DSFirstPage
implements LoggingHelper2 {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(TextPage.class.getDeclaredField("log$lzy1"));
    private volatile Object log$lzy1;
    private final IDataSourceWizard wizard;
    private final FieldWatcher watcher;
    private final String[] NEXT;
    private final JTextField m_Filename;
    private final JButton m_Browse;
    private final AuthPanel m_AuthPanel;
    private final JComboBox<String> m_Encoding;
    private final JTextField m_DateFormat;
    private final JTextField m_TimeFormat;
    private final JTextField m_TimestampFormat;
    private final JCheckBox m_FirstLineHeader;
    private final JSpinner m_SkipLines;
    private final JComboBox<String> m_Format;
    private final List labels;
    private final List components;
    private final List details;

    public static String PageName() {
        return TextPage$.MODULE$.PageName();
    }

    public static TextPage apply(IDataSourceWizard iDataSourceWizard) {
        return TextPage$.MODULE$.apply(iDataSourceWizard);
    }

    public TextPage(IDataSourceWizard wizard) {
        this.wizard = wizard;
        super(wizard, TextPage$.MODULE$.PageName(), (Option<PageId>)None$.MODULE$);
        this.watcher = new FieldWatcher(wizard);
        String[] FORMATS = new String[]{"Text.SeparatorCharacter", "Text.FixedWidth", "Text.RegularExpression"};
        String[] FORMATS_UI = I18NUtil.getStrings(I18N.ENSEMBLE, FORMATS);
        this.NEXT = (PageId[])Array$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new PageId[]{new PageId(TextSeparatorPage$.MODULE$.PageName()), new PageId(TextFixedWidthPage$.MODULE$.PageName()), new PageId(TextRegExpPage$.MODULE$.PageName())}), ClassTag$.MODULE$.apply(PageId.class));
        this.m_Filename = SwingFactory.newTextField("filename");
        this.m_Browse = SwingFactory.newDotsButton("browse", AL$.MODULE$.apply((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.browse()));
        this.m_AuthPanel = new AuthPanel(this.watcher());
        this.m_Encoding = new JComboBox(Encoding.getAllNames());
        this.m_Encoding.setName("encoding");
        this.m_DateFormat = SwingFactory.newTextField("date-format");
        this.m_TimeFormat = SwingFactory.newTextField("time-format");
        this.m_TimestampFormat = SwingFactory.newTextField("timestamp-format");
        this.m_FirstLineHeader = SwingFactory.newCheckBox("first-line-header");
        this.m_SkipLines = new JSpinner(new SpinnerNumberModel(0, 0, 99, 1));
        this.m_Format = new JComboBox<String>(FORMATS_UI);
        this.m_Format.setName("format");
        I18N.ENSEMBLE_MAP.injectObject(null, this, "DS.TextPage");
        this.putRight(this.DS_NAME(), this.DS_ALIGN() + ",auth-label,encoding-label,format-label,date-format-label,skip-lines-label,time-format-label,timestamp-format-label", 10);
        this.m_Component().setLayout(this.m_Layout());
        this.m_Component().setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.labels = (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new JLabel[]{this.addLabel("filename"), this.addLabel("auth"), this.addLabel("encoding"), this.addLabel("format"), this.addLabel("date-format"), this.addLabel("time-format"), this.addLabel("timestamp-format"), this.addLabel("skip-lines")}));
        this.m_Filename.getDocument().addDocumentListener(this.watcher());
        new Encoding.ComboBoxListener(this.m_Encoding);
        this.m_Encoding.setEditable(true);
        this.m_SkipLines.setName("skip-lines");
        this.m_DateFormat.setText("yyyy-MM-dd");
        this.m_TimeFormat.setText("HH:mm:ss");
        this.m_TimestampFormat.setText("yyyy-MM-dd HH:mm:ss");
        this.components = (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new JComponent[]{this.m_Filename, this.m_Browse, this.m_AuthPanel, this.m_Encoding, this.m_FirstLineHeader, this.m_SkipLines, this.m_DateFormat, this.m_TimeFormat, this.m_TimestampFormat, this.m_Format}));
        JPanel jPanel = this.m_Component();
        this.components().foreach((Function1 & Serializable)x$0 -> jPanel.add((Component)x$0));
        this.details = (List)this.components().$plus$plus(this.labels());
        I18N.ENSEMBLE_MAP.injectComponents("DS.TextPage.", this.m_Component());
        this.alignBelow("filename", this.DS_DESC(), 5);
        this.vCenter("browse", "filename");
        this.setHeight("browse", "filename");
        this.stickRight("browse");
        this.putLeft("filename", "browse");
        this.alignBelow("auth", "filename");
        this.alignBelow("encoding", "auth");
        this.stickRight("encoding");
        this.alignBelow("skip-lines", "encoding");
        this.putRight("first-line-header", "skip-lines", 10);
        this.vCenter("first-line-header", "skip-lines");
        this.stickRight("first-line-header");
        this.alignBelow("date-format", "skip-lines");
        this.stickRight("date-format");
        this.alignBelow("time-format", "date-format");
        this.stickRight("time-format");
        this.alignBelow("timestamp-format", "time-format");
        this.stickRight("timestamp-format");
        this.alignBelow("format", "timestamp-format", 5);
    }

    public LoggingInterface log() {
        Object object = this.log$lzy1;
        if (object instanceof LoggingInterface) {
            return (LoggingInterface)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (LoggingInterface)this.log$lzyINIT1();
    }

    private Object log$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.log$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    LoggingInterface loggingInterface = null;
                    try {
                        loggingInterface = LoggingHelper2.log$((LoggingHelper2)this);
                        object2 = loggingInterface == null ? LazyVals.NullValue$.MODULE$ : loggingInterface;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.log$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return loggingInterface;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public FieldWatcher watcher() {
        return this.watcher;
    }

    public List<JLabel> labels() {
        return this.labels;
    }

    public List<Component> components() {
        return this.components;
    }

    public List<Component> details() {
        return this.details;
    }

    public void browse() {
        FileLoadDialog dlg = new FileLoadDialog();
        if (dlg.showOpenDialog(this.m_Component()) == 0) {
            File f = dlg.getSelectedFile();
            this.m_Filename.setText(FileUtil.asURL(f));
            return;
        }
    }

    @Override
    public boolean canFlipToNextPage() {
        return super.canFlipToNextPage() && this.isPageComplete();
    }

    @Override
    public boolean isPageComplete() {
        this.log().info(TextPage::isPageComplete$$anonfun$1, Line$.MODULE$.apply(124), FullName$.MODULE$.apply("com.elixirtech.wizard.datasource.text.TextPage.isPageComplete"));
        if (super.isPageComplete()) {
            if (this.m_Filename.getText().isEmpty()) {
                this.setError((Option)Some$.MODULE$.apply((Object)I18N.ENSEMBLE.getString("DS.TextPage.URL_REQUIRED")));
                return false;
            }
            if (!this.m_AuthPanel.getMode().equals("None")) {
                if (this.m_AuthPanel.getUser().isEmpty()) {
                    this.setError((Option)Some$.MODULE$.apply((Object)I18N.ENSEMBLE.getString("DS.TextPage.USER_REQUIRED")));
                    return false;
                }
                if (this.m_AuthPanel.getPassword().isEmpty()) {
                    this.setError((Option)Some$.MODULE$.apply((Object)I18N.ENSEMBLE.getString("DS.TextPage.PASSWORD_REQUIRED")));
                    return false;
                }
                return super.canFlipToNextPage();
            }
            return super.canFlipToNextPage();
        }
        return false;
    }

    public String getTextMode() {
        return ((PageId)((Object)this.NEXT[this.m_Format.getSelectedIndex()])).value();
    }

    @Override
    public Option<IWizardPage> getNextPage() {
        if (this.wizard.isSecuredHideInternals()) {
            return this.wizard.getPage(SecurityPage$.MODULE$.PageName());
        }
        return this.wizard.getPage(this.getTextMode());
    }

    public String getFilename() {
        return this.m_Filename.getText();
    }

    public String getAuthMode() {
        return this.m_AuthPanel.getMode();
    }

    public String getAuthUser() {
        return this.m_AuthPanel.getUser();
    }

    public String getAuthPassword() {
        return this.m_AuthPanel.getPassword();
    }

    public String getEncoding() {
        return String.valueOf(this.m_Encoding.getSelectedItem());
    }

    public String getDateFormat() {
        return this.m_DateFormat.getText();
    }

    public boolean isFirstLineHeader() {
        return this.m_FirstLineHeader.isSelected();
    }

    public int getSkipLines() {
        SpinnerModel spinnerModel = this.m_SkipLines.getModel();
        if (spinnerModel instanceof SpinnerNumberModel) {
            SpinnerNumberModel m = (SpinnerNumberModel)spinnerModel;
            return m.getNumber().intValue();
        }
        return 0;
    }

    public String getURL() {
        return this.m_Filename.getText();
    }

    @Override
    public boolean canFinish() {
        return TextDSBuilder$.MODULE$.from(this.wizard).exists((Function1 & Serializable)builder -> builder.getSchema().getColumnCount() > 0);
    }

    @Override
    public void load() {
        TextDSBuilder$.MODULE$.from(this.wizard).foreach((Function1)(JProcedure1 & Serializable)builder -> {
            TextDataSource.Spec spec = builder.getSpec();
            this.nameField().setText(spec.name());
            this.descriptionField().setText(spec.description());
            this.m_Filename.setText(spec.url());
            this.m_AuthPanel.setContent(spec.authMode(), spec.authUser(), spec.authPassword());
            String encString = spec.encoding();
            if (StringUtil.isEmpty((String)encString)) {
                encString = "UTF-8";
            }
            this.m_Encoding.setSelectedItem(encString);
            this.m_DateFormat.setText(builder.getSchema().getDateFormat());
            this.m_TimeFormat.setText(builder.getSchema().getTimeFormat());
            this.m_TimestampFormat.setText(builder.getSchema().getTimestampFormat());
            this.m_FirstLineHeader.setSelected(spec.firstLineHeader());
            ((SpinnerNumberModel)this.m_SkipLines.getModel()).setValue(BoxesRunTime.boxToInteger((int)spec.skipLines()));
            TextDataDefinition ddef = spec.dataDef();
            String name = ddef.name();
            String string = ((PageId)((Object)this.NEXT[0])).value();
            String string2 = name;
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                this.m_Format.setSelectedIndex(0);
            } else {
                String string3 = ((PageId)((Object)this.NEXT[1])).value();
                String string4 = name;
                if (!(string3 != null ? !string3.equals(string4) : string4 != null)) {
                    this.m_Format.setSelectedIndex(1);
                } else {
                    this.m_Format.setSelectedIndex(2);
                }
            }
            boolean writable = !this.wizard.isSecuredReadOnly();
            boolean visible = !this.wizard.isSecuredHideInternals();
            SwingUtil.setEnabled(this.m_Component(), writable);
            this.details().foreach((Function1)(JProcedure1 & Serializable)_$1 -> _$1.setVisible(visible));
            this.m_Browse.setEnabled(writable && !DSUtil2.isRemote());
        });
    }

    @Override
    public void save() {
        TextDSBuilder$.MODULE$.from(this.wizard).foreach((Function1)(JProcedure1 & Serializable)builder -> {
            TextDataSource.Spec newSpec = TextDataSource.Spec$.MODULE$.apply(this.nameField().getText().replaceAll("\t", " ").trim(), this.descriptionField().getText(), this.m_Filename.getText(), this.m_AuthPanel.getMode(), this.m_AuthPanel.getUser(), this.m_AuthPanel.getPassword(), (String)this.m_Encoding.getSelectedItem(), BoxesRunTime.unboxToInt((Object)this.m_SkipLines.getModel().getValue()), this.m_FirstLineHeader.isSelected(), builder.getSpec().dataDef());
            builder.setSpec(newSpec);
        });
    }

    public JLabel addLabel(String name) {
        String labelName = name + "-label";
        JLabel item = SwingFactory.newLabel(labelName);
        this.m_Component().add(item);
        this.stickLeft(labelName);
        this.vCenter(labelName, name);
        return item;
    }

    private static final Object isPageComplete$$anonfun$1() {
        return "isPageComplete called";
    }
}

