/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.wizard.datasource.xml;

import com.elixirtech.data2.DataRecord;
import com.elixirtech.data2.DataTable;
import com.elixirtech.data2.datasource.xml.Merge;
import com.elixirtech.wizard.datasource.xml.RecordDesigner;
import java.util.ArrayList;
import java.util.List;
import javax.swing.table.AbstractTableModel;

public class RecordDesignerTableModel
extends AbstractTableModel {
    private RecordDesigner m_RecordDesigner;
    private DataRecord[] m_Recs = new DataRecord[0];
    private List<Column> m_Columns = new ArrayList<Column>();

    public RecordDesignerTableModel(RecordDesigner recordDesigner) {
        this.m_RecordDesigner = recordDesigner;
        Column column = new Column();
        column.fieldName = this.m_RecordDesigner.getI18NString("Field_1");
        column.relativeXPath = ".";
        this.m_Columns.add(column);
        column = new Column();
        this.m_Columns.add(column);
    }

    public String[] getRelativeXPaths() {
        String[] stringArray = new String[this.m_Columns.size()];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = this.m_Columns.get((int)i).relativeXPath;
        }
        return stringArray;
    }

    public Merge[] getMerges() {
        Merge[] mergeArray = new Merge[this.m_Columns.size()];
        for (int i = 0; i < mergeArray.length; ++i) {
            mergeArray[i] = this.m_Columns.get((int)i).merge;
        }
        return mergeArray;
    }

    public void setRows(DataTable dataTable) {
        this.fireTableRowsDeleted(3, this.m_Recs.length + 3);
        this.m_Recs = dataTable.getRecords();
        this.fireTableRowsInserted(3, this.m_Recs.length + 3);
    }

    public void rowsUpdated() {
        this.fireTableDataChanged();
    }

    @Override
    public int getRowCount() {
        return 3 + this.m_Recs.length;
    }

    @Override
    public int getColumnCount() {
        return this.m_Columns.size();
    }

    @Override
    public Class<?> getColumnClass(int n) {
        return String.class;
    }

    @Override
    public String getColumnName(int n) {
        if (n == this.m_Columns.size() - 1) {
            return this.m_RecordDesigner.getI18NString("<New>");
        }
        return Integer.toString(n + 1);
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return n < 3;
    }

    @Override
    public Object getValueAt(int n, int n2) {
        if (n2 >= this.m_Columns.size()) {
            return "";
        }
        if (n == 0) {
            Column column = this.m_Columns.get(n2);
            return column.fieldName;
        }
        if (n == 1) {
            Column column = this.m_Columns.get(n2);
            return column.relativeXPath;
        }
        if (n == 2) {
            Column column = this.m_Columns.get(n2);
            return column.merge;
        }
        int n3 = n - 3;
        Object[] objectArray = this.m_Recs[n3].getData();
        if (n2 < objectArray.length) {
            return objectArray[n2];
        }
        return "";
    }

    public void setStandardValueAt(Object object, int n, int n2) {
        Column column;
        try {
            column = this.m_Columns.get(n2);
        }
        catch (Exception exception) {
            column = new Column();
            this.m_Columns.add(column);
            this.m_RecordDesigner.addColumn();
        }
        switch (n) {
            case 0: {
                column.fieldName = object.toString();
                break;
            }
            case 1: {
                column.relativeXPath = object.toString();
                break;
            }
            case 2: {
                column.merge = (Merge)object;
                break;
            }
        }
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        Column column = this.m_Columns.get(n2);
        switch (n) {
            case 0: {
                column.fieldName = object.toString();
                break;
            }
            case 1: {
                column.relativeXPath = object.toString();
                break;
            }
            case 2: {
                column.merge = (Merge)object;
                break;
            }
        }
        if (n2 == this.m_Columns.size() - 1) {
            this.m_Columns.add(new Column());
            this.m_RecordDesigner.addColumn();
        }
        this.m_RecordDesigner.refreshTable();
    }

    public void deleteColumn(int n) {
        this.m_Columns.remove(n);
        this.m_RecordDesigner.removeColumn(n);
        this.m_RecordDesigner.refreshTable();
    }

    private class Column {
        public String fieldName = "";
        public String relativeXPath = "";
        public Merge merge = Merge.SPACE;

        private Column() {
        }
    }
}

