/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.wizard.datasource.xml;

import com.elixirtech.arch.Elixir$;
import com.elixirtech.arch.ElixirFrame;
import com.elixirtech.arch.IErrorHandler;
import com.elixirtech.arch.ManagedDialog;
import com.elixirtech.arch.StringUtil;
import com.elixirtech.arch.util.URLLoader$;
import com.elixirtech.arch.util.URLUtil;
import com.elixirtech.data2.ArgumentMap;
import com.elixirtech.data2.DataSchema;
import com.elixirtech.data2.ParameterUtil;
import com.elixirtech.data2.datasource.xml.XMLDataSchema;
import com.elixirtech.data2.datasource.xml.XMLDataSource;
import com.elixirtech.ensemble.I18N;
import com.elixirtech.ensemble.wizard.ParameterUI;
import com.elixirtech.icons.DatasourceIcons;
import com.elixirtech.ui.SwingFactory;
import com.elixirtech.ui.SwingUtil;
import com.elixirtech.wizard.AL$;
import com.elixirtech.wizard.IWizardPage;
import com.elixirtech.wizard.PageId;
import com.elixirtech.wizard.RelativeLayoutWizardPage;
import com.elixirtech.wizard.datasource.BasicSecurityPage$;
import com.elixirtech.wizard.datasource.IDataSourceWizard;
import com.elixirtech.wizard.datasource.xml.RecordDesigner;
import com.elixirtech.wizard.datasource.xml.XMLDSBuilder$;
import com.elixirtech.wizard.datasource.xml.XMLPage;
import com.elixirtech.wizard.datasource.xml.XMLPage$;
import com.elixirtech.wizard.datasource.xml.XMLSchemaPage$;
import com.elixirtech.wizard.datasource.xml.XMLSchemaPanel;
import java.awt.Component;
import java.awt.FlowLayout;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.Serializable;
import java.io.StringReader;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.xml.sax.InputSource;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.collection.immutable.List;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.function.JProcedure1;
import scala.runtime.java8.JFunction0;

public class XMLSchemaPage
extends RelativeLayoutWizardPage {
    private final IDataSourceWizard wizard;
    private final JButton m_XPathBuilder;
    private final JTextField m_RootXPath;
    private final XMLSchemaPanel m_SchemaPanel;
    private boolean m_Initialized;

    public static String PageName() {
        return XMLSchemaPage$.MODULE$.PageName();
    }

    public static XMLSchemaPage apply(IDataSourceWizard iDataSourceWizard) {
        return XMLSchemaPage$.MODULE$.apply(iDataSourceWizard);
    }

    public XMLSchemaPage(IDataSourceWizard wizard) {
        this.wizard = wizard;
        super(wizard, XMLSchemaPage$.MODULE$.PageName(), (Option<PageId>)Some$.MODULE$.apply((Object)new PageId(BasicSecurityPage$.MODULE$.PageName())));
        I18N.ENSEMBLE_MAP.injectObject(null, this, "DS.XMLSchemaPage");
        this.setIcon(DatasourceIcons.DATASOURCE_IMAGE);
        this.m_XPathBuilder = SwingFactory.newButton("builder");
        this.m_RootXPath = this.addLabelledField("root");
        this.m_SchemaPanel = new XMLSchemaPanel(this);
        this.m_Initialized = false;
        this.m_Component().add(this.m_XPathBuilder());
        this.m_XPathBuilder().addActionListener(AL$.MODULE$.apply((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.showBuilder()));
        this.stickTop("builder");
        this.hCenter("builder");
        this.putBelow("root", "builder", 10);
        this.putRight("root", "root-label", 10);
        this.m_Component().add(this.m_SchemaPanel());
        I18N.ENSEMBLE_MAP.injectComponents("DS.XMLSchemaPage.", this.m_Component());
        this.putBelow("schema", "root", 10);
        this.stickLeft("schema");
        this.stickRight("schema");
        this.stickBottom("schema");
    }

    public JButton m_XPathBuilder() {
        return this.m_XPathBuilder;
    }

    public JTextField m_RootXPath() {
        return this.m_RootXPath;
    }

    public XMLSchemaPanel m_SchemaPanel() {
        return this.m_SchemaPanel;
    }

    public boolean m_Initialized() {
        return this.m_Initialized;
    }

    public void m_Initialized_$eq(boolean x$1) {
        this.m_Initialized = x$1;
    }

    public void updateButtons() {
        this.wizard.container().updateButtons();
    }

    @Override
    public void load() {
        if (!this.m_Initialized()) {
            XMLDataSource ds = (XMLDataSource)this.wizard.getDataSource();
            this.setXMLSchema(ds.getXMLSchema());
            this.m_Initialized_$eq(true);
        }
        this.checkEnabled();
    }

    @Override
    public void save() {
        XMLDSBuilder$.MODULE$.from(this.wizard).foreach((Function1)(JProcedure1 & Serializable)builder -> {
            builder.setRootXPath(this.m_RootXPath().getText());
            DataSchema schema = this.m_SchemaPanel().getSchema(this.wizard.getSchemaDateFormat(), this.wizard.getSchemaTimeFormat(), this.wizard.getSchemaTimestampFormat());
            builder.setSchema(schema);
            int count = schema.getColumnCount();
            List cols = RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), count).map((Function1 & Serializable)i -> this.$anonfun$1(BoxesRunTime.unboxToInt((Object)i))).toList();
            builder.setColumns((List<XMLDataSource.Column>)cols);
        });
        this.m_SchemaPanel().disposeEditor();
    }

    public void checkEnabled() {
        boolean writable = !this.wizard.isSecuredReadOnly();
        SwingUtil.setEnabled(this.m_Component(), writable);
        this.m_SchemaPanel().setSchemaFixed(!writable);
    }

    @Override
    public boolean canFlipToNextPage() {
        return this.isPageComplete() && super.canFlipToNextPage();
    }

    @Override
    public boolean isPageComplete() {
        this.setError((Option)None$.MODULE$);
        int count = BoxesRunTime.unboxToInt((Object)Option$.MODULE$.apply((Object)this.m_SchemaPanel().getSchema()).map((Function1 & Serializable)_$1 -> _$1.getColumnCount()).getOrElse(XMLSchemaPage::$anonfun$3));
        if (count == 0) {
            this.setError((Option)Some$.MODULE$.apply((Object)I18N.ENSEMBLE.getString("DS.XMLSchemaPage.SCHEMA_REQUIRED")));
            return false;
        }
        return true;
    }

    public void showBuilder() {
        ElixirFrame f = (ElixirFrame)Elixir$.MODULE$.get(ElixirFrame.class);
        Option<IWizardPage> option = this.wizard.getPage(XMLPage$.MODULE$.PageName());
        if (!(option instanceof Some)) {
            if (None$.MODULE$.equals(option)) {
                throw new Exception();
            }
            throw new MatchError(option);
        }
        IWizardPage page = (IWizardPage)((Some)option).value();
        XMLPage page2 = (XMLPage)page;
        InputSource is = new InputSource();
        try {
            String xml = page2.getXML();
            if (StringUtil.notEmpty((String)xml)) {
                ArgumentMap map = new ArgumentMap();
                map.extractParameters(xml);
                if (ParameterUtil.getParamCount((java.util.List)map.getParameters()) > 0) {
                    ParameterUI ui = new ParameterUI(map.getParameters(), null);
                    f.showWizard(ui);
                    if (!ui.isFinished()) {
                        return;
                    }
                    xml = ui.substitute(xml);
                }
                is = new InputSource(new StringReader(xml));
            } else {
                String url = page2.getURL();
                ArgumentMap map = new ArgumentMap();
                map.extractParameters(url);
                if (ParameterUtil.getParamCount((java.util.List)map.getParameters()) > 0) {
                    ParameterUI ui = new ParameterUI(map.getParameters(), null);
                    f.showWizard(ui);
                    if (!ui.isFinished()) {
                        return;
                    }
                    url = ui.substitute(url);
                }
                is = this.load(url);
            }
            XMLDataSchema xds = this.m_SchemaPanel().getXMLSchema(this.m_RootXPath().getText());
            new RecordDesignerDialog(f, xds, is, page2.getReadMode());
        }
        catch (IOException ex) {
            ((IErrorHandler)Elixir$.MODULE$.get(ClassTag$.MODULE$.apply(IErrorHandler.class))).error(I18N.ENSEMBLE.getString("DS.XMLSchemaPage.CANT_READ_XML") + ex, (Throwable)ex);
        }
    }

    public InputSource load(String locate) {
        InputSource is = new InputSource();
        is = URLUtil.isURL((String)locate) ? new InputSource(URLLoader$.MODULE$.getInputStream(locate)) : new InputSource(new FileInputStream(locate));
        is.setSystemId(locate);
        return is;
    }

    public void setXMLSchema(XMLDataSchema xmlSchema) {
        this.m_RootXPath().setText(xmlSchema.getRootXPath());
        this.m_SchemaPanel().setXMLSchema(xmlSchema);
    }

    private final /* synthetic */ XMLDataSource.Column $anonfun$1(int i) {
        return new XMLDataSource.Column(this.m_SchemaPanel().getXPath(i), this.m_SchemaPanel().getMerge(i));
    }

    private static final int $anonfun$3() {
        return 0;
    }

    public class RecordDesignerDialog
    extends ManagedDialog {
        private RecordDesigner m_RecordDesigner;
        private final JPanel south;
        private final JButton okButton;
        private final JButton cancelButton;

        public RecordDesignerDialog(ElixirFrame f, XMLDataSchema xds, InputSource is, String readMode) {
            if (XMLSchemaPage.this == null) {
                throw new NullPointerException();
            }
            super("XPathBuilder", f.getFrame(), I18N.ENSEMBLE.getString("RecordDesigner.TITLE"), true);
            this.m_RecordDesigner = new RecordDesigner(xds, is, readMode);
            this.south = new JPanel(new FlowLayout(2));
            this.okButton = SwingFactory.newOkButton(AL$.MODULE$.apply((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.ok()));
            this.cancelButton = SwingFactory.newCancelButton(AL$.MODULE$.apply((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.cancel()));
            this.setDefaultCloseOperation(2);
            this.setSize(600, 400);
            this.setLocationRelativeTo(f.getFrame());
            this.getContentPane().add((Component)this.m_RecordDesigner(), "Center");
            this.south().add(this.okButton());
            this.south().add(this.cancelButton());
            this.getContentPane().add((Component)this.south(), "South");
            I18N.ENSEMBLE_MAP.injectComponents("RecordDesigner.", this);
            f.showModal(this);
        }

        public RecordDesigner m_RecordDesigner() {
            return this.m_RecordDesigner;
        }

        public void m_RecordDesigner_$eq(RecordDesigner x$1) {
            this.m_RecordDesigner = x$1;
        }

        public JPanel south() {
            return this.south;
        }

        public JButton okButton() {
            return this.okButton;
        }

        public JButton cancelButton() {
            return this.cancelButton;
        }

        public void ok() {
            this.m_RecordDesigner().disposeEditor();
            XMLSchemaPage.this.setXMLSchema(this.m_RecordDesigner().getXMLDataSchema());
            this.m_RecordDesigner().saveSplitters();
            XMLSchemaPage.this.updateButtons();
            this.dispose();
        }

        @Override
        public void cancel() {
            this.m_RecordDesigner().saveSplitters();
            super.cancel();
        }

        public final /* synthetic */ XMLSchemaPage com$elixirtech$wizard$datasource$xml$XMLSchemaPage$RecordDesignerDialog$$$outer() {
            return XMLSchemaPage.this;
        }
    }
}

