/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.wizard.datasource.xml;

import com.elixirtech.data2.datasource.xml.Merge;
import com.elixirtech.data2.datasource.xml.XMLDataSchema;
import com.elixirtech.ensemble.I18N;
import com.elixirtech.ui.SwingFactory;
import com.elixirtech.wizard.datasource.ColumnDialog;
import com.elixirtech.wizard.datasource.DataSchemaPanel;
import com.elixirtech.wizard.datasource.xml.MergeLCR;
import com.elixirtech.wizard.datasource.xml.XMLSchemaPage;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class XMLSchemaPanel
extends DataSchemaPanel {
    final XMLSchemaPage m_Page;
    private static final String[] COLUMNS = new String[]{"TableModel.Column", "TableModel.Name", "TableModel.Type", "TableModel.XPath", "TableModel.Merge"};

    public XMLSchemaPanel(XMLSchemaPage xMLSchemaPage) {
        this.m_Page = xMLSchemaPage;
        this.setName("schema");
    }

    @Override
    public DataSchemaPanel.SchemaColumn newColumn() {
        return new XMLSchemaColumn();
    }

    public void setXMLSchema(XMLDataSchema xMLDataSchema) {
        this.m_ColumnModel.removeAll();
        int n = xMLDataSchema.getColumnCount();
        for (int i = 0; i < n; ++i) {
            XMLSchemaColumn xMLSchemaColumn = (XMLSchemaColumn)this.newColumn();
            XMLDataSchema.Column column = xMLDataSchema.getColumn(i);
            xMLSchemaColumn.name = column.name;
            xMLSchemaColumn.type = column.type;
            xMLSchemaColumn.xpath = column.xpath;
            xMLSchemaColumn.merge = column.merge;
            this.m_ColumnModel.addColumn(xMLSchemaColumn);
        }
    }

    public XMLDataSchema getXMLSchema(String string) {
        int n = this.m_ColumnModel.getRowCount();
        XMLDataSchema xMLDataSchema = new XMLDataSchema(n);
        xMLDataSchema.setRootXPath(string);
        for (int i = 0; i < n; ++i) {
            XMLDataSchema.Column column = xMLDataSchema.getColumn(i);
            column.name = this.m_ColumnModel.getColumn((int)i).name;
            column.type = this.m_ColumnModel.getColumn((int)i).type;
            column.xpath = this.getXPath(i);
            column.merge = this.getMerge(i);
        }
        return xMLDataSchema;
    }

    @Override
    protected void schemaChanged() {
        this.m_Page.updateButtons();
    }

    public String getXPath(int n) {
        return ((XMLSchemaColumn)this.m_ColumnModel.getColumn((int)n)).xpath;
    }

    public void setXPath(int n, String string) {
        ((XMLSchemaColumn)this.m_ColumnModel.getColumn((int)n)).xpath = string;
    }

    public Merge getMerge(int n) {
        return ((XMLSchemaColumn)this.m_ColumnModel.getColumn((int)n)).merge;
    }

    public void setMerge(int n, Merge merge) {
        ((XMLSchemaColumn)this.m_ColumnModel.getColumn((int)n)).merge = merge;
    }

    @Override
    public DataSchemaPanel.IColumnDialog newColumnDialog(JFrame jFrame, String string, DataSchemaPanel.SchemaColumn schemaColumn) {
        return new XMLColumnDialog(jFrame, string, (XMLSchemaColumn)schemaColumn);
    }

    @Override
    protected String[] getColumnNames() {
        return COLUMNS;
    }

    public static class XMLSchemaColumn
    extends DataSchemaPanel.SchemaColumn {
        public String xpath = "";
        public Merge merge = Merge.SPACE;

        @Override
        public Object getData(int n) {
            if (n == 3) {
                return this.xpath;
            }
            if (n == 4) {
                return this.merge;
            }
            return super.getData(n);
        }
    }

    public static class XMLColumnDialog
    extends ColumnDialog<XMLSchemaColumn> {
        private JTextField m_XPath;
        private JComboBox m_Merge;

        public XMLColumnDialog(JFrame jFrame, String string, XMLSchemaColumn xMLSchemaColumn) {
            super(jFrame, string, xMLSchemaColumn);
        }

        @Override
        protected JPanel buildUI() {
            JPanel jPanel = super.buildUI();
            jPanel.add(SwingFactory.newLabel("xpath-label"));
            this.m_XPath = SwingFactory.newTextField("xpath");
            jPanel.add(this.m_XPath);
            jPanel.add(SwingFactory.newLabel("merge-label"));
            this.m_Merge = SwingFactory.newComboBox("merge", Merge.ARRAY);
            this.m_Merge.setRenderer(new MergeLCR());
            jPanel.add(this.m_Merge);
            XMLSchemaColumn xMLSchemaColumn = (XMLSchemaColumn)this.m_Group;
            this.m_XPath.setText(xMLSchemaColumn.xpath);
            this.m_Merge.setSelectedItem(xMLSchemaColumn.merge);
            return jPanel;
        }

        @Override
        protected void setupConstraints() {
            I18N.ENSEMBLE_MAP.injectComponents("XMLColumnDialog.", this);
            this.m_Layout.stickLeft("name-label");
            this.m_Layout.vCenter("name-label", "name");
            this.m_Layout.stickLeft("data-type-label");
            this.m_Layout.vCenter("data-type-label", "data-type");
            this.m_Layout.stickLeft("xpath-label");
            this.m_Layout.vCenter("xpath-label", "xpath");
            this.m_Layout.stickLeft("merge-label");
            this.m_Layout.vCenter("merge-label", "merge");
            this.m_Layout.putRight("name", "name-label,data-type-label,xpath-label,merge-label", 10);
            this.m_Layout.stickRight("name");
            this.m_Layout.stickTop("name");
            this.m_Layout.alignBelow("data-type", "name", 5);
            this.m_Layout.stickRight("data-type");
            this.m_Layout.alignBelow("data-attrs", "data-type", 5);
            this.m_Layout.stickLeft("data-attrs-label");
            this.m_Layout.putBelow("data-attrs-label", "data-type", 5);
            this.m_Layout.alignBelow("xpath", "data-attrs", 5);
            this.m_Layout.stickRight("xpath");
            this.m_Layout.alignBelow("merge", "xpath", 5);
            this.m_Layout.stickRight("merge");
        }

        @Override
        public void ok() {
            ((XMLSchemaColumn)this.m_Group).xpath = this.m_XPath.getText();
            ((XMLSchemaColumn)this.m_Group).merge = (Merge)this.m_Merge.getSelectedItem();
            super.ok();
        }
    }
}

