/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.wizard.datasource.xml.recorddesigner;

import com.elixirtech.arch.Elixir$;
import com.elixirtech.arch.IErrorHandler;
import com.elixirtech.i18n.Bundle;
import com.elixirtech.jaxen.NamespaceContext;
import com.elixirtech.jaxen.dom.DOMXPath;
import com.elixirtech.wizard.datasource.xml.RecordDesigner;
import com.elixirtech.wizard.datasource.xml.XPathGenerator;
import com.elixirtech.wizard.datasource.xml.recorddesigner.DesignerNamespaceContext;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.io.Serializable;
import org.w3c.dom.Node;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Some;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.List;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;

public class DropOverTable
implements DropTargetListener {
    private final RecordDesigner rd;
    private final DataFlavor TREE_NODE_FLAVOUR;

    public DropOverTable(RecordDesigner rd) {
        this.rd = rd;
        this.TREE_NODE_FLAVOUR = new DataFlavor("application/x-elixir-xmldatasource-tree-node", null);
    }

    @Override
    public void dragEnter(DropTargetDragEvent ev) {
    }

    @Override
    public void dragExit(DropTargetEvent ev) {
    }

    @Override
    public void dragOver(DropTargetDragEvent ev) {
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent ev) {
    }

    @Override
    public void drop(DropTargetDropEvent ev) {
        try {
            Transferable t = ev.getTransferable();
            if (t.isDataFlavorSupported(this.TREE_NODE_FLAVOUR())) {
                ev.acceptDrop(1);
                Node node = (Node)t.getTransferData(this.TREE_NODE_FLAVOUR());
                Point pt = ev.getLocation();
                int col = this.rd.m_Table().columnAtPoint(pt);
                if (col >= 0) {
                    String pathValue = this.getPathValue(node);
                    String name = node.getLocalName();
                    if (name == null) {
                        String shortName = name = node.getNodeName();
                        int idx = name.indexOf(":");
                        if (idx >= 0) {
                            shortName = name.substring(idx + 1);
                        }
                        this.rd.m_TableModel().setValueAt(shortName, 0, col);
                        this.rd.m_TableModel().setValueAt(pathValue, 1, col);
                    } else {
                        this.rd.m_TableModel().setValueAt(name, 0, col);
                        this.rd.m_TableModel().setValueAt(pathValue, 1, col);
                    }
                    this.rd.m_Table().repaint();
                }
            }
            ev.dropComplete(true);
            return;
        }
        catch (Exception ex) {
            ((IErrorHandler)Elixir$.MODULE$.get(ClassTag$.MODULE$.apply(IErrorHandler.class))).error(Bundle.ARCH.getString("Error"), (Throwable)ex);
            ev.rejectDrop();
            ev.dropComplete(false);
            return;
        }
    }

    private String getPathValue(Node node) {
        Object object;
        block4: {
            try {
                String rootPath = this.rd.m_RootXPath().getText();
                DOMXPath rootXPath = new DOMXPath(rootPath);
                DesignerNamespaceContext namespaceContext = new DesignerNamespaceContext(this.rd.m_Document().getDocumentElement());
                rootXPath.setNamespaceContext((NamespaceContext)namespaceContext);
                List nodes = ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(rootXPath.selectNodes((Object)this.rd.m_Document())).asScala().collect((PartialFunction)new Serializable(){

                    public final boolean isDefinedAt(Object x) {
                        Object object = x;
                        if (object instanceof Node) {
                            Node n = (Node)object;
                            return true;
                        }
                        return false;
                    }

                    public final Object applyOrElse(Object x, Function1 function1) {
                        Object object = x;
                        if (object instanceof Node) {
                            Node n = (Node)object;
                            return n;
                        }
                        return function1.apply(x);
                    }
                })).toList();
                Option option = nodes.map((Function1 & Serializable)n -> Option$.MODULE$.apply((Object)XPathGenerator.getXPath((Node)n, node))).find((Function1 & Serializable)_$1 -> _$1.isDefined()).flatten((.less.colon.less)$less$colon$less$.MODULE$.refl());
                if (option instanceof Some) {
                    String pathV = (String)((Some)option).value();
                    object = pathV;
                    break block4;
                }
                if (None$.MODULE$.equals(option)) {
                    object = "/" + XPathGenerator.getXPath(this.rd.m_Document(), node);
                    break block4;
                }
                throw new MatchError((Object)option);
            }
            catch (Exception ex) {
                this.rd.m_Log().error((Object)"Invalid Root XPath, using document as the root");
                object = "/" + XPathGenerator.getXPath(this.rd.m_Document(), node);
            }
        }
        return object;
    }

    public DataFlavor TREE_NODE_FLAVOUR() {
        return this.TREE_NODE_FLAVOUR;
    }
}

