/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.wizard.datasource.xml.recorddesigner;

import com.elixirtech.arch.StringUtil;
import com.elixirtech.jaxen.JaxenException;
import com.elixirtech.jaxen.NamespaceContext;
import com.elixirtech.jaxen.dom.DOMXPath;
import com.elixirtech.wizard.datasource.xml.RecordDesigner;
import com.elixirtech.wizard.datasource.xml.recorddesigner.DesignerNamespaceContext;
import java.io.Serializable;
import java.util.ArrayList;
import javax.swing.JTree;
import javax.swing.tree.TreePath;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.function.JProcedure1;
import scala.runtime.java8.JFunction1;

public class SearchExpandTree
implements Runnable {
    private final JTree m_Tree;
    private final RecordDesigner rd;
    private List<TreePath> m_CurrentPaths;
    private String m_Expr;

    public SearchExpandTree(JTree m_Tree, RecordDesigner rd) {
        this.m_Tree = m_Tree;
        this.rd = rd;
        this.m_CurrentPaths = package$.MODULE$.Nil();
        this.m_Expr = "";
    }

    @Override
    public void run() {
        if (this.m_CurrentPaths.nonEmpty()) {
            this.collapse(this.m_Tree, this.m_CurrentPaths);
        }
        Node rootNode = (Node)this.m_Tree.getModel().getRoot();
        List<Node> nodes = this.findElement(rootNode, this.m_Expr);
        this.expand(this.m_Tree, nodes);
    }

    public void setSearchExpression(String expr) {
        this.m_Expr = expr;
    }

    public String getSearchExpression() {
        return this.m_Expr;
    }

    public Option<TreePath> getPrevious(Option<TreePath> tp) {
        Option<TreePath> option = tp;
        if (None$.MODULE$.equals(option)) {
            return this.m_CurrentPaths.headOption();
        }
        if (option instanceof Some) {
            TreePath path = (TreePath)((Some)option).value();
            List<TreePath> list = this.m_CurrentPaths;
            int index = list.lastIndexOf((Object)path, list.lastIndexOf$default$2()) - 1;
            return ((Option)this.m_CurrentPaths.lift().apply((Object)BoxesRunTime.boxToInteger((int)index))).orElse(this::getPrevious$$anonfun$1);
        }
        throw new MatchError(option);
    }

    public Option<TreePath> getNext(Option<TreePath> tp) {
        Option<TreePath> option = tp;
        if (None$.MODULE$.equals(option)) {
            return this.m_CurrentPaths.headOption();
        }
        if (option instanceof Some) {
            TreePath path = (TreePath)((Some)option).value();
            List<TreePath> list = this.m_CurrentPaths;
            int index = list.lastIndexOf((Object)path, list.lastIndexOf$default$2()) + 1;
            return ((Option)this.m_CurrentPaths.lift().apply((Object)BoxesRunTime.boxToInteger((int)index))).orElse(this::getNext$$anonfun$1);
        }
        throw new MatchError(option);
    }

    public List<Node> findElement(Node node, String expr) {
        Nil$ nil$;
        Object query = expr;
        query = !expr.startsWith("=") ? "//*[contains(text(),'" + (String)query + "')]" : ((String)query).substring(1, ((String)query).length());
        this.rd.m_Log().debug((Object)("query string " + (String)query));
        if (StringUtil.isEmpty((String)query)) {
            return package$.MODULE$.Nil();
        }
        Document doc = node.getOwnerDocument();
        try {
            DOMXPath rootXPath = new DOMXPath((String)query);
            DesignerNamespaceContext namespaceContext = new DesignerNamespaceContext(node.getOwnerDocument().getDocumentElement());
            rootXPath.setNamespaceContext((NamespaceContext)namespaceContext);
            this.rd.m_Log().debug((Object)"start search");
            nil$ = CollectionConverters$.MODULE$.ListHasAsScala(rootXPath.selectNodes((Object)doc)).asScala().toList().collect((PartialFunction)new Serializable(){

                public final boolean isDefinedAt(Object x) {
                    Object object = x;
                    if (object instanceof Node) {
                        Node n = (Node)object;
                        return true;
                    }
                    return false;
                }

                public final Object applyOrElse(Object x, Function1 function1) {
                    Object object = x;
                    if (object instanceof Node) {
                        Node n = (Node)object;
                        return n;
                    }
                    return function1.apply(x);
                }
            });
        }
        catch (JaxenException e) {
            this.rd.m_Log().warn((Object)("Unable to search node based on this xpath expression: " + this.m_Expr));
            nil$ = package$.MODULE$.Nil();
        }
        return nil$;
    }

    public void expand(JTree tree, List<Node> nodes) {
        this.m_CurrentPaths = package$.MODULE$.Nil();
        nodes.foreach((Function1)(JProcedure1 & Serializable)node -> this.expand(tree, (Node)node).foreach((Function1)(JProcedure1 & Serializable)tp -> {
            List<TreePath> list = this.m_CurrentPaths;
            this.m_CurrentPaths = ((List)new .colon.colon(tp, (List)Nil$.MODULE$)).$colon$colon$colon(list);
        }));
    }

    public void collapse(JTree tree, List<TreePath> paths) {
        paths.foreach((Function1)(JProcedure1 & Serializable)treePath -> tree.removeSelectionPath((TreePath)treePath));
        this.expandAll(tree, false);
    }

    public Option<TreePath> expand(JTree tree, Node node) {
        Object[] objs;
        ArrayList<Node> nodes = new ArrayList<Node>();
        this.extractNode(node, nodes);
        if (nodes.size() > 0) {
            nodes.remove(0);
        }
        if ((objs = nodes.toArray(new Object[nodes.size()])) == null || objs.length == 0) {
            return None$.MODULE$;
        }
        TreePath tp = new TreePath(objs);
        tree.expandPath(tp);
        nodes.add(node);
        objs = nodes.toArray(new Object[nodes.size()]);
        tp = new TreePath(objs);
        tree.addSelectionPath(tp);
        return Some$.MODULE$.apply((Object)tp);
    }

    public void extractNode(Node node, ArrayList<Node> nodes) {
        Node parent = node.getParentNode();
        if (parent != null) {
            this.extractNode(parent, nodes);
            nodes.add(parent);
            return;
        }
    }

    public void expandAll(JTree tree, boolean expand) {
        Node root = (Node)tree.getModel().getRoot();
        this.expandAll(tree, new TreePath(root), expand);
    }

    private void expandAll(JTree tree, TreePath parent, boolean expand) {
        Node node = (Node)parent.getLastPathComponent();
        NodeList nl = node.getChildNodes();
        int len = nl.getLength();
        if (nl.getLength() >= 0) {
            RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), len).foreach((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
                Node child = nl.item(i);
                TreePath path = parent.pathByAddingChild(child);
                this.expandAll(tree, path, expand);
            });
        }
        if (expand) {
            tree.expandPath(parent);
            return;
        }
        tree.collapsePath(parent);
    }

    private final Option getPrevious$$anonfun$1() {
        return this.m_CurrentPaths.lastOption();
    }

    private final Option getNext$$anonfun$1() {
        return this.m_CurrentPaths.headOption();
    }
}

