/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.wizard.datasource.xml.tree;

import com.elixirtech.wizard.datasource.xml.tree.DomTreeModel;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.tree.TreePath;
import org.w3c.dom.Node;

public class DomTListener
implements MouseListener {
    private JTree m_Tree;

    public DomTListener(JTree jTree) {
        this.m_Tree = jTree;
        this.m_Tree.addMouseListener(this);
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            this.doPopup(mouseEvent);
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            this.doPopup(mouseEvent);
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            this.doPopup(mouseEvent);
        } else if (mouseEvent.getClickCount() == 2) {
            this.doDoubleClick(mouseEvent);
        }
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    protected void doPopup(MouseEvent mouseEvent) {
        Point point = mouseEvent.getPoint();
        int n = this.m_Tree.getRowForLocation(point.x, point.y);
        TreePath treePath = this.m_Tree.getPathForLocation(point.x, point.y);
        if (n != -1) {
            Node node = (Node)treePath.getLastPathComponent();
            JPopupMenu jPopupMenu = this.getPopupMenu(node);
            if (jPopupMenu != null) {
                jPopupMenu.show(this.m_Tree, point.x, point.y);
            }
            mouseEvent.consume();
        }
    }

    protected void doDoubleClick(MouseEvent mouseEvent) {
        Point point = mouseEvent.getPoint();
        int n = this.m_Tree.getRowForLocation(point.x, point.y);
        TreePath treePath = this.m_Tree.getPathForLocation(point.x, point.y);
        if (n != -1) {
            Node node = (Node)treePath.getLastPathComponent();
            this.doDoubleClick(node);
            mouseEvent.consume();
        }
    }

    protected JPopupMenu getPopupMenu(Node node) {
        return ((DomTreeModel)this.m_Tree.getModel()).getPopupMenu(node);
    }

    protected void doDoubleClick(Node node) {
        ((DomTreeModel)this.m_Tree.getModel()).doDoubleClick(node);
    }
}

