/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.wizard.datasource.xml.tree;

import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JPopupMenu;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DomTreeModel
implements TreeModel {
    protected Node m_RootNode;
    protected Vector<TreeModelListener> m_Listeners = new Vector();

    public DomTreeModel() {
    }

    public DomTreeModel(Node node) {
        this.setRoot(node);
    }

    public void setRoot(Node node) {
        this.m_RootNode = node;
    }

    @Override
    public synchronized void addTreeModelListener(TreeModelListener treeModelListener) {
        this.m_Listeners.addElement(treeModelListener);
    }

    @Override
    public Object getChild(Object object, int n) {
        return this.getChildNodes(object)[n];
    }

    @Override
    public int getChildCount(Object object) {
        return this.getChildNodes(object).length;
    }

    protected Node[] getChildNodes(Object object) {
        NodeList nodeList = ((Node)object).getChildNodes();
        Node[] nodeArray = new Node[nodeList.getLength()];
        for (int i = 0; i < nodeArray.length; ++i) {
            nodeArray[i] = nodeList.item(i);
        }
        return nodeArray;
    }

    @Override
    public int getIndexOfChild(Object object, Object object2) {
        Node[] nodeArray = this.getChildNodes(object);
        for (int i = 0; i < nodeArray.length; ++i) {
            if (nodeArray[i] != object2) continue;
            return i;
        }
        return -1;
    }

    @Override
    public Object getRoot() {
        return this.m_RootNode;
    }

    @Override
    public boolean isLeaf(Object object) {
        return this.getChildCount(object) == 0;
    }

    @Override
    public synchronized void removeTreeModelListener(TreeModelListener treeModelListener) {
        this.m_Listeners.removeElement(treeModelListener);
    }

    @Override
    public void valueForPathChanged(TreePath treePath, Object object) {
    }

    public void doDoubleClick(Node node) {
    }

    public JPopupMenu getPopupMenu(Node node) {
        return null;
    }

    public TreePath getTreePath(Node node) {
        Vector<Node> vector = new Vector<Node>();
        for (Node node2 = node; node2 != null; node2 = node2.getParentNode()) {
            vector.insertElementAt(node2, 0);
        }
        Object[] objectArray = new Object[vector.size()];
        vector.copyInto(objectArray);
        return new TreePath(objectArray);
    }

    public void fireInsertedEvent(TreePath treePath, int[] nArray, Object[] objectArray) {
        TreeModelEvent treeModelEvent = new TreeModelEvent((Object)this, treePath, nArray, objectArray);
        this.fireInsertedEvent(treeModelEvent);
    }

    public void fireRemovedEvent(TreePath treePath, int[] nArray, Object[] objectArray) {
        TreeModelEvent treeModelEvent = new TreeModelEvent((Object)this, treePath, nArray, objectArray);
        this.fireRemovedEvent(treeModelEvent);
    }

    public void fireChangedEvent(TreePath treePath, int[] nArray, Object[] objectArray) {
        TreeModelEvent treeModelEvent = new TreeModelEvent((Object)this, treePath, nArray, objectArray);
        this.fireChangedEvent(treeModelEvent);
    }

    public void fireInsertedEvent(TreePath treePath) {
        TreeModelEvent treeModelEvent = new TreeModelEvent((Object)this, treePath);
        this.fireInsertedEvent(treeModelEvent);
    }

    public void fireRemovedEvent(TreePath treePath) {
        TreeModelEvent treeModelEvent = new TreeModelEvent((Object)this, treePath);
        this.fireRemovedEvent(treeModelEvent);
    }

    public void fireChangedEvent(TreePath treePath) {
        TreeModelEvent treeModelEvent = new TreeModelEvent((Object)this, treePath);
        this.fireChangedEvent(treeModelEvent);
    }

    public void fireStructureChangedEvent(TreePath treePath) {
        TreeModelEvent treeModelEvent = new TreeModelEvent((Object)this, treePath);
        this.fireStructureChangedEvent(treeModelEvent);
    }

    private void fireInsertedEvent(TreeModelEvent treeModelEvent) {
        Enumeration<TreeModelListener> enumeration = this.m_Listeners.elements();
        while (enumeration.hasMoreElements()) {
            TreeModelListener treeModelListener = enumeration.nextElement();
            treeModelListener.treeNodesInserted(treeModelEvent);
        }
    }

    private void fireRemovedEvent(TreeModelEvent treeModelEvent) {
        Enumeration<TreeModelListener> enumeration = this.m_Listeners.elements();
        while (enumeration.hasMoreElements()) {
            TreeModelListener treeModelListener = enumeration.nextElement();
            treeModelListener.treeNodesRemoved(treeModelEvent);
        }
    }

    private void fireChangedEvent(TreeModelEvent treeModelEvent) {
        Enumeration<TreeModelListener> enumeration = this.m_Listeners.elements();
        while (enumeration.hasMoreElements()) {
            TreeModelListener treeModelListener = enumeration.nextElement();
            treeModelListener.treeNodesChanged(treeModelEvent);
        }
    }

    private void fireStructureChangedEvent(TreeModelEvent treeModelEvent) {
        Enumeration<TreeModelListener> enumeration = this.m_Listeners.elements();
        while (enumeration.hasMoreElements()) {
            TreeModelListener treeModelListener = enumeration.nextElement();
            treeModelListener.treeStructureChanged(treeModelEvent);
        }
    }
}

