/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.wizard.expression;

import com.elixirtech.arch.Elixir;
import com.elixirtech.arch.wizard.RelativeLayoutWizardPage;
import com.elixirtech.data2.DataSchema;
import com.elixirtech.data2.DataSourceManager;
import com.elixirtech.data2.IDataSource;
import com.elixirtech.ensemble.wizard.result.ResultSchemaPanel;
import com.elixirtech.report2.I18N;
import com.elixirtech.report2.raw.model.DataSource;
import com.elixirtech.report2.raw.model.RawReport;
import com.elixirtech.ui.wizard.IFinishPage;
import com.elixirtech.ui.wizard.IWizard;
import com.elixirtech.util.CodeBlock;
import com.elixirtech.wizard.expression.ExpressionWizard;
import java.util.HashSet;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JRadioButton;

public class GroupPage
extends RelativeLayoutWizardPage
implements IFinishPage {
    private JComboBox m_DataSources;
    private JButton m_Add;
    private ResultSchemaPanel m_SchemaPanel;
    private JCheckBox m_RunningSum;
    private JComboBox m_Operation;
    private JRadioButton m_OverGroup;
    private JRadioButton m_OverAll;

    public GroupPage() {
        super("Group", null);
    }

    @Override
    public void setWizard(IWizard iWizard) {
        super.setWizard(iWizard);
        this.m_DataSources = new JComboBox<Object>(this.getDataSources());
        this.m_DataSources.addItemListener(new CodeBlock((Object)this, "dsSelection"));
        this.m_Add = new JButton("Add");
        this.m_SchemaPanel = new ResultSchemaPanel(true);
        this.m_SchemaPanel.addListSelectionListener(new CodeBlock((Object)this, "fieldSelection"));
        this.m_RunningSum = new JCheckBox("Running value");
        this.m_Operation = new JComboBox(this.getOperations());
        this.m_OverGroup = new JRadioButton("Over Group");
        this.m_OverAll = new JRadioButton("Over All");
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.m_OverGroup);
        buttonGroup.add(this.m_OverAll);
        this.m_OverGroup.setSelected(true);
        this.m_Component.add("ds-label", new JLabel("DataSource:"));
        this.m_Component.add("ds", this.m_DataSources);
        this.m_Component.add("add", this.m_Add);
        this.m_Component.add("schema", this.m_SchemaPanel);
        this.m_Component.add("running", this.m_RunningSum);
        this.m_Component.add("op", this.m_Operation);
        this.m_Component.add("group", this.m_OverGroup);
        this.m_Component.add("all", this.m_OverAll);
        this.stickLeft("ds-label");
        this.vCenter("ds-label", "ds");
        this.stickTop("ds");
        this.putRight("ds", "ds-label", 10);
        this.putLeft("ds", "add");
        this.stickRight("add");
        this.stickTop("add");
        this.setHeight("add", "ds");
        this.stickLeft("schema");
        this.stickRight("schema");
        this.putBelow("schema", "ds", 5);
        this.stickLeft("op");
        this.putRight("group", "op", 10);
        this.putRight("all", "group", 5);
        this.putRight("running", "all", 10);
        this.stickBottom("op");
        this.stickBottom("group");
        this.stickBottom("all");
        this.stickBottom("running");
        this.putAbove("schema", "op,group,all,running", 5);
        this.dsSelection();
        I18N.ERD_MAP.injectObject(null, this, "GroupPage");
    }

    protected Object[] getDataSources() {
        RawReport rawReport = ((ExpressionWizard)this.m_Wizard).getReport();
        Object[] objectArray = new DataSource[rawReport.getDataSourceCount()];
        for (int i = 0; i < objectArray.length; ++i) {
            objectArray[i] = rawReport.getDataSource(i);
        }
        return objectArray;
    }

    protected ComboBoxModel getOperations() {
        DefaultComboBoxModel<String> defaultComboBoxModel = new DefaultComboBoxModel<String>();
        defaultComboBoxModel.addElement("Average");
        defaultComboBoxModel.addElement("Maximum");
        defaultComboBoxModel.addElement("Minimum");
        defaultComboBoxModel.addElement("StandardDeviation");
        defaultComboBoxModel.addElement("Sum");
        defaultComboBoxModel.addElement("Variance");
        return defaultComboBoxModel;
    }

    public void dsSelection() {
        DataSource dataSource = (DataSource)this.m_DataSources.getSelectedItem();
        if (dataSource != null) {
            DataSourceManager dataSourceManager = (DataSourceManager)Elixir.get(DataSourceManager.class);
            try {
                IDataSource iDataSource = dataSourceManager.getDataSource(dataSourceManager, dataSource.getDataSourceName());
                DataSchema dataSchema = iDataSource.getSchema();
                this.m_SchemaPanel.setSchema(dataSchema, new HashSet<String>());
            }
            catch (Throwable throwable) {
                this.m_SchemaPanel.setSchema(null, new HashSet<String>());
            }
        }
    }

    public void fieldSelection() {
        this.m_Wizard.getContainer().updateButtons();
    }

    @Override
    public boolean isPageComplete() {
        boolean bl;
        boolean bl2 = bl = this.m_SchemaPanel.getSelection() >= 0;
        if (bl) {
            this.setError(null);
        } else {
            this.setError(I18N.ERD.getString("Wizard.field-required"));
        }
        this.m_Wizard.getContainer().updateMessage();
        return bl;
    }

    @Override
    public void doFinish() {
        String string = this.m_SchemaPanel.getSelectedName();
        String string2 = (String)this.m_Operation.getSelectedItem();
        String string3 = this.m_RunningSum.isSelected() ? "Running" : "";
        String string4 = this.m_OverGroup.isSelected() ? "Group" : "All";
        String string5 = "Data.get" + string2 + "(" + string + ").get" + string3 + "ValueOver" + string4 + "()";
        ((ExpressionWizard)this.m_Wizard).setExpression(string5);
    }
}

