/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.wizard.expression;

import com.elixirtech.arch.Elixir;
import com.elixirtech.arch.wizard.RelativeLayoutWizardPage;
import com.elixirtech.data2.DataSchema;
import com.elixirtech.data2.DataSourceManager;
import com.elixirtech.data2.IDataSource;
import com.elixirtech.ensemble.wizard.result.ResultSchemaPanel;
import com.elixirtech.report2.I18N;
import com.elixirtech.report2.raw.model.DataSource;
import com.elixirtech.report2.raw.model.RawReport;
import com.elixirtech.ui.wizard.IFinishPage;
import com.elixirtech.ui.wizard.IWizard;
import com.elixirtech.util.CodeBlock;
import com.elixirtech.wizard.expression.ExpressionWizard;
import java.util.HashSet;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;

public class SinglePage
extends RelativeLayoutWizardPage
implements IFinishPage {
    private JComboBox m_DataSources;
    private JButton m_Add;
    private ResultSchemaPanel m_SchemaPanel;

    public SinglePage() {
        super("Single", null);
        this.setTitle("Single Field");
        this.setMessage("Select a field");
    }

    @Override
    public void setWizard(IWizard iWizard) {
        super.setWizard(iWizard);
        this.m_DataSources = new JComboBox<Object>(this.getDataSources());
        this.m_DataSources.addItemListener(new CodeBlock((Object)this, "dsSelection"));
        this.m_Add = new JButton("Add");
        this.m_SchemaPanel = new ResultSchemaPanel(true);
        this.m_SchemaPanel.addListSelectionListener(new CodeBlock((Object)this, "fieldSelection"));
        this.m_Component.add("ds-label", new JLabel("DataSource:"));
        this.m_Component.add("ds", this.m_DataSources);
        this.m_Component.add("add", this.m_Add);
        this.m_Component.add("schema", this.m_SchemaPanel);
        this.stickLeft("ds-label");
        this.vCenter("ds-label", "ds");
        this.stickTop("ds");
        this.putRight("ds", "ds-label", 10);
        this.putLeft("ds", "add");
        this.stickRight("add");
        this.stickTop("add");
        this.setHeight("add", "ds");
        this.stickLeft("schema");
        this.stickBottom("schema");
        this.stickRight("schema");
        this.putBelow("schema", "ds", 5);
        this.dsSelection();
    }

    protected Object[] getDataSources() {
        RawReport rawReport = ((ExpressionWizard)this.m_Wizard).getReport();
        Object[] objectArray = new DataSource[rawReport.getDataSourceCount()];
        for (int i = 0; i < objectArray.length; ++i) {
            objectArray[i] = rawReport.getDataSource(i);
        }
        return objectArray;
    }

    public void dsSelection() {
        DataSource dataSource = (DataSource)this.m_DataSources.getSelectedItem();
        if (dataSource != null) {
            DataSourceManager dataSourceManager = (DataSourceManager)Elixir.get(DataSourceManager.class);
            try {
                IDataSource iDataSource = dataSourceManager.getDataSource(dataSourceManager, dataSource.getDataSourceName());
                DataSchema dataSchema = iDataSource.getSchema();
                this.m_SchemaPanel.setSchema(dataSchema, new HashSet<String>());
            }
            catch (Throwable throwable) {
                this.m_SchemaPanel.setSchema(null, new HashSet<String>());
            }
        }
    }

    public void fieldSelection() {
        this.m_Wizard.getContainer().updateButtons();
    }

    @Override
    public boolean isPageComplete() {
        boolean bl;
        boolean bl2 = bl = this.m_SchemaPanel.getSelection() >= 0;
        if (bl) {
            this.setError(null);
        } else {
            this.setError(I18N.ERD.getString("Wizard.field-required"));
        }
        this.m_Wizard.getContainer().updateMessage();
        return bl;
    }

    @Override
    public void doFinish() {
        String string = ((DataSource)this.m_DataSources.getSelectedItem()).getName();
        String string2 = this.m_SchemaPanel.getSelectedName();
        String string3 = string + ":" + string2;
        ((ExpressionWizard)this.m_Wizard).setExpression(string3);
    }
}

