/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.wizard.filter;

import com.elixirtech.arch.Elixir;
import com.elixirtech.arch.ElixirJ;
import com.elixirtech.arch.repository.FileType;
import com.elixirtech.arch.repository.RepositoryExplorer;
import com.elixirtech.arch.repository.RepositoryTree;
import com.elixirtech.data2.DataSchema;
import com.elixirtech.data2.IDataSource;
import com.elixirtech.ensemble.DataSourceFileType;
import com.elixirtech.ensemble.ds.DSUtil2;
import com.elixirtech.ui.SwingFactory;
import com.elixirtech.ui.TitledBorder;
import com.elixirtech.ui.property.I18N;
import com.elixirtech.util.CodeBlock;
import com.elixirtech.util.StringUtil;
import com.elixirtech.v2.repository.FileObject;
import com.elixirtech.v2.repository.Repository;
import com.elixirtech.wizard.filter.IDataSetProviderTab;
import java.awt.BorderLayout;
import java.awt.GridLayout;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;

public class RepositoryFieldTab
extends JPanel
implements IDataSetProviderTab {
    protected JTextField m_URL;
    protected RepositoryTree m_RepositoryTree;
    protected JList m_Fields;
    protected boolean m_UpdateInProgress;

    public RepositoryFieldTab() {
        Repository repository = (Repository)Elixir.get(Repository.class);
        this.m_RepositoryTree = RepositoryTree.apply("RepositoryFieldTab", repository, this.getFilter());
        this.m_RepositoryTree.addTreeSelectionListener(new TSL());
        this.m_Fields = SwingFactory.newList();
        this.m_Fields.addListSelectionListener(new CodeBlock((Object)this, "fieldChanged"));
        this.setLayout(new GridLayout(1, 2, 5, 0));
        this.add(this.titledPanel(new JScrollPane(this.m_RepositoryTree), "DataSource"));
        this.add(this.titledPanel(new JScrollPane(this.m_Fields), "Fields"));
    }

    private JComponent titledPanel(JComponent jComponent, String string) {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add(jComponent);
        jPanel.setBorder(new TitledBorder(new JLabel(I18N.ENSEMBLE.getString("RepositoryTab." + string))));
        return jPanel;
    }

    @Override
    public String getTabName() {
        return I18N.ENSEMBLE.getString("RepositoryTab.TITLE");
    }

    @Override
    public JComponent getComponent() {
        return this;
    }

    @Override
    public void setURLField(JTextField jTextField) {
        this.m_URL = jTextField;
    }

    public void fieldChanged() {
        if (!this.m_UpdateInProgress) {
            this.updateURL();
        }
    }

    public void updateURL() {
        if (this.m_Fields.isSelectionEmpty()) {
            return;
        }
        FileObject fileObject = this.m_RepositoryTree.getSelectionJ();
        if (fileObject != null) {
            this.m_URL.setText("repository:" + String.valueOf(fileObject.getPath()) + ":" + String.valueOf(this.m_Fields.getSelectedValue()));
        }
    }

    @Override
    public void setEnabled(boolean bl) {
        this.m_RepositoryTree.setEnabled(bl);
        this.m_Fields.setEnabled(bl);
    }

    @Override
    public void setURL(String string) {
        this.m_UpdateInProgress = true;
        if (string.startsWith("repository:")) {
            String string2 = string.substring(11);
            String[] stringArray = StringUtil.arrayOfSubstrings(string2, ':');
            Repository repository = (Repository)Elixir.get(Repository.class);
            FileObject fileObject = repository.getFileJ(stringArray[0]);
            if (fileObject != null) {
                this.m_RepositoryTree.setSelectionJ(fileObject);
            }
            this.loadFields(fileObject);
            if (stringArray[1] != null) {
                this.m_Fields.setSelectedValue(stringArray[1], true);
            }
        } else {
            this.m_RepositoryTree.clearSelection();
            this.m_Fields.setModel(new DefaultListModel());
        }
        this.m_UpdateInProgress = false;
    }

    @Override
    public boolean isValidURL(String string) {
        return string.startsWith("repository:");
    }

    protected FileType getFilter() {
        RepositoryExplorer repositoryExplorer = (RepositoryExplorer)Elixir.get(RepositoryExplorer.class);
        return repositoryExplorer.getFileTypeJ(DataSourceFileType.MIME_TYPE().value());
    }

    protected void loadFields(FileObject fileObject) {
        DefaultListModel<String> defaultListModel = new DefaultListModel<String>();
        if (fileObject == null) {
            return;
        }
        if (fileObject.isData()) {
            try {
                DataSchema dataSchema;
                IDataSource iDataSource = DSUtil2.load(fileObject);
                if (iDataSource != null && (dataSchema = iDataSource.getSchema()) != null) {
                    int n = dataSchema.getColumnCount();
                    for (int i = 0; i < n; ++i) {
                        defaultListModel.addElement(dataSchema.getColumnName(i));
                    }
                }
            }
            catch (Throwable throwable) {
                ElixirJ.error(I18N.ENSEMBLE.getString("RepositoryFieldTab.CANT_LOAD_SCHEMA"), throwable);
            }
        }
        this.m_Fields.setModel(defaultListModel);
        if (defaultListModel.size() > 0) {
            this.m_Fields.setSelectedIndex(0);
        }
    }

    @Override
    public void dispose() {
        if (this.m_RepositoryTree != null) {
            this.m_RepositoryTree.dispose();
        }
    }

    protected class TSL
    implements TreeSelectionListener {
        protected TSL() {
        }

        @Override
        public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
            if (RepositoryFieldTab.this.m_UpdateInProgress) {
                return;
            }
            FileObject fileObject = RepositoryFieldTab.this.m_RepositoryTree.getSelectionJ();
            if (fileObject != null) {
                RepositoryFieldTab.this.loadFields(fileObject);
                RepositoryFieldTab.this.updateURL();
            }
        }
    }
}

