/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.wizard.grid;

import com.elixirtech.i18n.I18NComboBox;
import com.elixirtech.report2.I18N;
import com.elixirtech.report2.raw.model.ControlSource;
import com.elixirtech.report2.raw.model.Grid;
import com.elixirtech.report2.raw.model.RawModelElement;
import com.elixirtech.report2.raw.model.RawReport;
import com.elixirtech.ui.SwingFactory;
import com.elixirtech.ui.SwingUtil;
import com.elixirtech.ui.TabComponent;
import com.elixirtech.wizard.data.FieldPanel;
import com.elixirtech.wizard.data.IDataPanel;
import com.elixirtech.wizard.data.LiteralPanel;
import com.elixirtech.wizard.data.OperationPanel;
import com.elixirtech.wizard.data.ScriptPanel;
import com.elixirtech.wizard.data.URLPanel;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BorderFactory;
import javax.swing.JPanel;

class DataTab
extends TabComponent
implements ItemListener {
    private static final String[] TYPES = new String[]{"Field", "Operation", "Script", "URL", "Literal"};
    private static final String[] TYPE_KEYS = new String[]{"ControlSource.FIELD", "ControlSource.OPERATION", "ControlSource.SCRIPT", "ControlSource.URL", "ControlSource.LITERAL"};
    private Grid m_Grid;
    private I18NComboBox m_Type;
    private CardLayout m_CardLayout;
    private JPanel m_Center;
    private IDataPanel[] m_Panels;

    public DataTab(Grid grid) {
        this.m_Grid = grid;
        ControlSource controlSource = this.m_Grid.getControlSource();
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel(new FlowLayout(0));
        jPanel.add(SwingFactory.newLabel("field-type"));
        this.m_Type = I18NComboBox.apply(I18NComboBox.buildNames(TYPES, I18N.ERD, TYPE_KEYS));
        this.m_Type.addItemListener(this);
        jPanel.add(this.m_Type);
        this.add((Component)jPanel, "North");
        this.buildPanels(controlSource);
        this.m_CardLayout = new CardLayout();
        this.m_Center = new JPanel(this.m_CardLayout);
        for (int i = 0; i < this.m_Panels.length; ++i) {
            this.m_Center.add(TYPES[i], (JPanel)((Object)this.m_Panels[i]));
        }
        this.add((Component)this.m_Center, "Center");
        this.m_Type.setSelectedId(controlSource.getType());
        if (this.m_Type.getSelectedIndex() < 0) {
            this.m_Type.setSelectedIndex(0);
        }
        I18N.ERD_MAP.injectComponents("DataTab.", this);
    }

    public void update() {
        this.m_CardLayout.show(this.m_Center, this.m_Type.getSelectedId());
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        SwingUtil.setEnabled(this, bl);
        for (int i = 0; i < this.m_Panels.length; ++i) {
            SwingUtil.setEnabled((JPanel)((Object)this.m_Panels[i]), bl);
        }
    }

    @Override
    public String getName() {
        return I18N.ERD.getString("DataTab.name");
    }

    @Override
    public String getMessage() {
        return I18N.ERD.getString("DataTab.message");
    }

    @Override
    public boolean containsProperty(String string) {
        return "Grid.ControlSource".equals(string);
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        this.update();
    }

    @Override
    public void performFinish() {
        ControlSource controlSource = this.m_Panels[this.m_Type.getSelectedIndex()].getControlSource();
        this.m_Grid.setControlSource(controlSource);
    }

    protected void buildPanels(ControlSource controlSource) {
        RawReport rawReport = (RawReport)this.m_Grid.getResourceProvider();
        this.m_Panels = new IDataPanel[5];
        this.m_Panels[0] = new FieldPanel(rawReport, (RawModelElement)this.m_Grid, controlSource);
        this.m_Panels[1] = new OperationPanel(rawReport, (RawModelElement)this.m_Grid, controlSource);
        this.m_Panels[2] = new ScriptPanel(controlSource);
        this.m_Panels[3] = new URLPanel(controlSource, new String[]{"Text"});
        this.m_Panels[4] = new LiteralPanel(controlSource);
    }
}

