/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.wizard.grid;

import com.brunchboy.util.swing.relativelayout.AttributeConstraint;
import com.brunchboy.util.swing.relativelayout.AttributeType;
import com.elixirtech.arch.ui.ArchLayout;
import com.elixirtech.graphics.GlyphOrientation;
import com.elixirtech.graphics.WritingMode;
import com.elixirtech.i18n.I18NComboBox;
import com.elixirtech.i18n.Name;
import com.elixirtech.report2.I18N;
import com.elixirtech.report2.raw.model.Grid;
import com.elixirtech.ui.SwingFactory;
import com.elixirtech.ui.SwingUtil;
import com.elixirtech.ui.TabComponent;
import com.elixirtech.ui.UnitField;
import com.elixirtech.util.StringUtil;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;

public class GridTab
extends TabComponent {
    private Grid m_Grid;
    private ArchLayout m_Layout;
    private I18NComboBox m_WritingMode;
    private I18NComboBox m_GlyphOrientation;
    private I18NComboBox m_LayoutType;
    private JRadioButton m_TextHeight;
    private JRadioButton m_LineHeight;
    private JRadioButton m_BoxCount;
    private JSpinner m_BoxCountX;
    private JSpinner m_BoxCountY;
    private JRadioButton m_FixedWidth;
    private UnitField m_Width;
    private static final String[] ORIENTATION = new String[]{GlyphOrientation.AUTO.getName(), GlyphOrientation.INLINE.getName(), GlyphOrientation.UPRIGHT.getName()};
    private static final String[] ORIENTATION_KEYS = new String[]{"Grid.GlyphOrientation.AUTO", "Grid.GlyphOrientation.INLINE", "Grid.GlyphOrientation.UPRIGHT"};
    private static final String[] WRITING_MODE = new String[]{WritingMode.LR_TB.getName(), WritingMode.TB_RL.getName(), WritingMode.RL_TB.getName(), WritingMode.TB_LR.getName()};
    private static final String[] WRITING_MODE_KEYS = new String[]{"Grid.WritingMode.LR_TB", "Grid.WritingMode.TB_RL", "Grid.WritingMode.RL_TB", "Grid.WritingMode.TB_LR"};
    private static final String[] LAYOUT = new String[]{"All", "Ideograph"};
    private static final String[] LAYOUT_KEYS = new String[]{"Grid.Layout.All", "Grid.Layout.Ideograph"};

    public GridTab(Grid grid) {
        this.m_Grid = grid;
        this.m_Layout = new ArchLayout();
        this.setLayout(this.m_Layout);
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        Name[] nameArray = I18NComboBox.buildNames(WRITING_MODE, I18N.ERD, WRITING_MODE_KEYS);
        Name[] nameArray2 = I18NComboBox.buildNames(ORIENTATION, I18N.ERD, ORIENTATION_KEYS);
        Name[] nameArray3 = I18NComboBox.buildNames(LAYOUT, I18N.ERD, LAYOUT_KEYS);
        this.m_WritingMode = this.m_Layout.addI18NCombo(this, "mode", SwingFactory.newLabel("mode-label"), nameArray);
        this.m_GlyphOrientation = this.m_Layout.addI18NCombo(this, "glyph", SwingFactory.newLabel("glyph-label"), nameArray2);
        this.m_LayoutType = this.m_Layout.addI18NCombo(this, "layout", SwingFactory.newLabel("layout-label"), nameArray3);
        this.m_Layout.stickTop("mode");
        this.m_Layout.putRight("mode", "mode-label,glyph-label,layout-label", 10);
        this.m_Layout.alignBelow("glyph", "mode");
        this.m_Layout.alignBelow("layout", "glyph");
        this.m_TextHeight = SwingFactory.newRadioButton("text-height");
        this.add(this.m_TextHeight);
        this.m_LineHeight = SwingFactory.newRadioButton("line-height");
        this.add(this.m_LineHeight);
        this.m_BoxCount = SwingFactory.newRadioButton("box-count");
        this.add(this.m_BoxCount);
        this.m_FixedWidth = SwingFactory.newRadioButton("fixed-width");
        this.add(this.m_FixedWidth);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.m_TextHeight);
        buttonGroup.add(this.m_LineHeight);
        buttonGroup.add(this.m_BoxCount);
        buttonGroup.add(this.m_FixedWidth);
        this.m_Layout.stickLeft("text-height");
        this.m_Layout.putBelow("text-height", "layout", 10);
        this.m_Layout.stickLeft("line-height");
        this.m_Layout.putBelow("line-height", "text-height", 7);
        this.m_Layout.stickLeft("box-count");
        this.m_Layout.putBelow("box-count", "line-height", 7);
        this.m_Layout.stickLeft("fixed-width");
        this.m_Layout.putBelow("fixed-width", "box-count", 7);
        this.m_BoxCountX = SwingFactory.newSpinner("bcx", new SpinnerNumberModel(2, 1, 999, 1));
        this.add(this.m_BoxCountX);
        this.m_BoxCountY = SwingFactory.newSpinner("bcy", new SpinnerNumberModel(2, 1, 999, 1));
        this.add(this.m_BoxCountY);
        this.m_Width = UnitField.newUnitField("width");
        this.add(this.m_Width);
        this.add(SwingFactory.newLabel("across"));
        this.add(SwingFactory.newLabel("down"));
        this.m_Layout.putRight("across", "box-count", 10);
        this.m_Layout.vCenter("across", "box-count");
        this.m_Layout.putRight("bcx", "across", 5);
        this.m_Layout.vCenter("bcx", "across");
        this.m_Layout.putRight("down", "bcx", 10);
        this.m_Layout.vCenter("down", "bcx");
        this.m_Layout.putRight("bcy", "down", 5);
        this.m_Layout.vCenter("bcy", "down");
        this.m_Layout.putRight("width", "fixed-width", 10);
        this.m_Layout.vCenter("width", "fixed-width");
        this.m_Layout.addConstraint("width", AttributeType.RIGHT, new AttributeConstraint("bcy", AttributeType.RIGHT));
        this.m_Width.setValue(200);
        this.m_WritingMode.setSelectedId(this.m_Grid.getWritingMode());
        this.m_GlyphOrientation.setSelectedId(this.m_Grid.getGlyphOrientation());
        this.m_LayoutType.setSelectedId(this.m_Grid.getLineGridMode());
        String string = this.m_Grid.getLineGridProgression();
        if (StringUtil.isEmpty(string)) {
            string = "Line-Height";
        }
        if (string.equals("Text-Height")) {
            this.m_TextHeight.setSelected(true);
        } else if (string.equals("Line-Height")) {
            this.m_LineHeight.setSelected(true);
        } else if (string.startsWith("Box-Count")) {
            this.m_BoxCount.setSelected(true);
            string = string.substring("Box-Count".length()).trim();
            int n = string.indexOf(32);
            String string2 = string.substring(0, n).trim();
            String string3 = string.substring(n + 1).trim();
            try {
                this.m_BoxCountX.setValue(Integer.valueOf(string2));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            try {
                this.m_BoxCountY.setValue(Integer.valueOf(string3));
            }
            catch (NumberFormatException numberFormatException) {}
        } else {
            this.m_FixedWidth.setSelected(true);
            try {
                this.m_Width.setValue(Integer.valueOf(string));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        I18N.ERD_MAP.injectComponents("GridTab.", this);
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        SwingUtil.setEnabled(this, bl);
    }

    @Override
    public String getName() {
        return I18N.ERD.getString("GridTab.name");
    }

    @Override
    public String getMessage() {
        return I18N.ERD.getString("GridTab.message");
    }

    @Override
    public void performFinish() {
        String string = this.m_WritingMode.getSelectedId();
        if (!this.m_Grid.getWritingMode().equals(string)) {
            this.m_Grid.setWritingMode(string);
        }
        String string2 = this.m_GlyphOrientation.getSelectedId();
        if (!this.m_Grid.getGlyphOrientation().equals(string2)) {
            this.m_Grid.setGlyphOrientation(string2);
        }
        String string3 = this.m_LayoutType.getSelectedId();
        if (!this.m_Grid.getLineGridMode().equals(string3)) {
            this.m_Grid.setLineGridMode(string3);
        }
        Object object = null;
        if (this.m_TextHeight.isSelected()) {
            object = "Text-Height";
        } else if (this.m_LineHeight.isSelected()) {
            object = "Line-Height";
        } else if (this.m_BoxCount.isSelected()) {
            object = "Box-Count ";
            object = (String)object + String.valueOf(this.m_BoxCountX.getValue()) + " " + String.valueOf(this.m_BoxCountY.getValue());
        } else {
            object = String.valueOf(this.m_Width.getIntValue());
        }
        if (!((String)object).equals(this.m_Grid.getLineGridProgression())) {
            this.m_Grid.setLineGridProgression((String)object);
        }
    }
}

