/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.wizard.line;

import com.elixirtech.arch.ui.ArchLayout;
import com.elixirtech.i18n.I18NComboBox;
import com.elixirtech.i18n.Name;
import com.elixirtech.report2.I18N;
import com.elixirtech.ui.JColorChooserEx;
import com.elixirtech.ui.StandardColor;
import com.elixirtech.ui.SwingFactory;
import com.elixirtech.ui.UnitField;
import com.elixirtech.util.CodeBlock;
import com.elixirtech.wizard.line.LineTab;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;

public class LinePropertyPanel
implements ActionListener {
    private LineTab m_Tab;
    private JPanel m_Panel;
    private ArchLayout m_Layout = new ArchLayout();
    private I18NComboBox m_StyleCombo;
    private UnitField m_WidthField;
    private JTextField m_ColorField;
    private JButton m_Dots;
    private CodeBlock m_Listener = new CodeBlock((Object)this, "refresh");

    public LinePropertyPanel(LineTab lineTab, String string, Name[] nameArray) {
        this.m_Tab = lineTab;
        this.m_Panel = new JPanel(this.m_Layout);
        this.m_Panel.setBorder(new TitledBorder(I18N.ERD.getString(string)));
        this.m_StyleCombo = I18NComboBox.apply(nameArray);
        this.m_StyleCombo.addItemListener(this.m_Listener);
        this.m_Panel.add(SwingFactory.newLabel("style-label"));
        this.m_Panel.add("style", this.m_StyleCombo);
        this.m_Panel.add(SwingFactory.newLabel("width-label"));
        this.m_WidthField = new UnitField();
        this.m_Panel.add("width", this.m_WidthField);
        this.m_WidthField.addDocumentListener(this.m_Listener);
        this.m_Panel.add(SwingFactory.newLabel("color-label"));
        this.m_ColorField = SwingFactory.newTextField("color", 10);
        this.m_Panel.add(this.m_ColorField);
        this.m_ColorField.getDocument().addDocumentListener(this.m_Listener);
        this.m_Dots = SwingFactory.newDotsButton("dots", this);
        this.m_Panel.add(this.m_Dots);
        this.m_Layout.stickLeft("style-label");
        this.m_Layout.stickLeft("width-label");
        this.m_Layout.stickLeft("color-label");
        this.m_Layout.stickTop("style");
        this.m_Layout.putRight("style", "style-label,width-label,color-label", 5);
        this.m_Layout.vCenter("style-label", "style");
        this.m_Layout.vCenter("width-label", "width");
        this.m_Layout.vCenter("color-label", "color");
        this.m_Layout.vCenter("dots", "color");
        this.m_Layout.setHeight("dots", "color");
        this.m_Layout.alignBelow("width", "style");
        this.m_Layout.alignBelow("color", "width");
        this.m_Layout.putLeft("color", "dots");
        this.m_Layout.stickRight("style");
        this.m_Layout.stickRight("width");
        this.m_Layout.stickRight("dots");
        I18N.ERD_MAP.injectComponents("LinePropertyPanel.", this.m_Panel);
    }

    public JPanel getPanel() {
        Dimension dimension = this.m_Panel.getPreferredSize();
        dimension.width = 250;
        this.m_Panel.setPreferredSize(dimension);
        return this.m_Panel;
    }

    public void setStyle(String string) {
        this.m_StyleCombo.setSelectedId(string);
    }

    public String getStyle() {
        return this.m_StyleCombo.getSelectedId();
    }

    public void setWidth(int n) {
        this.m_WidthField.setIntValue(n);
    }

    public int getWidth() {
        return this.m_WidthField.getIntValue();
    }

    public void setColor(String string) {
        this.m_ColorField.setText(string);
    }

    public String getColor() {
        return this.m_ColorField.getText();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Color color = StandardColor.lookup(this.m_ColorField.getText());
        Color color2 = JColorChooserEx.showDialog(this.m_Dots, color);
        if (!color2.equals(color)) {
            this.m_ColorField.setText(StandardColor.getColorName(color2));
        }
    }

    public void refresh() {
        this.m_Tab.refresh();
    }
}

