/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.wizard.line;

import com.elixirtech.graphics.BorderStyle;
import com.elixirtech.graphics.GLine;
import com.elixirtech.graphics.GraphicsLineDrawable;
import com.elixirtech.i18n.I18NComboBox;
import com.elixirtech.i18n.Name;
import com.elixirtech.report2.I18N;
import com.elixirtech.report2.raw.model.Line;
import com.elixirtech.ui.StandardColor;
import com.elixirtech.ui.SwingUtil;
import com.elixirtech.ui.TabComponent;
import com.elixirtech.wizard.line.LinePropertyPanel;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import javax.swing.BorderFactory;
import javax.swing.JComponent;

public class LineTab
extends TabComponent {
    private static final String[] LINES = new String[]{"None", "Solid", "Dashed", "Dotted", "Double", "DotDash", "DotDotDash", "Wave"};
    private static final String[] LINE_STYLES = new String[]{"Line.NONE", "Line.SOLID", "Line.DASHED", "Line.DOTTED", "Line.DOUBLE", "Line.DOTDASH", "Line.DOTDOTDASH", "Line.WAVE"};
    private static final String[] ARROWS = new String[]{"None", "Arrow", "Diamond", "Open-Arrow", "Round", "Square", "Symmetric-Arrow"};
    private static final String[] ARROW_STYLES = new String[]{"Arrow.NONE", "Arrow.ARROW", "Arrow.DIAMOND", "Arrow.OPEN_ARROW", "Arrow.ROUND", "Arrow.SQUARE", "Arrow.SYMMETRIC"};
    private Line m_Line;
    LinePropertyPanel m_LineProperties;
    LinePropertyPanel m_Arrow1Properties;
    LinePropertyPanel m_Arrow2Properties;
    private LinePreview m_Preview;

    public LineTab(Line line) {
        this.m_Line = line;
        this.setLayout(new GridLayout(2, 2));
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        Name[] nameArray = I18NComboBox.buildNames(LINES, I18N.ERD, LINE_STYLES);
        Name[] nameArray2 = I18NComboBox.buildNames(ARROWS, I18N.ERD, ARROW_STYLES);
        this.m_LineProperties = new LinePropertyPanel(this, "LinePropertyPanel.Line", nameArray);
        this.m_Arrow1Properties = new LinePropertyPanel(this, "LinePropertyPanel.Arrow1", nameArray2);
        this.m_Arrow2Properties = new LinePropertyPanel(this, "LinePropertyPanel.Arrow2", nameArray2);
        this.m_Preview = new LinePreview();
        this.add(this.m_LineProperties.getPanel());
        this.add(this.m_Preview);
        this.add(this.m_Arrow1Properties.getPanel());
        this.add(this.m_Arrow2Properties.getPanel());
        this.m_LineProperties.setStyle(this.m_Line.getLineStyle());
        this.m_LineProperties.setWidth(this.m_Line.getLineWidth());
        this.m_LineProperties.setColor(this.m_Line.getLineColor());
        this.m_Arrow1Properties.setStyle(this.m_Line.getArrowStyle1());
        this.m_Arrow1Properties.setWidth(this.m_Line.getArrowWidth1());
        this.m_Arrow1Properties.setColor(this.m_Line.getArrowColor1());
        this.m_Arrow2Properties.setStyle(this.m_Line.getArrowStyle2());
        this.m_Arrow2Properties.setWidth(this.m_Line.getArrowWidth2());
        this.m_Arrow2Properties.setColor(this.m_Line.getArrowColor2());
        I18N.ERD_MAP.injectComponents("LineTab.", this);
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        SwingUtil.setEnabled(this, bl);
    }

    @Override
    public String getName() {
        return I18N.ERD.getString("LineTab.name");
    }

    @Override
    public String getMessage() {
        return I18N.ERD.getString("LineTab.message");
    }

    @Override
    public void performFinish() {
        String string;
        int n;
        String string2 = this.m_LineProperties.getStyle();
        if (this.changed(string2, this.m_Line.getLineStyle())) {
            this.m_Line.setLineStyle(string2);
        }
        if ((n = this.m_LineProperties.getWidth()) != this.m_Line.getLineWidth()) {
            this.m_Line.setLineWidth(n);
        }
        if (!(string = this.m_LineProperties.getColor()).equals(this.m_Line.getLineColor())) {
            this.m_Line.setLineColor(string);
        }
        if (this.changed(string2 = this.m_Arrow1Properties.getStyle(), this.m_Line.getArrowStyle1())) {
            this.m_Line.setArrowStyle1(string2);
        }
        if ((n = this.m_Arrow1Properties.getWidth()) != this.m_Line.getArrowWidth1()) {
            this.m_Line.setArrowWidth1(n);
        }
        if (!(string = this.m_Arrow1Properties.getColor()).equals(this.m_Line.getArrowColor1())) {
            this.m_Line.setArrowColor1(string);
        }
        if (this.changed(string2 = this.m_Arrow2Properties.getStyle(), this.m_Line.getArrowStyle2())) {
            this.m_Line.setArrowStyle2(string2);
        }
        if ((n = this.m_Arrow2Properties.getWidth()) != this.m_Line.getArrowWidth2()) {
            this.m_Line.setArrowWidth2(n);
        }
        if (!(string = this.m_Arrow2Properties.getColor()).equals(this.m_Line.getArrowColor2())) {
            this.m_Line.setArrowColor2(string);
        }
    }

    public void refresh() {
        this.m_Preview.repaint();
    }

    private boolean changed(Object object, Object object2) {
        if (object == null) {
            return object2 != null;
        }
        return !object.equals(object2);
    }

    private class LinePreview
    extends JComponent {
        private GLine m_GLine = new GLine();
        private GraphicsLineDrawable m_Drawable = new GraphicsLineDrawable();

        public LinePreview() {
            this.m_GLine = new GLine();
        }

        @Override
        public void paint(Graphics graphics) {
            Dimension dimension = this.getSize();
            graphics.setColor(Color.WHITE);
            graphics.fillRect(0, 0, dimension.width, dimension.height);
            int n = 1000;
            int n2 = 20 * dimension.height / 2;
            this.m_GLine.setLine(n, n2, dimension.width * 20 - n, n2);
            this.m_GLine.setLineColor(StandardColor.lookup(LineTab.this.m_LineProperties.getColor()));
            this.m_GLine.setArrowColor1(StandardColor.lookup(LineTab.this.m_Arrow1Properties.getColor()));
            this.m_GLine.setArrowColor2(StandardColor.lookup(LineTab.this.m_Arrow2Properties.getColor()));
            this.m_GLine.setLineStyle(BorderStyle.get(LineTab.this.m_LineProperties.getStyle()));
            this.m_GLine.setArrowStyle1(LineTab.this.m_Arrow1Properties.getStyle());
            this.m_GLine.setArrowStyle2(LineTab.this.m_Arrow2Properties.getStyle());
            this.m_GLine.setLineWidth(LineTab.this.m_LineProperties.getWidth());
            this.m_GLine.setArrowWidth1(LineTab.this.m_Arrow1Properties.getWidth());
            this.m_GLine.setArrowWidth2(LineTab.this.m_Arrow2Properties.getWidth());
            ((Graphics2D)graphics).scale(0.05, 0.05);
            this.m_Drawable.setGraphics((Graphics2D)graphics);
            this.m_GLine.draw(this.m_Drawable);
        }
    }
}

