/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.wizard.map;

import com.elixirtech.editor.JEditor;
import com.elixirtech.editor.REJavaScriptTypes;
import com.elixirtech.report2.I18N;
import com.elixirtech.report2.raw.model.MapElement;
import com.elixirtech.report2.raw.model.Script;
import com.elixirtech.ui.SwingFactory;
import com.elixirtech.ui.TabComponent;
import java.awt.BorderLayout;
import java.awt.FlowLayout;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.text.StyledEditorKit;

public class JavaScriptGraphicsTab
extends TabComponent {
    private MapElement m_Map;
    private JEditor m_ScriptEditor;

    public JavaScriptGraphicsTab(MapElement mapElement) {
        this.m_Map = mapElement;
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.setLayout(new BorderLayout());
        JLabel jLabel = SwingFactory.newLabel("script");
        StyledEditorKit styledEditorKit = REJavaScriptTypes.kit();
        String string = "";
        Script script = mapElement.getScript();
        if (script != null) {
            string = script.getText();
        }
        this.m_ScriptEditor = new JEditor(string, styledEditorKit);
        JPanel jPanel = new JPanel(new FlowLayout(0, 5, 5));
        jPanel.add(jLabel);
        this.add("North", jPanel);
        JScrollPane jScrollPane = null;
        jScrollPane = new JScrollPane(this.m_ScriptEditor);
        this.add("Center", jScrollPane);
        jScrollPane.setBorder(BorderFactory.createEtchedBorder());
        I18N.ERD_MAP.injectComponents("JavaScriptGraphicsTab.", this);
        this.m_ScriptEditor.setToolTipText("<html>g : java.awt.Graphics2D<br>rc : java.awt.Rectangle<br>plotrc : java.awt.Rectangle</html>");
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.m_ScriptEditor.setEnabled(bl);
    }

    @Override
    public String getMessage() {
        return I18N.ERD.getString("JavaScriptGraphicsTab.message");
    }

    @Override
    public String getName() {
        return I18N.ERD.getString("JavaScriptGraphicsTab.name");
    }

    @Override
    public void performFinish() {
        Script script = this.m_Map.getScript();
        if (script == null) {
            script = new Script();
            this.m_Map.setScript(script);
        }
        script.setText(this.m_ScriptEditor.getText());
    }
}

