/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.wizard.map;

import com.elixirtech.arch.Elixir;
import com.elixirtech.arch.ElixirFrame;
import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.arch.repository.FileType;
import com.elixirtech.arch.repository.RepositoryChooser;
import com.elixirtech.arch.repository.RepositoryExplorer;
import com.elixirtech.arch.ui.ArchLayout;
import com.elixirtech.data2.DataSchema;
import com.elixirtech.data2.DataSourceManager;
import com.elixirtech.data2.DataType;
import com.elixirtech.data2.IDataSource;
import com.elixirtech.erd.reportdesigner.data.AddDataSourceWizard;
import com.elixirtech.erd.util.ReportUtil;
import com.elixirtech.report2.I18N;
import com.elixirtech.report2.raw.model.Chunk;
import com.elixirtech.report2.raw.model.DataSource;
import com.elixirtech.report2.raw.model.MapElement;
import com.elixirtech.report2.raw.model.RawReport;
import com.elixirtech.report2.raw.model.Section;
import com.elixirtech.ui.SwingFactory;
import com.elixirtech.ui.SwingUtil;
import com.elixirtech.ui.TabComponent;
import com.elixirtech.util.CodeBlock;
import com.elixirtech.util.StringUtil;
import com.elixirtech.v2.repository.FileObject;
import com.elixirtech.v2.repository.Repository;
import com.elixirtech.wizard.data.FieldPanel;
import java.awt.Frame;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

class MapTab
extends TabComponent {
    private RawReport m_RawReport;
    private MapElement m_Map;
    private JTextField m_MapFile;
    private JComboBox m_DataSources;
    private JRadioButton m_OverRecord;
    private JRadioButton m_OverGroup;
    private JRadioButton m_OverAll;
    private JComboBox m_DataKey;
    private JComboBox m_DataFill;
    private DataSchema m_Schema;
    private boolean m_Initialized;
    private static final ElxLoggerJ m_Log = ElxLoggerJ.getLogger(MapTab.class);

    public MapTab(MapElement mapElement) {
        this.m_Map = mapElement;
        this.m_RawReport = (RawReport)this.m_Map.getResourceProvider();
        ArchLayout archLayout = new ArchLayout();
        this.setLayout(archLayout);
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.add(SwingFactory.newLabel("url-label"));
        this.m_MapFile = SwingFactory.newTextField("url");
        this.add(this.m_MapFile);
        this.add(SwingFactory.newDotsButton("dots", new CodeBlock((Object)this, "chooseMap")));
        this.add(SwingFactory.newLabel("DS.label"));
        this.m_DataSources = SwingFactory.newComboBox("ds", this.getDataSources());
        this.add(this.m_DataSources);
        this.m_DataSources.addItemListener(new CodeBlock((Object)this, "dsSelection"));
        this.add(SwingFactory.newButton("ADD.dots", new CodeBlock((Object)this, "addDataSource")));
        this.m_OverAll = SwingFactory.newRadioButton("DSGROUP.over-all");
        this.add(this.m_OverAll);
        this.m_OverGroup = SwingFactory.newRadioButton("DSGROUP.over-group");
        this.add(this.m_OverGroup);
        this.m_OverRecord = SwingFactory.newRadioButton("DSGROUP.over-record");
        this.add(this.m_OverRecord);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.m_OverGroup);
        buttonGroup.add(this.m_OverAll);
        buttonGroup.add(this.m_OverRecord);
        this.m_OverAll.setSelected(true);
        this.add(SwingFactory.newLabel("key-label"));
        this.m_DataKey = SwingFactory.newComboBox("key");
        this.add(this.m_DataKey);
        this.add(SwingFactory.newLabel("fill-label"));
        this.m_DataFill = SwingFactory.newComboBox("fill");
        this.add(this.m_DataFill);
        archLayout.stickLeft("url-label");
        archLayout.stickTop("url");
        archLayout.vCenter("url-label", "url");
        archLayout.putRight("url", "url-label,key-label,fill-label,DS.label", 10);
        archLayout.stickRight("dots");
        archLayout.putLeft("url", "dots");
        archLayout.stickTop("dots");
        archLayout.setHeight("dots", "url");
        archLayout.stickLeft("DS.label");
        archLayout.alignBelow("ds", "url", 10);
        archLayout.vCenter("DS.label", "ds");
        archLayout.putBelow("ADD.dots", "url", 10);
        archLayout.stickRight("ADD.dots");
        archLayout.setHeight("ADD.dots", "ds");
        archLayout.putLeft("ds", "ADD.dots");
        archLayout.alignBelow("DSGROUP.over-all", "ds", 5);
        archLayout.putRight("DSGROUP.over-group", "DSGROUP.over-all", 10);
        archLayout.putRight("DSGROUP.over-record", "DSGROUP.over-group", 10);
        archLayout.putBelow("DSGROUP.over-group", "ds", 5);
        archLayout.putBelow("DSGROUP.over-record", "ds", 5);
        archLayout.stickLeft("key-label");
        archLayout.alignBelow("key", "DSGROUP.over-all", 10);
        archLayout.vCenter("key-label", "key");
        archLayout.stickRight("key");
        archLayout.stickLeft("fill-label");
        archLayout.alignBelow("fill", "key", 5);
        archLayout.vCenter("fill-label", "fill");
        archLayout.stickRight("fill");
        I18N.ERD_MAP.injectComponents("DataSourcePage.", this);
        I18N.ERD_MAP.injectComponents("MapTab.", this);
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        SwingUtil.setEnabled(this, bl);
    }

    @Override
    public void setVisible(boolean bl) {
        super.setVisible(bl);
        if (!this.m_Initialized) {
            this.m_MapFile.setText(this.m_Map.getMapFile());
            String string = this.m_Map.getDataSource();
            if (StringUtil.isEmpty(string)) {
                string = FieldPanel.SECTION_DATASOURCE_UI;
            }
            this.m_DataSources.setSelectedItem(string);
            String string2 = this.m_Map.getDataRange();
            if ("All".equals(string2)) {
                this.m_OverAll.setSelected(true);
            } else if ("Group".equals(string2)) {
                this.m_OverGroup.setSelected(true);
            } else if ("Record".equals(string2)) {
                this.m_OverRecord.setSelected(true);
            }
            this.m_Initialized = true;
            this.dsSelection();
            this.m_DataKey.setSelectedItem(this.m_Map.getDataKey());
            this.m_DataFill.setSelectedItem(this.m_Map.getDataColumn());
        }
    }

    @Override
    public String getName() {
        return I18N.ERD.getString("MapTab.name");
    }

    @Override
    public String getMessage() {
        return I18N.ERD.getString("MapTab.message");
    }

    @Override
    public boolean containsProperty(String string) {
        if ("MapElement.MapFile".equals(string)) {
            return true;
        }
        if ("MapElement.DataKey".equals(string)) {
            return true;
        }
        return "MapElement.DataColumn".equals(string);
    }

    @Override
    public void performFinish() {
        this.m_Map.setMapFile(this.m_MapFile.getText());
        String string = (String)this.m_DataSources.getSelectedItem();
        if (FieldPanel.SECTION_DATASOURCE_UI.equals(string)) {
            this.m_Map.setDataSource("");
        } else {
            this.m_Map.setDataSource(string);
        }
        String string2 = null;
        string2 = this.m_OverAll.isSelected() ? "All" : (this.m_OverGroup.isSelected() ? "Group" : "Record");
        this.m_Map.setDataRange(string2);
        this.m_Map.setDataKey((String)this.m_DataKey.getSelectedItem());
        this.m_Map.setDataColumn((String)this.m_DataFill.getSelectedItem());
    }

    public void chooseMap() {
        ElixirFrame elixirFrame = (ElixirFrame)Elixir.get(ElixirFrame.class);
        Repository repository = (Repository)Elixir.get(Repository.class);
        RepositoryExplorer repositoryExplorer = (RepositoryExplorer)Elixir.get(RepositoryExplorer.class);
        FileType fileType = repositoryExplorer.getFileTypeJ("text/x-map");
        RepositoryChooser repositoryChooser = new RepositoryChooser((Frame)elixirFrame.getFrame(), I18N.ERD.getString("MapTab.ChooserTitle"), fileType);
        FileObject fileObject = repository.getFileJ(this.m_MapFile.getText());
        if (fileObject != null) {
            repositoryChooser.setSelection(fileObject);
        }
        repositoryChooser.setLocationRelativeTo(this);
        elixirFrame.showModal(repositoryChooser);
        if (repositoryChooser.isOk()) {
            FileObject fileObject2 = repositoryChooser.getSelection();
            this.m_MapFile.setText(fileObject2.getPath().toString());
        }
    }

    public void addDataSource() {
        DataSource dataSource = new DataSource();
        dataSource.setName(ReportUtil.getNextDataSourceName(this.m_RawReport));
        AddDataSourceWizard addDataSourceWizard = new AddDataSourceWizard(this.m_RawReport, dataSource);
        ElixirFrame elixirFrame = (ElixirFrame)Elixir.get(ElixirFrame.class);
        elixirFrame.showWizard(addDataSourceWizard);
        if (addDataSourceWizard.isFinished()) {
            this.m_DataSources.setModel(new DefaultComboBoxModel<String>(this.getDataSources()));
            this.m_DataSources.setSelectedItem(dataSource.getName());
            this.dsSelection();
        }
    }

    public void dsSelection() {
        DataSourceManager dataSourceManager = (DataSourceManager)Elixir.get(DataSourceManager.class);
        String string = (String)this.m_DataSources.getSelectedItem();
        if (string != null) {
            this.m_Schema = null;
            if (FieldPanel.SECTION_DATASOURCE_UI.equals(string)) {
                string = this.getSection().getDataSource();
            }
            try {
                DataSource dataSource = this.m_RawReport.getDataSource(string);
                if (dataSource != null) {
                    IDataSource iDataSource = dataSourceManager.getDataSource(dataSourceManager, dataSource.getDataSourceName());
                    this.m_Schema = iDataSource.getSchema();
                    this.fillCombos();
                }
            }
            catch (Throwable throwable) {
                m_Log.error((Object)(string + "error: " + throwable.toString()), throwable);
            }
        }
    }

    protected void fillCombos() {
        Object object = this.m_DataKey.getSelectedItem();
        Object object2 = this.m_DataFill.getSelectedItem();
        DefaultComboBoxModel<String> defaultComboBoxModel = new DefaultComboBoxModel<String>();
        DefaultComboBoxModel<String> defaultComboBoxModel2 = new DefaultComboBoxModel<String>();
        int n = this.m_Schema != null ? this.m_Schema.getColumnCount() : 0;
        for (int i = 0; i < n; ++i) {
            String string = this.m_Schema.getColumnName(i);
            DataType dataType = this.m_Schema.getColumnType(i);
            defaultComboBoxModel.addElement(string);
            if (!dataType.isNumeric()) continue;
            defaultComboBoxModel2.addElement(string);
        }
        this.m_DataKey.setModel(defaultComboBoxModel);
        this.m_DataFill.setModel(defaultComboBoxModel2);
        this.m_DataKey.setSelectedItem(object);
        this.m_DataFill.setSelectedItem(object2);
    }

    protected Vector<String> getDataSources() {
        Vector<String> vector = new Vector<String>();
        if (this.m_RawReport != null) {
            int n = this.m_RawReport.getDataSourceCount();
            for (int i = 0; i < n; ++i) {
                vector.addElement(this.m_RawReport.getDataSource(i).getName());
            }
            if (StringUtil.notEmpty(this.getSection().getDataSource())) {
                vector.add(0, FieldPanel.SECTION_DATASOURCE_UI);
            }
        }
        return vector;
    }

    protected Section getSection() {
        Chunk chunk = this.m_Map.getChunk();
        return chunk.getSection();
    }
}

