/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.wizard.misc;

import com.elixirtech.i18n.I18NComboBox;
import com.elixirtech.report2.I18N;
import com.elixirtech.report2.raw.model.CheckBox;
import com.elixirtech.report2.raw.model.ControlSource;
import com.elixirtech.report2.raw.model.RawModelElement;
import com.elixirtech.report2.raw.model.RawReport;
import com.elixirtech.ui.SwingFactory;
import com.elixirtech.ui.SwingUtil;
import com.elixirtech.ui.TabComponent;
import com.elixirtech.util.CodeBlock;
import com.elixirtech.wizard.data.FieldPanel;
import com.elixirtech.wizard.data.IDataPanel;
import com.elixirtech.wizard.data.ScriptPanel;
import com.elixirtech.wizard.data.URLPanel;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import javax.swing.BorderFactory;
import javax.swing.JPanel;

public class CheckBoxOnImageTab
extends TabComponent {
    public static final String[] TYPES = new String[]{"Field", "URL", "Script"};
    private static final String[] TYPE_KEYS = new String[]{"ControlSource.FIELD", "ControlSource.URL", "ControlSource.SCRIPT"};
    private CheckBox m_CheckBox;
    private I18NComboBox m_Type;
    private CardLayout m_CardLayout;
    private JPanel m_Center;
    private IDataPanel[] m_Panels;
    private CodeBlock m_Mediator = new CodeBlock((Object)this, "update");

    public CheckBoxOnImageTab(CheckBox checkBox) {
        this.m_CheckBox = checkBox;
        ControlSource controlSource = this.m_CheckBox.getOnImage();
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel(new FlowLayout(0));
        jPanel.add(SwingFactory.newLabel("onimage"));
        this.m_Type = I18NComboBox.apply(I18NComboBox.buildNames(TYPES, I18N.ERD, TYPE_KEYS));
        this.m_Type.addItemListener(this.m_Mediator);
        jPanel.add(this.m_Type);
        this.add((Component)jPanel, "North");
        RawReport rawReport = (RawReport)this.m_CheckBox.getResourceProvider();
        this.m_Panels = new IDataPanel[3];
        this.m_Panels[0] = new FieldPanel(rawReport, (RawModelElement)this.m_CheckBox, controlSource);
        this.m_Panels[1] = new URLPanel(controlSource, new String[]{"Image"});
        this.m_Panels[2] = new ScriptPanel(controlSource);
        this.m_CardLayout = new CardLayout();
        this.m_Center = new JPanel(this.m_CardLayout);
        for (int i = 0; i < this.m_Panels.length; ++i) {
            this.m_Center.add(TYPES[i], (JPanel)((Object)this.m_Panels[i]));
        }
        this.add((Component)this.m_Center, "Center");
        this.m_Type.setSelectedId(controlSource.getType());
        if (this.m_Type.getSelectedIndex() < 0) {
            this.m_Type.setSelectedIndex(0);
        }
        I18N.ERD_MAP.injectComponents("CheckBoxOnImageTab.", this);
    }

    public void update() {
        this.m_CardLayout.show(this.m_Center, this.m_Type.getSelectedId());
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        SwingUtil.setEnabled(this, bl);
        for (int i = 0; i < this.m_Panels.length; ++i) {
            SwingUtil.setEnabled((JPanel)((Object)this.m_Panels[i]), bl);
        }
    }

    @Override
    public String getName() {
        return I18N.ERD.getString("CheckBoxOnImageTab.name");
    }

    @Override
    public String getMessage() {
        return I18N.ERD.getString("CheckBoxOnImageTab.message");
    }

    @Override
    public boolean containsProperty(String string) {
        return "CheckBox.OnImage".equals(string);
    }

    @Override
    public void performFinish() {
        ControlSource controlSource = this.m_Panels[this.m_Type.getSelectedIndex()].getControlSource();
        this.m_CheckBox.setOnImage(controlSource);
    }
}

