/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.wizard.renderer;

import com.elixirtech.arch.wizard.RelativeLayoutWizardPage;
import com.elixirtech.data2.Encoding;
import com.elixirtech.report2.I18N;
import com.elixirtech.report2.raw.model.Parameter;
import com.elixirtech.report2.raw.model.RawReport;
import com.elixirtech.report2.raw.model.RenderDetails;
import com.elixirtech.ui.SwingFactory;
import com.elixirtech.ui.wizard.IWizard;
import com.elixirtech.wizard.renderer.IRenderPage;
import com.elixirtech.wizard.renderer.RenderDetailsUtil;
import com.elixirtech.wizard.renderer.RendererWizard;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class CSVPage
extends RelativeLayoutWizardPage
implements IRenderPage {
    private static final String[] QUALIFIER_NAMES = new String[]{I18N.ERD.getString("None"), "\"", "'"};
    private static final String[] QUALIFIERS = new String[]{"None", "\"", "'"};
    private RawReport m_Report;
    private JRadioButton m_Tab;
    private JRadioButton m_Semicolon;
    private JRadioButton m_Comma;
    private JRadioButton m_Space;
    private JRadioButton m_Other;
    private JTextField m_Separator;
    private JComboBox m_Qualifier;
    private JComboBox m_Encoding;

    public CSVPage() {
        super("CSV", null);
    }

    @Override
    public String getMimeType() {
        return "text/csv";
    }

    @Override
    public void setWizard(IWizard iWizard) {
        super.setWizard(iWizard);
        this.m_Report = ((RendererWizard)iWizard).getReport();
        this.m_Tab = SwingFactory.newRadioButton("tab");
        this.m_Semicolon = SwingFactory.newRadioButton("semicolon");
        this.m_Comma = SwingFactory.newRadioButton("comma");
        this.m_Space = SwingFactory.newRadioButton("space");
        this.m_Other = SwingFactory.newRadioButton("other");
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.m_Tab);
        buttonGroup.add(this.m_Semicolon);
        buttonGroup.add(this.m_Comma);
        buttonGroup.add(this.m_Space);
        buttonGroup.add(this.m_Other);
        this.m_Separator = SwingFactory.newTextField("separator");
        this.m_Separator.setColumns(2);
        this.m_Tab.setSelected(true);
        Box box = Box.createHorizontalBox();
        box.add(this.m_Tab);
        box.add(this.m_Semicolon);
        box.add(this.m_Comma);
        box.add(this.m_Space);
        box.add(this.m_Other);
        box.add(this.m_Separator);
        box.add(Box.createHorizontalGlue());
        this.m_Qualifier = new JComboBox<String>(QUALIFIER_NAMES);
        this.m_Encoding = new JComboBox(Encoding.getAllNames());
        new Encoding.ComboBoxListener(this.m_Encoding);
        this.m_Encoding.setEditable(true);
        this.m_Component.add(SwingFactory.newLabel("separator-label"));
        this.m_Component.add("separator", box);
        this.m_Component.add(SwingFactory.newLabel("qualifier-label"));
        this.m_Component.add("qualifier", this.m_Qualifier);
        this.m_Component.add(SwingFactory.newLabel("encoding-label"));
        this.m_Component.add("encoding", this.m_Encoding);
        this.stickLeft("separator-label");
        this.vCenter("separator-label", "separator");
        this.stickTop("separator");
        this.putRight("separator", "separator-label,qualifier-label,encoding-label", 10);
        this.stickLeft("qualifier-label");
        this.vCenter("qualifier-label", "qualifier");
        this.alignBelow("qualifier", "separator", 5);
        this.stickLeft("encoding-label");
        this.vCenter("encoding-label", "encoding");
        this.alignBelow("encoding", "qualifier", 5);
        this.stickRight("encoding");
        String string = "Comma";
        String string2 = QUALIFIERS[0];
        String string3 = "UTF-8";
        RenderDetails renderDetails = this.m_Report.getRenderDetails("text/csv");
        if (renderDetails != null) {
            string = renderDetails.getParameterValue("Separator", string);
            string2 = renderDetails.getParameterValue("Qualifier");
            Parameter parameter = renderDetails.getParameter("Encoding");
            if (parameter != null) {
                string3 = parameter.getValue();
            }
        }
        this.setSeparator(string);
        this.setQualifier(string2);
        this.m_Encoding.setSelectedItem(string3);
        com.elixirtech.report2.ui.I18N.REPORT_UI_MAP.injectObject(null, this, "CSVPage");
        com.elixirtech.report2.ui.I18N.REPORT_UI_MAP.injectComponents("CSVPage.", this.m_Component);
    }

    @Override
    public boolean isPageComplete() {
        return true;
    }

    @Override
    public void doFinish() {
        RenderDetails renderDetails = this.m_Report.getRenderDetails("text/csv");
        if (renderDetails == null) {
            renderDetails = new RenderDetails();
            renderDetails.setMimeType("text/csv");
            this.m_Report.addRenderDetails(renderDetails);
        }
        boolean bl = false;
        bl |= RenderDetailsUtil.setRenderDetails(renderDetails, "Separator", this.getSeparator());
        bl |= RenderDetailsUtil.setRenderDetails(renderDetails, "Qualifier", this.getQualifier());
        if (bl |= RenderDetailsUtil.setRenderDetails(renderDetails, "Encoding", (String)this.m_Encoding.getSelectedItem())) {
            this.m_Report.setDirty(true);
        }
    }

    protected String getSeparator() {
        if (this.m_Tab.isSelected()) {
            return "Tab";
        }
        if (this.m_Semicolon.isSelected()) {
            return "Semicolon";
        }
        if (this.m_Comma.isSelected()) {
            return "Comma";
        }
        if (this.m_Space.isSelected()) {
            return "Space";
        }
        return this.m_Separator.getText();
    }

    protected void setSeparator(String string) {
        if ("Tab".equals(string)) {
            this.m_Tab.setSelected(true);
        } else if ("Semicolon".equals(string)) {
            this.m_Semicolon.setSelected(true);
        } else if ("Comma".equals(string)) {
            this.m_Comma.setSelected(true);
        } else if ("Space".equals(string)) {
            this.m_Space.setSelected(true);
        } else {
            this.m_Other.setSelected(true);
            this.m_Separator.setText(string);
        }
    }

    protected void setQualifier(String string) {
        this.m_Qualifier.setSelectedIndex(0);
        for (int i = 0; i < QUALIFIER_NAMES.length; ++i) {
            if (!QUALIFIERS[i].equals(string)) continue;
            this.m_Qualifier.setSelectedIndex(i);
            break;
        }
    }

    protected String getQualifier() {
        return QUALIFIERS[this.m_Qualifier.getSelectedIndex()];
    }
}

