/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.wizard.renderer;

import com.elixirtech.arch.Elixir;
import com.elixirtech.arch.IUser;
import com.elixirtech.arch.wizard.RelativeLayoutWizardPage;
import com.elixirtech.report2.ui.I18N;
import com.elixirtech.ui.FileSaveDialog;
import com.elixirtech.ui.LCellRenderer;
import com.elixirtech.ui.SwingFactory;
import com.elixirtech.ui.wizard.IWizard;
import com.elixirtech.ui.wizard.IWizardContainer;
import com.elixirtech.ui.wizard.IWizardPage;
import com.elixirtech.util.CodeBlock;
import com.elixirtech.util.IntRange;
import com.elixirtech.util.StringUtil;
import com.elixirtech.wizard.renderer.RendererWizard;
import com.elixirtech.wizard.renderer.WizardRegistry;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ChooseRenderTypePage
extends RelativeLayoutWizardPage
implements ListSelectionListener,
ItemListener,
ChangeListener {
    private static final String SELECTED_TYPE = "wizard/RenderWizard/ChooseRendererTypePage/type";
    private static final String SAVE_PATH = "wizard/RenderWizard/ChooseRendererTypePage/savePath";
    private static final String VIEW_OPTION = "wizard/RenderWizard/ChooseRendererTypePage/viewOption";
    private static final String SAVE_OPTION = "wizard/RenderWizard/ChooseRendererTypePage/saveOption";
    private JTabbedPane m_Tabs;
    private JList m_Standard;
    private JList m_Web;
    private JList m_Others;
    private JCheckBox m_Preview;
    private JLabel m_RangeLabel;
    private JRadioButton m_All;
    private JRadioButton m_Range;
    private JTextField m_PageRange;
    private JCheckBox m_Save;
    private JTextField m_Filename;
    private JButton m_Browse;
    private static String m_LastFilename;
    private static boolean m_WasSaveMode;
    private static boolean m_WasViewMode;
    private static String m_OldRange;

    public ChooseRenderTypePage() {
        super("RenderType", "<dynamic>");
        this.setIcon(RendererWizard.ICON);
        this.setTitle(I18N.REPORT_UI.getString("ChooseRenderTypePage.title"));
        this.setMessage(I18N.REPORT_UI.getString("ChooseRenderTypePage.message"));
    }

    @Override
    public void setWizard(IWizard iWizard) {
        super.setWizard(iWizard);
        this.m_Tabs = SwingFactory.newTabbedPane("type-list");
        this.m_Standard = this.buildJList();
        this.m_Web = this.buildJList();
        this.m_Others = this.buildJList();
        this.m_Tabs.addTab(this.getResourceString("Standard"), new JScrollPane(this.m_Standard));
        this.m_Tabs.addTab(this.getResourceString("Web"), new JScrollPane(this.m_Web));
        this.m_Tabs.addTab(this.getResourceString("Others"), new JScrollPane(this.m_Others));
        this.m_Preview = SwingFactory.newCheckBox("preview");
        this.m_RangeLabel = SwingFactory.newLabel("range-label");
        this.m_All = SwingFactory.newRadioButton("all-radio");
        this.m_Range = SwingFactory.newRadioButton("range-radio");
        this.m_PageRange = SwingFactory.newTextField("range");
        this.m_Save = SwingFactory.newCheckBox("save");
        this.m_Filename = SwingFactory.newTextField("filename");
        this.m_Browse = SwingFactory.newDotsButton(new CodeBlock((Object)this, "browse"));
        this.m_Component.add(this.m_Tabs);
        this.m_Component.add(this.m_Preview);
        this.m_Component.add(this.m_RangeLabel);
        this.m_Component.add(this.m_All);
        this.m_Component.add(this.m_Range);
        this.m_Component.add(this.m_PageRange);
        this.m_Component.add(this.m_Save);
        this.m_Component.add(this.m_Filename);
        this.m_Component.add("browse", this.m_Browse);
        this.m_Preview.setSelected(m_WasViewMode);
        this.m_Save.setSelected(m_WasSaveMode);
        this.m_PageRange.setText(m_OldRange);
        this.m_Filename.setText(m_LastFilename);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.m_All);
        buttonGroup.add(this.m_Range);
        if (StringUtil.isEmpty(m_OldRange)) {
            this.m_All.setSelected(true);
        } else {
            this.m_Range.setSelected(true);
        }
        this.m_Tabs.addChangeListener(this);
        this.m_Preview.addItemListener(this);
        CodeBlock codeBlock = new CodeBlock((Object)this, "rangeChanged");
        this.m_All.addItemListener(codeBlock);
        this.m_Range.addItemListener(codeBlock);
        this.m_PageRange.getDocument().addDocumentListener(codeBlock);
        this.m_Save.addItemListener(this);
        this.stickTop("type-list");
        this.stickLeft("type-list");
        this.stickRight("type-list");
        this.putAbove("type-list", "preview", 5);
        this.putAbove("preview", "save,filename,browse", 5);
        this.stickLeft("preview");
        this.putRight("range-label", "preview", 20);
        this.vCenter("range-label", "preview");
        this.putRight("all-radio", "range-label", 10);
        this.vCenter("all-radio", "range-label");
        this.putRight("range-radio", "all-radio", 10);
        this.vCenter("range-radio", "range-label");
        this.putRight("range", "range-radio", 10);
        this.vCenter("range", "range-label");
        this.stickRight("range");
        this.stickBottom("save");
        this.stickLeft("save");
        this.putRight("filename", "save", 10);
        this.putLeft("filename", "browse");
        this.stickBottom("filename");
        this.stickRight("browse");
        this.setHeight("browse", "filename");
        this.stickBottom("browse");
        this.buildList();
        this.rangeChanged();
        I18N.REPORT_UI_MAP.injectComponents("ChooseRenderTypePage.", this.m_Component);
    }

    public JList getCurrentJList() {
        int n = this.m_Tabs.getSelectedIndex();
        if (n == 0) {
            return this.m_Standard;
        }
        if (n == 1) {
            return this.m_Web;
        }
        if (n == 2) {
            return this.m_Others;
        }
        return null;
    }

    public WizardRegistry.RenderType getRenderType() {
        return (WizardRegistry.RenderType)this.getCurrentJList().getSelectedValue();
    }

    public String getFilename() {
        m_LastFilename = this.m_Filename.getText();
        return m_LastFilename;
    }

    public boolean isPreview() {
        m_WasViewMode = this.m_Preview.isSelected();
        return m_WasViewMode && this.m_Preview.isEnabled();
    }

    public boolean isSave() {
        m_WasSaveMode = this.m_Save.isSelected();
        return m_WasSaveMode && this.m_Save.isEnabled();
    }

    public String getRange() {
        m_OldRange = this.m_All.isSelected() ? "" : this.m_PageRange.getText();
        return m_OldRange;
    }

    public void rangeChanged() {
        this.m_PageRange.setEnabled(this.m_Range.isSelected());
        IWizardContainer iWizardContainer = this.m_Wizard.getContainer();
        if (iWizardContainer != null) {
            iWizardContainer.updateButtons();
        }
    }

    @Override
    public boolean canFlipToNextPage() {
        boolean bl = true;
        this.setError(null);
        WizardRegistry.RenderType renderType = this.getRenderType();
        if (renderType == null) {
            this.setError(I18N.REPORT_UI.getString("ChooseRenderTypePage.chooseOutputType"));
            bl = false;
        } else if (!this.isValidRange()) {
            this.setError(I18N.REPORT_UI.getString("ChooseRenderTypePage.invalidpage"));
            bl = false;
        } else {
            boolean bl2;
            if ("Print".equals(renderType.dsClass)) {
                IWizardContainer iWizardContainer = this.m_Wizard.getContainer();
                if (iWizardContainer != null) {
                    iWizardContainer.updateMessage();
                }
                return bl;
            }
            boolean bl3 = bl2 = this.m_Preview.isSelected() || this.m_Save.isSelected();
            if (!bl2) {
                this.setError(I18N.REPORT_UI.getString("ChooseRenderTypePage.preview"));
                bl = false;
            }
        }
        IWizardContainer iWizardContainer = this.m_Wizard.getContainer();
        if (iWizardContainer != null) {
            iWizardContainer.updateMessage();
        }
        return bl;
    }

    @Override
    public IWizardPage getNextPage() {
        WizardRegistry.RenderType renderType = this.getRenderType();
        if (renderType != null) {
            return this.m_Wizard.getPage(renderType.name);
        }
        return null;
    }

    @Override
    public boolean isPageComplete() {
        WizardRegistry.RenderType renderType = this.getRenderType();
        if (renderType == null) {
            return false;
        }
        if ("Print".equals(renderType.dsClass)) {
            return this.isValidRange();
        }
        boolean bl = this.m_Preview.isSelected() || this.m_Save.isSelected();
        return bl && this.isValidRange();
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        this.updateContents();
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        this.updateContents();
    }

    public void saveChoices() {
        IUser iUser = (IUser)Elixir.get(IUser.class);
        WizardRegistry.RenderType renderType = this.getRenderType();
        if (renderType != null) {
            iUser.setString(SELECTED_TYPE, renderType.name);
        }
        iUser.setString(SAVE_PATH, this.m_Filename.getText());
        iUser.setString(VIEW_OPTION, this.m_Preview.isSelected() ? "true" : "false");
        iUser.setString(SAVE_OPTION, this.m_Save.isSelected() ? "true" : "false");
    }

    private boolean isValidRange() {
        if (this.m_All.isSelected()) {
            return true;
        }
        String string = this.m_PageRange.getText();
        try {
            new IntRange(string);
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    private void updateContents() {
        IWizardContainer iWizardContainer;
        boolean bl = true;
        boolean bl2 = true;
        boolean bl3 = true;
        WizardRegistry.RenderType renderType = this.getRenderType();
        if (renderType != null) {
            if ("Print".equals(renderType.dsClass)) {
                bl = false;
                bl2 = false;
            } else if ("Interactive".equals(renderType.dsClass)) {
                bl2 = false;
                bl3 = false;
            }
            this.m_Preview.setEnabled(bl2);
            if (!bl2) {
                this.m_Preview.setSelected(false);
            }
            this.m_Save.setEnabled(bl);
            this.m_Filename.setEnabled(bl);
            this.m_Browse.setEnabled(bl);
            this.m_RangeLabel.setEnabled(bl3);
            this.m_All.setEnabled(bl3);
            this.m_Range.setEnabled(bl3);
            this.m_PageRange.setEnabled(bl3);
            if (!bl3) {
                this.m_All.setSelected(true);
            }
            this.rangeChanged();
        }
        if ((iWizardContainer = this.m_Wizard.getContainer()) != null) {
            iWizardContainer.updateButtons();
        }
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        IWizardContainer iWizardContainer = this.m_Wizard.getContainer();
        if (iWizardContainer != null) {
            iWizardContainer.updateButtons();
        }
    }

    public void browse() {
        FileSaveDialog fileSaveDialog = new FileSaveDialog();
        fileSaveDialog.setSelectedFile(new File(this.m_Filename.getText()));
        if (fileSaveDialog.showSaveDialog(this.m_Component) == 0) {
            File file = fileSaveDialog.getSelectedFile();
            this.m_Filename.setText(file.getAbsolutePath());
        }
    }

    protected void buildList() {
        DefaultListModel<WizardRegistry.RenderType> defaultListModel = new DefaultListModel<WizardRegistry.RenderType>();
        DefaultListModel<WizardRegistry.RenderType> defaultListModel2 = new DefaultListModel<WizardRegistry.RenderType>();
        DefaultListModel<WizardRegistry.RenderType> defaultListModel3 = new DefaultListModel<WizardRegistry.RenderType>();
        WizardRegistry.RenderType[] renderTypeArray = WizardRegistry.getTypes();
        for (int i = 0; i < renderTypeArray.length; ++i) {
            if ("Standard".equals(renderTypeArray[i].category)) {
                defaultListModel.addElement(renderTypeArray[i]);
            } else if ("Web".equals(renderTypeArray[i].category)) {
                defaultListModel2.addElement(renderTypeArray[i]);
            }
            if (!"Others".equals(renderTypeArray[i].category)) continue;
            defaultListModel3.addElement(renderTypeArray[i]);
        }
        this.m_Standard.setModel(defaultListModel);
        this.m_Web.setModel(defaultListModel2);
        this.m_Others.setModel(defaultListModel3);
        IUser iUser = (IUser)Elixir.get(IUser.class);
        String string = iUser.getString(SELECTED_TYPE, null);
        if (string != null) {
            this.setSelectedValue(string);
        }
    }

    protected JList buildJList() {
        JList jList = SwingFactory.newList();
        jList.setLayoutOrientation(1);
        jList.setVisibleRowCount(0);
        jList.setCellRenderer(new LCellRenderer());
        jList.addListSelectionListener(this);
        return jList;
    }

    protected void setSelectedValue(String string) {
        WizardRegistry.RenderType[] renderTypeArray = WizardRegistry.getTypes();
        for (int i = 0; i < renderTypeArray.length; ++i) {
            if (!renderTypeArray[i].name.equals(string)) continue;
            String string2 = renderTypeArray[i].category;
            if ("Standard".equals(string2)) {
                this.m_Standard.setSelectedValue(renderTypeArray[i], true);
                this.m_Tabs.setSelectedIndex(0);
            }
            if ("Web".equals(string2)) {
                this.m_Web.setSelectedValue(renderTypeArray[i], true);
                this.m_Tabs.setSelectedIndex(1);
            }
            if (!"Others".equals(string2)) break;
            this.m_Others.setSelectedValue(renderTypeArray[i], true);
            this.m_Tabs.setSelectedIndex(2);
            break;
        }
    }

    private String getResourceString(String string) {
        return I18N.REPORT_UI.getString("ChooseRenderTypePage-" + string);
    }

    static {
        m_WasViewMode = true;
        m_OldRange = "";
        IUser iUser = (IUser)Elixir.get(IUser.class);
        m_LastFilename = iUser.getString(SAVE_PATH, "");
        m_WasSaveMode = "true".equals(iUser.getString(SAVE_OPTION, "false"));
        m_WasViewMode = "true".equals(iUser.getString(VIEW_OPTION, "true"));
    }
}

