/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.wizard.renderer;

import com.elixirtech.arch.wizard.RelativeLayoutWizardPage;
import com.elixirtech.report2.raw.model.RawReport;
import com.elixirtech.report2.raw.model.RenderDetails;
import com.elixirtech.report2.ui.I18N;
import com.elixirtech.ui.SwingFactory;
import com.elixirtech.ui.wizard.IWizard;
import com.elixirtech.wizard.renderer.IRenderPage;
import com.elixirtech.wizard.renderer.RenderDetailsUtil;
import com.elixirtech.wizard.renderer.RendererWizard;
import javax.swing.JCheckBox;

public class DebugPage
extends RelativeLayoutWizardPage
implements IRenderPage {
    private RawReport m_Report;
    private JCheckBox m_Paged;

    public DebugPage() {
        super("Debug", null);
    }

    @Override
    public String getMimeType() {
        return "text/x-rml-logical";
    }

    @Override
    public void setWizard(IWizard iWizard) {
        super.setWizard(iWizard);
        this.m_Report = ((RendererWizard)iWizard).getReport();
        this.m_Paged = SwingFactory.newCheckBox("paged");
        boolean bl = true;
        RenderDetails renderDetails = this.m_Report.getRenderDetails("text/x-rml-logical");
        if (renderDetails != null) {
            bl = renderDetails.isSet("Paged");
        }
        this.m_Paged.setSelected(bl);
        this.m_Component.add(this.m_Paged);
        this.stickTop("paged");
        this.stickLeft("paged");
        I18N.REPORT_UI_MAP.injectComponents("DebugPage.", this.m_Component);
    }

    @Override
    public boolean isPageComplete() {
        return true;
    }

    @Override
    public void doFinish() {
        RenderDetails renderDetails = this.m_Report.getRenderDetails("text/x-rml-logical");
        if (renderDetails == null) {
            renderDetails = new RenderDetails();
            renderDetails.setMimeType("text/x-rml-logical");
            this.m_Report.addRenderDetails(renderDetails);
        }
        boolean bl = false;
        if (bl |= RenderDetailsUtil.setRenderDetails(renderDetails, "Paged", this.m_Paged.isSelected() ? "Yes" : "No")) {
            this.m_Report.setDirty(true);
        }
    }
}

